/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.util;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.XmlDocumentScanner;
import oracle.bali.xml.dom.buffer.util.EncodingParser;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;

public class EncodingUtils {
    public static final int DEFAULT_ENCODING_SCAN_SIZE = 512;
    public static final String DEFAULT_ENCODING_UTF8 = "UTF-8";
    private static Logger _sLogger = null;
    private static final String _ERROR = "Unexpected exception encountered while determining file encoding";

    public static int fillEncodingScanArray(InputStream inputStream, byte[] byArray, int n) {
        int n2 = 0;
        if (inputStream != null) {
            try {
                int n3 = 0;
                int n4 = n;
                while (n4 > 0) {
                    n3 = inputStream.read(byArray, n2, n4);
                    if (n3 != -1) {
                        n2 += n3;
                        n4 -= n3;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                EncodingUtils._getLogger().log(Level.SEVERE, _ERROR, exception);
            }
        }
        return n2;
    }

    public static String getEncodingClass(byte[] byArray, int n) {
        String string = DEFAULT_ENCODING_UTF8;
        if (n > 4) {
            int[] nArray = new int[4];
            int n2 = 0;
            while (n2 < 4) {
                nArray[n2] = byArray[n2] & 0xFF;
                ++n2;
            }
            boolean bl = false;
            if (nArray[0] == 254 && nArray[1] == 255 && (nArray[2] != 0 || nArray[3] != 0)) {
                bl = true;
                string = "UTF-16BE";
            } else if (nArray[0] == 255 && nArray[1] == 254 && (nArray[2] != 0 || nArray[3] != 0)) {
                bl = true;
                string = "UTF-16LE";
            } else if (nArray[0] == 239 && nArray[1] == 187 && nArray[2] == 191) {
                bl = true;
                string = DEFAULT_ENCODING_UTF8;
            }
            if (!bl) {
                if (nArray[0] == 0 && nArray[1] == 60 && nArray[2] == 0 && nArray[3] == 63) {
                    string = "UTF-16BE";
                } else if (nArray[0] == 60 && nArray[1] == 0 && nArray[2] == 63 && nArray[3] == 0) {
                    string = "UTF-16LE";
                } else if (nArray[0] == 76 && nArray[1] == 111 && nArray[2] == 167 && nArray[3] == 148) {
                    string = "Cp037";
                }
            }
        }
        return string;
    }

    public static String getScanText(byte[] byArray, int n, String string) {
        String string2 = "";
        if (n > 0) {
            try {
                string2 = DEFAULT_ENCODING_UTF8.equals(string) ? new String(byArray, 0, n, "ISO-8859-1") : new String(byArray, 0, n, string);
            }
            catch (Exception exception) {
                EncodingUtils._getLogger().log(Level.SEVERE, _ERROR, exception);
            }
        }
        return string2;
    }

    public static ReadTextBuffer getTemporaryTextBuffer(byte[] byArray, int n, String string) {
        String string2 = EncodingUtils.getScanText(byArray, n, string);
        return TextBufferFactory.createReadTextBuffer((String)string2);
    }

    public static AttributeLocator getEncodingAttributeLocator(ReadTextBuffer readTextBuffer) {
        AttributeLocator attributeLocator = null;
        if (readTextBuffer != null) {
            XmlDocumentScanner xmlDocumentScanner = new XmlDocumentScanner();
            EncodingParser encodingParser = new EncodingParser(xmlDocumentScanner);
            try {
                attributeLocator = encodingParser.findEncodingLocator(readTextBuffer);
            }
            catch (Exception exception) {
                attributeLocator = null;
                EncodingUtils._getLogger().log(Level.SEVERE, _ERROR, exception);
            }
        }
        return attributeLocator;
    }

    public static String getAttributeValue(ReadTextBuffer readTextBuffer, AttributeLocator attributeLocator) {
        TextLocator textLocator;
        String string = null;
        if (readTextBuffer != null && attributeLocator != null && (textLocator = attributeLocator.getValueLocator()) != null) {
            int n;
            int n2 = ((Locator)textLocator).getStartOffset();
            if (attributeLocator.isStartQuotePresent()) {
                ++n2;
            }
            int n3 = ((Locator)textLocator).getEndOffset();
            if (attributeLocator.isEndQuotePresent()) {
                --n3;
            }
            if ((n = n3 - n2) > 0) {
                try {
                    string = readTextBuffer.getString(n2, n);
                }
                catch (Exception exception) {
                    string = null;
                }
            }
        }
        return string;
    }

    private static Logger _getLogger() {
        if (_sLogger == null) {
            _sLogger = Logger.getLogger(EncodingUtils.class.getName());
        }
        return _sLogger;
    }
}

