/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractAttrChange
extends DomChange {
    private final NodeRef _attrRef;
    private final NodeRef _ownerElementRef;
    private final Attr _attr;

    protected AbstractAttrChange(Attr attr, Node node) {
        this(attr, NodeRefFactory.getNodeRef((Node)node));
    }

    protected AbstractAttrChange(Attr attr, NodeRef nodeRef) {
        this._attrRef = NodeRefFactory.getAttrRef((NodeRef)nodeRef, (Attr)attr);
        this._ownerElementRef = nodeRef;
        this._attr = (Attr)AbstractAttrChange.cloneNode(attr);
    }

    public final NodeRef getNodeRef() {
        return this._attrRef;
    }

    public final NodeRef getOwnerElementRef() {
        return this._ownerElementRef;
    }

    public final String getAffectedAttrLocalName() {
        return DomUtils.getLocalName((Node)this._attr);
    }

    public final String getAffectedAttrNamespace() {
        return this._attr.getNamespaceURI();
    }

    public Element getOwnerElement(Document document) {
        Node node = this._ownerElementRef.getCorrespondingNode(document);
        if (node != null && node.getNodeType() == 1) {
            Element element = (Element)node;
            return element;
        }
        throw new IllegalStateException("Parent element of attribute " + this._attr + " not found along given path in document " + document);
    }

    protected final Attr getAffectedAttrClone() {
        return this._attr;
    }
}

