/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.RelatedChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.share.ReverseListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DomChange {
    public static final int PRE_UNDO_INDEX = 0;
    public static final int POST_UNDO_INDEX = 1;
    public static final int PRE_REDO_INDEX = 2;
    public static final int POST_REDO_INDEX = 3;
    private List _relatedChanges;

    private static Iterator _getIterator(List list, boolean bl) {
        if (bl) {
            return list.iterator();
        }
        return new ReverseListIterator(list);
    }

    public final void deliverRelatedChanges(DomModel domModel, int n) {
        DomChange.deliverRelatedChanges(this._getRelatedChangesNonNull(), this, domModel, n);
    }

    public static void deliverRelatedChanges(List list, DomChange domChange, DomModel domModel, int n) {
        boolean bl = n == 2 || n == 3;
        Iterator iterator = DomChange._getIterator(list, bl);
        while (iterator.hasNext()) {
            RelatedChange relatedChange = (RelatedChange)iterator.next();
            if (relatedChange == null) continue;
            switch (n) {
                case 0: {
                    relatedChange.preUndo(domModel, domChange);
                    break;
                }
                case 1: {
                    relatedChange.postUndo(domModel, domChange);
                    break;
                }
                case 2: {
                    relatedChange.preRedo(domModel, domChange);
                    break;
                }
                case 3: {
                    relatedChange.postRedo(domModel, domChange);
                }
            }
        }
    }

    public final void addRelatedChange(RelatedChange relatedChange) {
        this.addRelatedChanges(Collections.singletonList(relatedChange));
    }

    public final void addRelatedChanges(List list) {
        if (this._relatedChanges == null) {
            this._relatedChanges = new ArrayList();
        }
        this._relatedChanges.addAll(list);
    }

    public final void addRelatedChanges(DomChange domChange) {
        this.addRelatedChanges(domChange._getRelatedChangesNonNull());
    }

    public abstract void process(DomChangeHandler var1);

    public abstract DomChange getOppositeChange();

    public abstract NodeRef getNodeRef();

    public boolean canMergeWith(DomChange domChange) {
        return false;
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? string : string.substring(n + 1);
        return string2 + ": " + this.getNodeRef();
    }

    protected static Node cloneNode(Node node) {
        Document document = DomUtils.getScratchDocument();
        return document.importNode(node, true);
    }

    protected final boolean sameNodeRef(DomChange domChange) {
        return this.getNodeRef().equals((Object)domChange.getNodeRef());
    }

    private List _getRelatedChangesNonNull() {
        List list = this._relatedChanges != null ? this._relatedChanges : Collections.EMPTY_LIST;
        return list;
    }

    void $init$() {
        this._relatedChanges = null;
    }

    public DomChange() {
        this.$init$();
    }
}

