/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DomChangeApplier
implements DomChangeHandler {
    protected abstract Document getDocument();

    public void handleAttrAddedChange(AttrAddedChange attrAddedChange) {
        this.preHook(attrAddedChange);
        DomUtils.addAttr((Element)attrAddedChange.getOwnerElement(this.getDocument()), (Attr)attrAddedChange.getAddedAttributeClone());
        this.postHook(attrAddedChange);
    }

    public void handleAttrRemovedChange(AttrRemovedChange attrRemovedChange) {
        this.preHook(attrRemovedChange);
        DomUtils.removeAttr((Element)attrRemovedChange.getOwnerElement(this.getDocument()), (Attr)attrRemovedChange.getRemovedAttributeClone());
        this.postHook(attrRemovedChange);
    }

    public void handleAttrValueChange(AttrValueChange attrValueChange) {
        this.preHook(attrValueChange);
        Attr attr = attrValueChange.getChangedAttr(this.getDocument());
        attr.setValue(attrValueChange.getNewValue());
        this.postHook(attrValueChange);
    }

    public void handleNodeInsertedChange(NodeInsertedChange nodeInsertedChange) {
        this.preHook(nodeInsertedChange);
        DomUtils.addChild((Document)this.getDocument(), (NodeRef)nodeInsertedChange.getNodeRef(), (Node)nodeInsertedChange.getInsertedNodeClone());
        this.postHook(nodeInsertedChange);
    }

    public void handleNodeRemovedChange(NodeRemovedChange nodeRemovedChange) {
        this.preHook(nodeRemovedChange);
        DomUtils.removeChild((Document)this.getDocument(), (NodeRef)nodeRemovedChange.getNodeRef());
        this.postHook(nodeRemovedChange);
    }

    public void handleNodeValueChange(NodeValueChange nodeValueChange) {
        this.preHook(nodeValueChange);
        Node node = nodeValueChange.getNodeRef().getCorrespondingNode(this.getDocument());
        node.setNodeValue(nodeValueChange.getNewValue());
        this.postHook(nodeValueChange);
    }

    protected void preHook(DomChange domChange) {
    }

    protected void postHook(DomChange domChange) {
    }
}

