/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;

public abstract class DomChangesUndoableEdit
extends AbstractUndoableEdit {
    private ArrayList _subEdits;
    private DomChange[] _changeInfos;

    protected DomChangesUndoableEdit(DomChange[] domChangeArray) {
        this.$init$();
        this._changeInfos = domChangeArray;
    }

    public void processChanges(DomChangeHandler domChangeHandler) {
        int n = 0;
        while (n < this.getChangeCount()) {
            this._process(this.getChange(n), domChangeHandler);
            ++n;
        }
    }

    public void processChangesInReverse(DomChangeHandler domChangeHandler) {
        int n = this.getChangeCount() - 1;
        while (n >= 0) {
            this._process(this.getChange(n), domChangeHandler);
            --n;
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        if (this._subEdits != null) {
            int n = 0;
            while (n < this._subEdits.size()) {
                UndoableEdit undoableEdit = (UndoableEdit)this._subEdits.get(n);
                undoableEdit.undo();
                ++n;
            }
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        if (this._subEdits != null) {
            int n = 0;
            while (n < this._subEdits.size()) {
                UndoableEdit undoableEdit = (UndoableEdit)this._subEdits.get(n);
                undoableEdit.redo();
                ++n;
            }
        }
    }

    public final boolean addEdit(UndoableEdit undoableEdit) {
        if (this.getClass() == undoableEdit.getClass()) {
            DomChangesUndoableEdit domChangesUndoableEdit = (DomChangesUndoableEdit)undoableEdit;
            String string = this.getPresentationName();
            String string2 = domChangesUndoableEdit.getPresentationName();
            boolean bl = string == null ? string2 == null : string.equals(string2);
            if (bl && this.canAddEdit(domChangesUndoableEdit)) {
                int n;
                DomChange domChange;
                DomChange domChange2;
                int n2 = this.getChangeCount();
                int n3 = domChangesUndoableEdit.getChangeCount();
                if (n2 >= 1 && n3 >= 1 && (domChange2 = this.getChange(n2 - 1)).canMergeWith(domChange = domChangesUndoableEdit.getChange(0)) && (n = this._length(this._subEdits)) <= 1 && this._length(domChangesUndoableEdit._subEdits) == n) {
                    UndoableEdit undoableEdit2;
                    UndoableEdit undoableEdit3;
                    if (n == 1 && !(undoableEdit3 = (UndoableEdit)this._subEdits.get(0)).addEdit(undoableEdit2 = (UndoableEdit)domChangesUndoableEdit._subEdits.get(0))) {
                        return false;
                    }
                    int n4 = n2 + n3;
                    DomChange[] domChangeArray = new DomChange[n4];
                    System.arraycopy(this._changeInfos, 0, domChangeArray, 0, n2);
                    System.arraycopy(domChangesUndoableEdit._changeInfos, 0, domChangeArray, n2, n3);
                    this._changeInfos = domChangeArray;
                    this.addEditImpl(domChangesUndoableEdit);
                    return true;
                }
            }
        }
        return false;
    }

    public void addSubEdit(UndoableEdit undoableEdit) {
        if (this._subEdits == null) {
            this._subEdits = new ArrayList(1);
        }
        this._subEdits.add(undoableEdit);
    }

    public void die() {
        super.die();
        if (this._subEdits != null) {
            int n = 0;
            while (n < this._subEdits.size()) {
                ((UndoableEdit)this._subEdits.get(n)).die();
                ++n;
            }
            this._subEdits = null;
        }
        this._changeInfos = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\nname=");
        stringBuffer.append(this.getPresentationName());
        int n = 0;
        while (n < this.getChangeCount()) {
            stringBuffer.append("\nchange #");
            stringBuffer.append(n);
            stringBuffer.append(":");
            stringBuffer.append(this.getChange(n));
            ++n;
        }
        stringBuffer.append("\nsubedits: ");
        stringBuffer.append(this._subEdits);
        return stringBuffer.toString();
    }

    protected final int getChangeCount() {
        return this._changeInfos.length;
    }

    protected final DomChange getChange(int n) {
        return this._changeInfos[n];
    }

    protected boolean canAddEdit(DomChangesUndoableEdit domChangesUndoableEdit) {
        return true;
    }

    protected void addEditImpl(DomChangesUndoableEdit domChangesUndoableEdit) {
    }

    private int _length(Collection collection) {
        return collection == null ? 0 : collection.size();
    }

    private void _process(DomChange domChange, DomChangeHandler domChangeHandler) {
        domChange.process(domChangeHandler);
    }

    void $init$() {
        this._subEdits = null;
    }
}

