/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import oracle.bali.xml.dom.changes.AbstractNodeChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.share.string.StringChange;
import oracle.bali.xml.share.string.StringChangeUtils;
import org.w3c.dom.Node;

public class NodeValueChange
extends AbstractNodeChange {
    private final String _prevValue;
    private final String _newValue;
    private final StringChange _stringChange;

    public NodeValueChange(Node node, String string, String string2) {
        super(node);
        this._prevValue = string;
        this._newValue = string2;
        this._stringChange = this._computeStringChange();
    }

    private NodeValueChange(NodeRef nodeRef, Node node, String string, String string2) {
        super(nodeRef, node);
        this._prevValue = string;
        this._newValue = string2;
        this._stringChange = this._computeStringChange();
    }

    public void process(DomChangeHandler domChangeHandler) {
        domChangeHandler.handleNodeValueChange(this);
    }

    public DomChange getOppositeChange() {
        return new NodeValueChange(this.getNodeRef(), this.getAffectedNodeClone(), this.getNewValue(), this.getPrevValue());
    }

    public String getPrevValue() {
        return this._prevValue;
    }

    public String getNewValue() {
        return this._newValue;
    }

    public StringChange getStringChange() {
        return this._stringChange;
    }

    public boolean canMergeWith(DomChange domChange) {
        if (this.sameNodeRef(domChange)) {
            if (domChange.getClass() == this.getClass()) {
                NodeValueChange nodeValueChange = (NodeValueChange)domChange;
                if (this._eq(this._newValue, nodeValueChange._prevValue)) {
                    int n;
                    StringChange stringChange = this.getStringChange();
                    StringChange stringChange2 = nodeValueChange.getStringChange();
                    int n2 = stringChange.getOffset() + stringChange.getInsertionCount();
                    return n2 == (n = stringChange2.getOffset() + stringChange2.getRemovalCount());
                }
            } else if (domChange.getClass() == NodeRemovedChange.class) {
                return true;
            }
        }
        return false;
    }

    private boolean _eq(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private StringChange _computeStringChange() {
        return StringChangeUtils.computeStringChange(this._prevValue, this._newValue);
    }
}

