/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.base.BaseDomModel;
import oracle.bali.xml.dom.parser.TextSynchronizer;
import oracle.bali.xml.dom.traversal.SimulateInsertingFragmentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;
import oracle.bali.xml.sax.StringCaptureXmlFilter;
import oracle.bali.xml.sax.TreeWalkerXmlReader;
import oracle.bali.xml.share.BaliXmlProvider;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ParserDomModel
extends BaseDomModel {
    private volatile int _synchedChangeCount;
    private volatile boolean _forceSync;
    private volatile boolean _syncInProgress;
    private volatile boolean _needsInit;
    private TextSynchronizer _textSource;
    private final BaliXmlProvider _parser;
    private final ReadWriteLock _lock;

    public ParserDomModel(DomModelContext domModelContext, BaliXmlProvider baliXmlProvider, TextSynchronizer textSynchronizer, WhitespaceHandler whitespaceHandler) {
        super(domModelContext, whitespaceHandler);
        this.$init$();
        if (baliXmlProvider == null) {
            throw new IllegalArgumentException("No parser provided");
        }
        this._parser = baliXmlProvider;
        this._textSource = textSynchronizer;
    }

    public DOMImplementation getDOMImplementation() {
        return this._parser.getDOMImplementation();
    }

    public void commitTransaction() {
        boolean bl = this.isInTopLevelTransaction();
        super.commitTransaction();
        if (bl) {
            this._syncToText();
        }
    }

    public void rollbackTransaction() {
        boolean bl = this.isInTopLevelTransaction();
        super.rollbackTransaction();
        if (bl) {
            this._syncToText();
        }
    }

    public void setTextSynchronizer(TextSynchronizer textSynchronizer) {
        this._textSource = textSynchronizer;
        this._needsInit = true;
    }

    protected Document getDocumentImpl() {
        if (this._needsInit) {
            this._needsInit = false;
            this._ensureDocUpToDate();
        }
        return this.getDocumentInternal();
    }

    public void destroyDocument() {
        if (this.getDocumentInternal() != null) {
            this.replaceDocument(null);
            this._needsInit = true;
        }
    }

    public List getCurrentDomParseProblems() {
        this.verifyLock();
        return Collections.EMPTY_LIST;
    }

    public DomModel.FragmentParseResult parseFragment(Node node, Map map, String string) {
        this.acquireReadLock();
        try {
            Document document = this.getDocument();
            if (document != null) {
                StringBuffer stringBuffer = new StringBuffer(string.length() + 200);
                stringBuffer.append("<a");
                Map map2 = NamespaceUtils.getPrefixesInScope(node);
                map2.putAll(map);
                if (!map2.isEmpty()) {
                    for (Map.Entry entry : map2.entrySet()) {
                        stringBuffer.append(" xmlns");
                        String string2 = (String)entry.getKey();
                        if (string2.length() > 0) {
                            stringBuffer.append(':');
                            stringBuffer.append(string2);
                        }
                        stringBuffer.append("=\"");
                        stringBuffer.append(entry.getValue());
                        stringBuffer.append("\"");
                    }
                }
                stringBuffer.append(">");
                stringBuffer.append(string);
                stringBuffer.append("</a>");
                InputSource inputSource = new InputSource(new StringReader(stringBuffer.toString()));
                try {
                    Document document2 = this._parser.parseDocument(inputSource);
                    DocumentFragment documentFragment = document.createDocumentFragment();
                    Node node2 = document2.getDocumentElement().getFirstChild();
                    while (node2 != null) {
                        Node node3 = document.importNode(node2, true);
                        documentFragment.appendChild(node3);
                        node2 = node2.getNextSibling();
                    }
                    if (DomUtils.isElement((Node)node)) {
                        SimulateInsertingFragmentTreeTraversal simulateInsertingFragmentTreeTraversal = new SimulateInsertingFragmentTreeTraversal((Element)node, documentFragment);
                        node2 = documentFragment.getFirstChild();
                        while (node2 != null) {
                            Node node4 = node2.getNextSibling();
                            WhitespaceUtils.applyWhitespaceRulesToSubtree(this.getWhitespaceHandler(), (TreeTraversal)simulateInsertingFragmentTreeTraversal, node2);
                            node2 = node4;
                        }
                    }
                    DomModel.FragmentParseResult fragmentParseResult = this.createFragmentParseResult(documentFragment);
                    this.releaseReadLock();
                    return fragmentParseResult;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    LogUtils.log((Logger)this.getLogger(), (Level)Level.WARNING, (String)"Error parsing fragment:\n{0}\ncontext node: {1}", (Object[])new Object[]{string, node}, (Throwable)throwable);
                }
            }
        }
        finally {
            this.releaseReadLock();
        }
        return null;
    }

    protected UndoableEdit removeDocTypeImpl() {
        throw new UnsupportedOperationException();
    }

    protected UndoableEdit setDocTypeImpl(String string, String string2, String string3) {
        throw new UnsupportedOperationException();
    }

    protected void refreshModel(boolean bl) {
        if (bl) {
            this._forceSync = true;
        }
        this._ensureDocUpToDate();
    }

    public boolean needsReparse() {
        return !this._syncInProgress && (this._forceSync || this._synchedChangeCount != this._textSource.getChangeId() || this._needsInit);
    }

    protected void acquireWriteLockDirectly() {
        this._lock.writeLock();
    }

    protected void releaseWriteLockDirectly() {
        this._lock.writeUnlock();
    }

    protected void acquireReadLockDirectly() {
        this._lock.readLock();
    }

    protected void releaseReadLockDirectly() {
        this._lock.readUnlock();
    }

    public int getLockStatus() {
        return this.getLockStatus(this._lock);
    }

    private void _ensureDocUpToDate() {
        if (this.needsReparse()) {
            this._forceSync = false;
            this._syncInProgress = true;
            this._synchedChangeCount = this._textSource.getChangeId();
            InputSource inputSource = new InputSource();
            inputSource.setSystemId(this._textSource.getSystemId());
            inputSource.setCharacterStream(this._textSource.getReader());
            this.acquireWriteLockDirectly();
            try {
                try {
                    Document document = this._parser.parseDocument(inputSource);
                    WhitespaceUtils.applyWhitespaceRulesToSubtree(this.getWhitespaceHandler(), null, document);
                    this.replaceDocument(document);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.replaceDocument(null);
                }
            }
            finally {
                this._syncInProgress = false;
                this.releaseWriteLockDirectly();
            }
        }
    }

    private Reader _getReaderFromModel() {
        String string;
        TreeWalker treeWalker = DomUtils.createTreeWalker((Node)this.getDocument(), (int)-1, null, null);
        TreeWalkerXmlReader treeWalkerXmlReader = new TreeWalkerXmlReader(treeWalker);
        StringCaptureXmlFilter stringCaptureXmlFilter = new StringCaptureXmlFilter((XMLReader)treeWalkerXmlReader);
        try {
            stringCaptureXmlFilter.parse(this._textSource.getSystemId());
            string = stringCaptureXmlFilter.getXMLSource();
        }
        catch (Exception exception) {
            string = "<!-- Exception in DOM to text: " + exception + " -->";
        }
        return new StringReader(string);
    }

    private void _syncToText() {
        if (!this._syncInProgress) {
            this._syncInProgress = true;
            try {
                this.acquireReadLock();
                this._textSource.contentUpdated(this._getReaderFromModel(), this._textSource.getSystemId());
            }
            finally {
                this.releaseReadLock();
                this._syncInProgress = false;
                this._synchedChangeCount = this._textSource.getChangeId();
            }
        }
    }

    void $init$() {
        this._forceSync = true;
        this._syncInProgress = false;
        this._needsInit = true;
        this._lock = new ReadWriteLock();
    }
}

