/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.tracking;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.AbstractNode;
import oracle.bali.xml.dom.tracking.TrackingAttr;
import oracle.bali.xml.dom.tracking.TrackingDocument;
import oracle.bali.xml.dom.tracking.TrackingElement;
import oracle.bali.xml.dom.tracking.TrackingEventHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TrackingNode
extends AbstractNode {
    private final TrackingEventHandler _handler;
    private final Node _realNode;
    private static final Map _nodes = new HashMap();

    protected TrackingNode(TrackingEventHandler trackingEventHandler, Node node) {
        if (node == null || trackingEventHandler == null) {
            throw new IllegalArgumentException();
        }
        this._handler = trackingEventHandler;
        this._realNode = node;
    }

    public String getNodeName() {
        this.handleRead();
        return this._realNode.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        this.handleRead();
        return this._realNode.getNodeValue();
    }

    public void setNodeValue(String string) throws DOMException {
        this.handleWrite();
        this._realNode.setNodeValue(string);
    }

    public short getNodeType() {
        this.handleRead();
        return this._realNode.getNodeType();
    }

    public Node getParentNode() {
        this.handleRead();
        return this.createTrackingNode(this._realNode.getParentNode());
    }

    public NodeList getChildNodes() {
        this.handleRead();
        return new TrackingNodeList(this._realNode.getChildNodes());
    }

    public Node getFirstChild() {
        this.handleRead();
        return this.createTrackingNode(this._realNode.getFirstChild());
    }

    public Node getLastChild() {
        this.handleRead();
        return this.createTrackingNode(this._realNode.getLastChild());
    }

    public Node getPreviousSibling() {
        this.handleRead();
        return this.createTrackingNode(this._realNode.getPreviousSibling());
    }

    public Node getNextSibling() {
        this.handleRead();
        return this.createTrackingNode(this._realNode.getNextSibling());
    }

    public NamedNodeMap getAttributes() {
        this.handleRead();
        NamedNodeMap namedNodeMap = this._realNode.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        return new TrackingNamedNodeMap(namedNodeMap);
    }

    public Document getOwnerDocument() {
        this.handleRead();
        return (Document)this.createTrackingNode(this._realNode.getOwnerDocument());
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        this.handleWrite();
        return this.createTrackingNode(this._realNode.insertBefore(node, node2));
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.handleWrite();
        return this.createTrackingNode(this._realNode.replaceChild(node, node2));
    }

    public Node removeChild(Node node) throws DOMException {
        this.handleWrite();
        return this.createTrackingNode(this._realNode.removeChild(node));
    }

    public Node appendChild(Node node) throws DOMException {
        this.handleWrite();
        return this.createTrackingNode(this._realNode.appendChild(node));
    }

    public boolean hasChildNodes() {
        this.handleRead();
        return this._realNode.hasChildNodes();
    }

    public Node cloneNode(boolean bl) {
        this.handleRead();
        return this.createTrackingNode(this._realNode.cloneNode(bl));
    }

    public void normalize() {
        this.handleWrite();
        this._realNode.normalize();
    }

    public boolean isSupported(String string, String string2) {
        this.handleRead();
        return this._realNode.isSupported(string, string2);
    }

    public String getNamespaceURI() {
        this.handleRead();
        return this._realNode.getNamespaceURI();
    }

    public String getPrefix() {
        this.handleRead();
        return this._realNode.getPrefix();
    }

    public void setPrefix(String string) throws DOMException {
        this.handleWrite();
        this._realNode.setPrefix(string);
    }

    public String getLocalName() {
        this.handleRead();
        return this._realNode.getLocalName();
    }

    public boolean hasAttributes() {
        this.handleRead();
        return this._realNode.hasAttributes();
    }

    public static Document createDocument(TrackingEventHandler trackingEventHandler, Document document) {
        return (Document)TrackingNode.createTrackingNode(trackingEventHandler, document);
    }

    public boolean equals(Object object) {
        if (object instanceof TrackingNode) {
            object = ((TrackingNode)object).getRealNode();
        }
        return this._realNode != null ? this._realNode.equals(object) : false;
    }

    public int hashCode() {
        return this._realNode.hashCode();
    }

    protected void handleRead() {
        this.getHandler().handleRead(this.getRealNode());
    }

    protected void handleWrite() {
        this.getHandler().handleWrite(this.getRealNode());
    }

    protected Node getRealNode() {
        return this._realNode;
    }

    protected TrackingEventHandler getHandler() {
        return this._handler;
    }

    protected Node createTrackingNode(Node node) {
        return TrackingNode.createTrackingNode(this.getHandler(), node);
    }

    protected static synchronized Node createTrackingNode(TrackingEventHandler trackingEventHandler, Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = (Node)_nodes.get(node);
        if (node2 == null) {
            short s = node.getNodeType();
            switch (s) {
                case 2: {
                    node2 = new TrackingAttr(trackingEventHandler, (Attr)node);
                    break;
                }
                case 1: {
                    node2 = new TrackingElement(trackingEventHandler, (Element)node);
                    break;
                }
                case 9: {
                    node2 = new TrackingDocument(trackingEventHandler, (Document)node);
                }
            }
            if (node2 == null) {
                node2 = node;
            }
            _nodes.put(node, node2);
        }
        return node2;
    }

    public class TrackingNodeList
    implements NodeList {
        private final NodeList _real;

        public TrackingNodeList(NodeList nodeList) {
            this._real = nodeList;
        }

        public int getLength() {
            return this._real.getLength();
        }

        public Node item(int n) {
            return TrackingNode.this.createTrackingNode(this._real.item(n));
        }
    }

    public class TrackingNamedNodeMap
    implements NamedNodeMap {
        private final NamedNodeMap _realMap;

        public TrackingNamedNodeMap(NamedNodeMap namedNodeMap) {
            this._realMap = namedNodeMap;
        }

        public int getLength() {
            return this._realMap.getLength();
        }

        public Node getNamedItem(String string) {
            return TrackingNode.this.createTrackingNode(this._realMap.getNamedItem(string));
        }

        public Node getNamedItemNS(String string, String string2) {
            return TrackingNode.this.createTrackingNode(this._realMap.getNamedItemNS(string, string2));
        }

        public Node item(int n) {
            return TrackingNode.this.createTrackingNode(this._realMap.item(n));
        }

        public Node removeNamedItem(String string) {
            return TrackingNode.this.createTrackingNode(this._realMap.removeNamedItem(string));
        }

        public Node removeNamedItemNS(String string, String string2) {
            return TrackingNode.this.createTrackingNode(this._realMap.removeNamedItemNS(string, string2));
        }

        public Node setNamedItem(Node node) {
            return TrackingNode.this.createTrackingNode(this._realMap.setNamedItem(node));
        }

        public Node setNamedItemNS(Node node) {
            return TrackingNode.this.createTrackingNode(this._realMap.setNamedItemNS(node));
        }
    }
}

