/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.proxy;

import java.util.HashMap;
import oracle.bali.xml.dom.util.DummyNode;
import oracle.bali.xml.dom.view.proxy.ContainerViewNode;
import oracle.bali.xml.dom.view.proxy.ViewAttr;
import oracle.bali.xml.dom.view.proxy.ViewCDATASection;
import oracle.bali.xml.dom.view.proxy.ViewComment;
import oracle.bali.xml.dom.view.proxy.ViewElement;
import oracle.bali.xml.dom.view.proxy.ViewEntity;
import oracle.bali.xml.dom.view.proxy.ViewEntityReference;
import oracle.bali.xml.dom.view.proxy.ViewEvent;
import oracle.bali.xml.dom.view.proxy.ViewNode;
import oracle.bali.xml.dom.view.proxy.ViewNotation;
import oracle.bali.xml.dom.view.proxy.ViewProcessingInstruction;
import oracle.bali.xml.dom.view.proxy.ViewText;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class ViewDocument
extends ContainerViewNode
implements DocumentEvent,
Document {
    private Document _baseDocument;
    private TreeWalker _filter;
    private static final String _ERR_MESSAGE = "Not implemented yet";
    private DocumentChangeListener _changeListener;
    private HashMap _modelToViewMap;

    public ViewDocument(Document document, TreeWalker treeWalker) {
        super(document);
        this.$init$();
        if (document == null) {
            throw new IllegalArgumentException();
        }
        this._baseDocument = document;
        this.setViewDocument(this);
        this._filter = treeWalker;
        EventTarget eventTarget = (EventTarget)((Object)document);
        this._changeListener = new DocumentChangeListener(null);
        eventTarget.addEventListener("DOMNodeInserted", this._changeListener, false);
        eventTarget.addEventListener("DOMNodeRemoved", this._changeListener, false);
        eventTarget.addEventListener("DOMAttrModified", this._changeListener, false);
    }

    public String getNodeName() {
        return "#document";
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        if (string != null) {
            throw new DOMException(7, "Documents can not have node values");
        }
    }

    public short getNodeType() {
        return 9;
    }

    public void invalidateModelSubtree(Node node) {
        Node node2;
        do {
            if ((node2 = this.modelNodeToViewNode(node)) != DummyNode.INSTANCE) continue;
            node = node2.getParentNode();
        } while (node != null);
        if (node2 != null) {
            this._modelToViewMap.clear();
            ((ViewNode)node2).invalidateChildInfo();
            MutationEvent mutationEvent = (MutationEvent)this.createEvent("MutationEvents");
            mutationEvent.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null, (short)0);
            ((EventTarget)((Object)node2)).dispatchEvent(mutationEvent);
        }
    }

    protected Node calculateParentNode(ViewNode viewNode) {
        Node node;
        Node node2 = viewNode.getProxiedNode();
        if (this._filter != null) {
            if (node2 == this._filter.getRoot()) {
                return this;
            }
            Node node3 = this._filter.getCurrentNode();
            this._filter.setCurrentNode(node2);
            node = this._filter.parentNode();
            this._filter.setCurrentNode(node3);
        } else {
            node = node2.getParentNode();
        }
        if (node != null) {
            return this.modelNodeToViewNode(node);
        }
        return null;
    }

    protected Node calculateNextSibling(ViewNode viewNode) {
        Node node = viewNode.getProxiedNode();
        if (this._filter != null) {
            Node node2 = this._filter.getCurrentNode();
            this._filter.setCurrentNode(node);
            node = this._filter.nextSibling();
            this._filter.setCurrentNode(node2);
        } else {
            node = node.getNextSibling();
        }
        ViewNode viewNode2 = this.getNodeProxy(viewNode.getViewDocument(), viewNode.getParentNode(), node);
        if (viewNode2 != null) {
            viewNode2.setPreviousSibling(viewNode);
        }
        return viewNode2;
    }

    protected Node calculatePreviousSibling(ViewNode viewNode) {
        Node node = viewNode.getProxiedNode();
        if (this._filter != null) {
            Node node2 = this._filter.getCurrentNode();
            this._filter.setCurrentNode(node);
            node = this._filter.previousSibling();
            this._filter.setCurrentNode(node2);
        } else {
            node = node.getPreviousSibling();
        }
        ViewNode viewNode2 = this.getNodeProxy(viewNode.getViewDocument(), viewNode.getParentNode(), node);
        if (viewNode2 != null) {
            viewNode2.setNextSibling(viewNode);
        }
        return viewNode2;
    }

    protected Node calculateFirstChild(ViewNode viewNode) {
        Node node = viewNode.getProxiedNode();
        if (this._filter != null) {
            Node node2 = this._filter.getCurrentNode();
            this._filter.setCurrentNode(node);
            node = this._filter.firstChild();
            this._filter.setCurrentNode(node2);
        } else {
            node = node.getFirstChild();
        }
        ViewNode viewNode2 = this.getNodeProxy(viewNode.getViewDocument(), viewNode, node);
        if (viewNode2 != null) {
            viewNode2.setPreviousSibling(null);
        }
        return viewNode2;
    }

    protected Node calculateLastChild(ViewNode viewNode) {
        Node node = viewNode.getProxiedNode();
        if (this._filter != null) {
            Node node2 = this._filter.getCurrentNode();
            this._filter.setCurrentNode(node);
            node = this._filter.lastChild();
            this._filter.setCurrentNode(node2);
        } else {
            node = node.getLastChild();
        }
        ViewNode viewNode2 = this.getNodeProxy(viewNode.getViewDocument(), viewNode, node);
        if (viewNode2 != null) {
            viewNode2.setNextSibling(null);
        }
        return viewNode2;
    }

    protected ViewNode getNodeProxy(ViewDocument viewDocument, Node node, Node node2) {
        if (node2 == null) {
            return null;
        }
        ViewNode viewNode = (ViewNode)this._modelToViewMap.get(node2);
        if (viewNode == null) {
            switch (node2.getNodeType()) {
                case 2: {
                    viewNode = new ViewAttr(node2);
                    break;
                }
                case 4: {
                    viewNode = new ViewCDATASection(node2);
                    break;
                }
                case 8: {
                    viewNode = new ViewComment(node2);
                    break;
                }
                case 11: {
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    viewNode = new ViewElement(node2);
                    break;
                }
                case 6: {
                    viewNode = new ViewEntity(node2);
                    break;
                }
                case 5: {
                    viewNode = new ViewEntityReference(node2);
                    break;
                }
                case 12: {
                    viewNode = new ViewNotation(node2);
                    break;
                }
                case 7: {
                    viewNode = new ViewProcessingInstruction(node2);
                    break;
                }
                case 3: {
                    viewNode = new ViewText(node2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown node type:" + node2.getNodeType());
                }
            }
            viewNode.setParentNode(node);
            viewNode.setViewDocument(viewDocument);
            this._modelToViewMap.put(node2, viewNode);
        }
        return viewNode;
    }

    public Node getParentNode() {
        return null;
    }

    protected Node getProxiedNode() {
        return this.getProxiedDocument();
    }

    protected Document getProxiedDocument() {
        return this._baseDocument;
    }

    public DocumentType getDoctype() {
        return this.getProxiedDocument().getDoctype();
    }

    public DOMImplementation getImplementation() {
        return this.getProxiedDocument().getImplementation();
    }

    public Element getDocumentElement() {
        return (Element)this.getFirstChild();
    }

    public Element createElement(String string) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public DocumentFragment createDocumentFragment() {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public Text createTextNode(String string) {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public Event createEvent(String string) throws DOMException {
        return null;
    }

    public Comment createComment(String string) {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public Attr createAttribute(String string) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public NodeList getElementsByTagName(String string) {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    public Element getElementById(String string) {
        throw new DOMException(15, _ERR_MESSAGE);
    }

    private boolean _isModelNodeInView(Node node) {
        int n;
        if (this._filter == null) {
            return true;
        }
        Node node2 = (Node)this._modelToViewMap.get(node);
        if (node2 == DummyNode.INSTANCE) {
            return false;
        }
        if (node2 != null) {
            return true;
        }
        short s = node.getNodeType();
        int n2 = this._filter.getWhatToShow();
        if ((n2 & (n = 1 << s - 1)) == 0) {
            return false;
        }
        NodeFilter nodeFilter = this._filter.getFilter();
        if (nodeFilter != null && nodeFilter.acceptNode(node) != 1) {
            return false;
        }
        if (node == this._filter.getRoot()) {
            return true;
        }
        Node node3 = this._filter.getCurrentNode();
        this._filter.setCurrentNode(node);
        Node node4 = this._filter.parentNode();
        this._filter.setCurrentNode(node3);
        if (node4 == null) {
            return false;
        }
        return this._isModelNodeInView(node4);
    }

    public Node modelNodeToViewNode(Node node) throws DOMException {
        Document document = node.getOwnerDocument();
        if (document != this._baseDocument) {
            throw new DOMException(4, "Not model document:" + document);
        }
        Node node2 = (Node)this._modelToViewMap.get(node);
        if (node2 == null) {
            if (this._isModelNodeInView(node)) {
                node2 = this.getNodeProxy(this, (Node)DummyNode.INSTANCE, node);
            } else {
                node2 = DummyNode.INSTANCE;
                this._modelToViewMap.put(node, node2);
            }
        }
        if (node2 != DummyNode.INSTANCE) {
            return node2;
        }
        return null;
    }

    public Node viewNodeToModelNode(Node node) {
        Document document = node.getOwnerDocument();
        if (document != this) {
            throw new DOMException(4, "Not view document:" + document);
        }
        return ((ViewNode)node).getProxiedNode();
    }

    protected boolean dispatchEvent(Node node, Event event) {
        ViewEvent viewEvent = (ViewEvent)event;
        return viewEvent.__doDefault();
    }

    void $init$() {
        this._modelToViewMap = new HashMap();
    }

    public Node adoptNode(Node node) throws DOMException {
        this.__nyi();
        return null;
    }

    public String getDocumentURI() {
        this.__nyi();
        return null;
    }

    public DOMConfiguration getDomConfig() {
        this.__nyi();
        return null;
    }

    public String getInputEncoding() {
        this.__nyi();
        return null;
    }

    public boolean getStrictErrorChecking() {
        this.__nyi();
        return false;
    }

    public String getXmlEncoding() {
        this.__nyi();
        return null;
    }

    public boolean getXmlStandalone() {
        this.__nyi();
        return false;
    }

    public String getXmlVersion() {
        this.__nyi();
        return null;
    }

    public void normalizeDocument() {
        this.__nyi();
    }

    public Node renameNode(Node node, String string, String string2) throws DOMException {
        this.__nyi();
        return null;
    }

    public void setDocumentURI(String string) {
        this.__nyi();
    }

    public void setStrictErrorChecking(boolean bl) {
        this.__nyi();
    }

    public void setXmlStandalone(boolean bl) throws DOMException {
        this.__nyi();
    }

    public void setXmlVersion(String string) throws DOMException {
        this.__nyi();
    }

    private class DocumentChangeListener
    implements EventListener {
        public void handleEvent(Event event) {
            String string = event.getType();
            if ("DOMNodeRemoved".equals(string)) {
                MutationEvent mutationEvent = (MutationEvent)event;
            } else if ("DOMNodeInserted".equals(string) || "DOMAttrModified".equals(string)) {
                // empty if block
            }
        }

        private DocumentChangeListener() {
        }

        DocumentChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

