/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.standalone;

import java.util.HashMap;
import oracle.bali.xml.dom.ProxyingMapNamedNodeMap;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.view.standalone.ProxyingNode;
import oracle.bali.xml.dom.view.standalone.StandaloneElement;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProxyingElement
extends StandaloneElement
implements ProxyingNode {
    private final Element _proxiedElement;
    private final boolean _deepCopy;

    public ProxyingElement(Element element, boolean bl) {
        super(element.getOwnerDocument(), element.getNamespaceURI(), element.getPrefix(), DomUtils.getLocalName((Node)element));
        this._proxiedElement = element;
        this._deepCopy = bl;
    }

    public Node getProxiedNode() {
        return this._proxiedElement;
    }

    public Node getProxyingNode(Node node) {
        if (node == this.getProxiedNode()) {
            return this;
        }
        return null;
    }

    public NodeList getChildNodes() {
        if (this._deepCopy) {
            return super.getChildNodes();
        }
        return this.getProxiedNode().getChildNodes();
    }

    public Node getFirstChild() {
        if (this._deepCopy) {
            return super.getFirstChild();
        }
        return this.getProxiedNode().getFirstChild();
    }

    public Node getLastChild() {
        if (this._deepCopy) {
            return super.getLastChild();
        }
        return this.getProxiedNode().getLastChild();
    }

    protected NamedNodeMap createAttrMap() {
        return new ProxyingMapNamedNodeMap(this, new HashMap(7), this._proxiedElement.getAttributes());
    }

    protected void createChildren() {
        if (this._deepCopy) {
            Node node = this._proxiedElement.getFirstChild();
            while (node != null) {
                short s = node.getNodeType();
                if (s == 1 || s == 3) {
                    ProxyingElement proxyingElement = null;
                    if (s == 1) {
                        proxyingElement = new ProxyingElement((Element)node, true);
                    }
                    if (proxyingElement != null) {
                        this.appendChild(proxyingElement);
                    }
                }
                node = node.getNextSibling();
            }
        }
    }
}

