/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.standalone;

import oracle.bali.xml.dom.util.DummyNode;
import oracle.bali.xml.dom.view.standalone.StandaloneNode;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class StandaloneContainerNode
extends StandaloneNode
implements NodeList {
    private QualifiedName _qName;
    private String _prefix;
    private Node _firstChild;
    private StandaloneNode _lastChild;
    private int _childCount;

    public StandaloneContainerNode(Document document, String string, String string2, String string3) {
        super(document);
        this.$init$();
        if (string == null && string2 != null) {
            throw new IllegalArgumentException("No namespace provided for prefix:" + string2);
        }
        if (string3 == null) {
            throw new IllegalArgumentException("No local name specified");
        }
        this._qName = QualifiedName.getQualifiedName((String)string, (String)string3);
        this._prefix = string2;
    }

    public String getNodeName() {
        return this._qName.getQualifiedName();
    }

    public String getNamespaceURI() {
        return this._qName.getNamespace();
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String string) throws DOMException {
        if (string != null && this.getNamespaceURI() == null) {
            throw new IllegalArgumentException("No namespace provided for prefix:" + string);
        }
        this._prefix = string;
    }

    public String getLocalName() {
        return this._qName.getName();
    }

    public NodeList getChildNodes() {
        this.fireCreateChildren();
        return this;
    }

    public Node getFirstChild() {
        this.fireCreateChildren();
        return this._firstChild;
    }

    public Node getLastChild() {
        this.fireCreateChildren();
        return this._lastChild;
    }

    public Node item(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = this.getLength();
        if (n >= n2) {
            return null;
        }
        if (n > n2 / 2) {
            Node node = this._lastChild;
            n = n2 - n - 1;
            int n3 = 0;
            while (n3 < n) {
                node = node.getPreviousSibling();
                ++n3;
            }
            return node;
        }
        Node node = this._firstChild;
        int n4 = 0;
        while (n4 < n) {
            node = node.getNextSibling();
            ++n4;
        }
        return node;
    }

    public int getLength() {
        return this._childCount;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        StandaloneNode standaloneNode;
        StandaloneNode standaloneNode2;
        if (node2 != null && this != node2.getParentNode()) {
            throw new DOMException(3, node2 + " is not a child of " + this);
        }
        if (node.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DOMException(4, node + " is not in the same document as " + this);
        }
        if (node2 == null) {
            this.fireCreateChildren();
        }
        this._checkModifications();
        StandaloneNode standaloneNode3 = (StandaloneNode)node;
        StandaloneContainerNode standaloneContainerNode = standaloneNode3.getInternalParentNode();
        if (standaloneContainerNode != null) {
            standaloneContainerNode.removeChild(standaloneNode3);
        }
        if (this._firstChild == node2) {
            this._firstChild = standaloneNode3;
        }
        if ((standaloneNode2 = (StandaloneNode)node2) != null) {
            standaloneNode = standaloneNode2.getInternalPreviousSibling();
            standaloneNode2.setPreviousSibling(standaloneNode3);
        } else {
            standaloneNode = this._lastChild;
            this._lastChild = standaloneNode3;
        }
        if (standaloneNode != null) {
            standaloneNode.setNextSibling(standaloneNode3);
        }
        standaloneNode3.setPreviousSibling(standaloneNode);
        standaloneNode3.setNextSibling(standaloneNode2);
        standaloneNode3.setParentNode(this);
        ++this._childCount;
        return node;
    }

    public Node removeChild(Node node) throws DOMException {
        if (this != node.getParentNode()) {
            throw new DOMException(8, node + " is not a child of " + this);
        }
        this._checkModifications();
        StandaloneNode standaloneNode = (StandaloneNode)node;
        StandaloneNode standaloneNode2 = standaloneNode.getInternalPreviousSibling();
        StandaloneNode standaloneNode3 = standaloneNode.getInternalNextSibling();
        if (this._firstChild == standaloneNode) {
            this._firstChild = standaloneNode3;
        }
        if (this._lastChild == standaloneNode) {
            this._lastChild = standaloneNode2;
        }
        if (standaloneNode2 != null) {
            standaloneNode2.setNextSibling(standaloneNode3);
        }
        if (standaloneNode3 != null) {
            standaloneNode3.setPreviousSibling(standaloneNode2);
        }
        --this._childCount;
        standaloneNode.reset();
        return standaloneNode;
    }

    protected boolean allowsModification() {
        return true;
    }

    private void _checkModifications() {
        if (!this.allowsModification()) {
            throw new DOMException(7, "No modifications allowed to " + this);
        }
    }

    public String toString() {
        return super.toString() + ", qualifiedName " + this._qName + ", prefix " + this._prefix;
    }

    protected final void fireCreateChildren() {
        if (this._firstChild == DummyNode.INSTANCE) {
            this._firstChild = null;
            this.createChildren();
        }
    }

    protected void createChildren() {
    }

    void $init$() {
        this._firstChild = DummyNode.INSTANCE;
        this._lastChild = null;
        this._childCount = 0;
    }
}

