/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.standalone;

import oracle.bali.xml.dom.AbstractNode;
import oracle.bali.xml.dom.util.DummyNode;
import oracle.bali.xml.dom.view.standalone.StandaloneContainerNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class StandaloneNode
extends AbstractNode {
    private Document _document;
    private Node _parentNode;
    private Node _previousSibling;
    private Node _nextSibling;

    public StandaloneNode(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("No DOM document specified");
        }
        this._document = document;
        this.reset();
    }

    public void setParentNode(Node node) {
        this._parentNode = node;
    }

    public Node getParentNode() {
        if (this._parentNode == DummyNode.INSTANCE) {
            throw new IllegalStateException("No traversing standalone node:" + this);
        }
        return this._parentNode;
    }

    public Node getPreviousSibling() {
        if (this._previousSibling == DummyNode.INSTANCE) {
            throw new IllegalStateException("No traversing standalone node:" + this);
        }
        return this._previousSibling;
    }

    public Node getNextSibling() {
        if (this._nextSibling == DummyNode.INSTANCE) {
            throw new IllegalStateException("No traversing standalone node:" + this);
        }
        return this._nextSibling;
    }

    protected StandaloneContainerNode getInternalParentNode() {
        if (this._parentNode == DummyNode.INSTANCE) {
            return null;
        }
        return (StandaloneContainerNode)this._parentNode;
    }

    protected StandaloneNode getInternalPreviousSibling() {
        if (this._previousSibling == DummyNode.INSTANCE) {
            return null;
        }
        return (StandaloneNode)this._previousSibling;
    }

    protected StandaloneNode getInternalNextSibling() {
        if (this._nextSibling == DummyNode.INSTANCE) {
            return null;
        }
        return (StandaloneNode)this._nextSibling;
    }

    protected void setPreviousSibling(StandaloneNode standaloneNode) {
        this._previousSibling = standaloneNode;
    }

    protected void setNextSibling(StandaloneNode standaloneNode) {
        this._nextSibling = standaloneNode;
    }

    public Document getOwnerDocument() {
        return this._document;
    }

    protected void reset() {
        this._parentNode = DummyNode.INSTANCE;
        this._previousSibling = DummyNode.INSTANCE;
        this._nextSibling = DummyNode.INSTANCE;
    }
}

