/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.whitespace;

import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WhitespaceHandler {
    private static final String _sSPACE = "space";
    private static final String _sXML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final WhitespaceHandler _sDEFAULT_HANDLER = new WhitespaceHandler();

    public static WhitespaceHandler getDefaultWhitespaceHandler() {
        return _sDEFAULT_HANDLER;
    }

    public void beginCacheablePeriod() {
    }

    public void endCacheablePeriod() {
    }

    public WhitespaceMode getElementContentWhitespaceMode(TreeTraversal treeTraversal, Element element) {
        String string;
        if (treeTraversal == null) {
            treeTraversal = DocumentTreeTraversal.INSTANCE;
        }
        WhitespaceMode whitespaceMode = null;
        Attr attr = element.getAttributeNodeNS(_sXML_NAMESPACE, _sSPACE);
        if (attr != null && (string = attr.getValue()) != null) {
            if ("preserve".equals(string = string.trim())) {
                whitespaceMode = WhitespaceMode.MODE_PRESERVE;
            } else if ("default".equals(string)) {
                whitespaceMode = WhitespaceMode.MODE_COLLAPSE;
            }
        }
        return this.getElementContentWhitespaceModeImpl(treeTraversal, element, whitespaceMode);
    }

    public WhitespaceMode getAttributeContentWhitespaceMode(TreeTraversal treeTraversal, Element element, String string, String string2) {
        return WhitespaceMode.MODE_REPLACE;
    }

    public final WhitespaceMode getAttributeContentWhitespaceMode(TreeTraversal treeTraversal, Element element, Attr attr) {
        return this.getAttributeContentWhitespaceMode(treeTraversal, element, attr.getNamespaceURI(), DomUtils.getLocalName((Node)attr));
    }

    public final WhitespaceMode getAttributeContentWhitespaceMode(TreeTraversal treeTraversal, Attr attr) {
        return this.getAttributeContentWhitespaceMode(treeTraversal, attr.getOwnerElement(), attr);
    }

    protected WhitespaceMode getElementContentWhitespaceModeImpl(TreeTraversal treeTraversal, Element element, WhitespaceMode whitespaceMode) {
        if (whitespaceMode != null) {
            return whitespaceMode;
        }
        if (treeTraversal == null) {
            treeTraversal = DocumentTreeTraversal.INSTANCE;
        }
        return WhitespaceMode.MODE_PRESERVE;
    }

    protected WhitespaceHandler() {
    }
}

