/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.whitespace;

import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.whitespace.CollapseWhitespaceMode;
import oracle.bali.xml.dom.whitespace.PreserveWhitespaceMode;
import oracle.bali.xml.dom.whitespace.ReduceWhitespaceMode;
import oracle.bali.xml.dom.whitespace.ReplaceWhitespaceMode;
import oracle.bali.xml.dom.whitespace.TrimWhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceResult;

public abstract class WhitespaceMode {
    public static final WhitespaceMode MODE_PRESERVE = new PreserveWhitespaceMode();
    public static final WhitespaceMode MODE_REPLACE = new ReplaceWhitespaceMode();
    public static final WhitespaceMode MODE_COLLAPSE = new CollapseWhitespaceMode();
    public static final WhitespaceMode MODE_REDUCE = new ReduceWhitespaceMode();
    public static final WhitespaceMode MODE_TRIM = new TrimWhitespaceMode();
    private final String _name;

    public final WhitespaceResult apply(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null passed to WhitespaceMode.apply");
        }
        if (string.length() == 0) {
            return new WhitespaceResult();
        }
        return this.applyImpl(string);
    }

    public abstract Boolean allowsAddingExtraWhitespace(DomPosition var1);

    public String toString() {
        return this._name;
    }

    protected abstract WhitespaceResult applyImpl(String var1);

    protected WhitespaceMode(String string) {
        this._name = string;
    }
}

