/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.whitespace;

import java.util.BitSet;

public final class WhitespaceResult {
    private int _totalLength;
    private final BitSet _whitespaceBits;
    private final StringBuffer _valueBuf;

    public void appendToValue(char c) {
        this._valueBuf.append(c);
        this._appendToValue(1);
    }

    public void appendToValue(String string) {
        if (string.length() > 0) {
            this._valueBuf.append(string);
            this._appendToValue(string.length());
        }
    }

    public void markSingleWhitespaceChar() {
        this._whitespaceBits.set(this._totalLength);
        ++this._totalLength;
    }

    public BitSet getWhitespaceBitSet() {
        return this._whitespaceBits;
    }

    public int getTotalLength() {
        return this._totalLength;
    }

    public boolean hasNoWhitespace() {
        return this._whitespaceBits.isEmpty();
    }

    public boolean isEmpty() {
        return this._valueBuf.length() == 0;
    }

    public String getValue() {
        return this._valueBuf.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        WhitespaceResult whitespaceResult = (WhitespaceResult)object;
        boolean bl = this.getValue().equals(whitespaceResult.getValue());
        boolean bl2 = this._whitespaceBits.equals(whitespaceResult._whitespaceBits);
        return bl && bl2;
    }

    public String toString() {
        return "[" + this._valueBuf + "] ws=" + this._whitespaceBits;
    }

    private void _appendToValue(int n) {
        this._totalLength += n;
    }

    void $init$() {
        this._totalLength = 0;
        this._whitespaceBits = new BitSet();
        this._valueBuf = new StringBuffer();
    }

    public WhitespaceResult() {
        this.$init$();
    }
}

