/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.whitespace;

import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.dom.whitespace.WhitespaceResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WhitespaceUtils {
    public static void applyWhitespaceRulesToSubtree(WhitespaceHandler whitespaceHandler, TreeTraversal treeTraversal, Node node) {
        if (node == null) {
            return;
        }
        treeTraversal = WhitespaceUtils._trav(treeTraversal);
        Node node2 = treeTraversal.getFirstChild(node);
        while (node2 != null) {
            Node node3 = treeTraversal.getNextSibling(node2);
            WhitespaceUtils.applyWhitespaceRulesToSubtree(whitespaceHandler, treeTraversal, node2);
            node2 = node3;
        }
        switch (node.getNodeType()) {
            case 1: {
                WhitespaceUtils.applyWhitespaceRulesToAttributes(whitespaceHandler, treeTraversal, (Element)node);
                break;
            }
            case 3: {
                Node node4 = treeTraversal.getParentNode(node);
                if (node4.getNodeType() != 1) break;
                WhitespaceUtils.applyWhitespaceRulesToTextNode(whitespaceHandler, treeTraversal, (Element)node4, (Text)node);
            }
        }
    }

    public static void applyWhitespaceRulesToTextNode(WhitespaceHandler whitespaceHandler, TreeTraversal treeTraversal, Element element, Text text) {
        String string;
        WhitespaceMode whitespaceMode = whitespaceHandler.getElementContentWhitespaceMode(treeTraversal, element);
        WhitespaceResult whitespaceResult = whitespaceMode.apply(string = text.getNodeValue());
        if (whitespaceResult != null) {
            if (whitespaceResult.isEmpty()) {
                Node node = text.getParentNode();
                if (node != null) {
                    node.removeChild(text);
                }
            } else {
                text.setNodeValue(whitespaceResult.getValue());
            }
        }
    }

    public static void applyWhitespaceRulesToAttributes(WhitespaceHandler whitespaceHandler, TreeTraversal treeTraversal, Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                WhitespaceUtils.applyWhitespaceRulesToAttribute(whitespaceHandler, treeTraversal, element, (Attr)namedNodeMap.item(n));
                ++n;
            }
        }
    }

    public static void applyWhitespaceRulesToAttribute(WhitespaceHandler whitespaceHandler, TreeTraversal treeTraversal, Element element, Attr attr) {
        String string;
        WhitespaceMode whitespaceMode = whitespaceHandler.getAttributeContentWhitespaceMode(treeTraversal, element, attr);
        WhitespaceResult whitespaceResult = whitespaceMode.apply(string = attr.getValue());
        if (whitespaceResult != null) {
            attr.setValue(whitespaceResult.getValue());
        }
    }

    public static boolean isXmlWhitespaceChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean nothingToCollapse(String string) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == ' ') {
                if (bl) {
                    return false;
                }
                bl = true;
            } else {
                if (WhitespaceUtils.isXmlWhitespaceChar(c)) {
                    return false;
                }
                bl = false;
            }
            ++n;
        }
        return true;
    }

    public static boolean hasAnyNonSpaceWhitespace(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public static int getTrimmedStart(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2 && WhitespaceUtils.isXmlWhitespaceChar(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    public static int getTrimmedEnd(String string, int n) {
        int n2 = string.length();
        while (n < n2 && WhitespaceUtils.isXmlWhitespaceChar(string.charAt(n2 - 1))) {
            --n2;
        }
        return n2;
    }

    private static TreeTraversal _trav(TreeTraversal treeTraversal) {
        if (treeTraversal == null) {
            return DocumentTreeTraversal.INSTANCE;
        }
        return treeTraversal;
    }

    private WhitespaceUtils() {
    }
}

