/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor;

import java.util.Locale;
import java.util.Vector;
import oracle.bali.xml.editor.XMLLanguageSupport;
import oracle.bali.xml.editor.renderer.XMLBlockRenderer;
import oracle.bali.xml.editor.renderer.XMLStyles;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.resource.BundleHelper;

public final class XMLLanguageModule
extends LanguageModule {
    public static final String PROPERTY_KEY_END_TAG_COMPLETION = "XMLLanguageModule.END_TAG";
    public static final String PROPERTY_KEY_REQUIRED_ATTRIBUTE_INSERTION = "XMLLanguageModule.REQUIRED_ATTRIBUTE_INSERTION";
    public static final String PROPERTY_KEY_SMART_INDENT = "XMLLanguageModule.SMART_INDENT";
    private static final Vector _supportedFileTypes = new Vector(7);

    static {
        XMLLanguageModule.registerFileType("xml");
        XMLLanguageModule.registerFileType("dtd");
        XMLLanguageModule.registerFileType("xsl");
        XMLLanguageModule.registerFileType("xsd");
        XMLLanguageModule.registerFileType("xss");
        XMLLanguageModule.registerFileType("imx");
        XMLLanguageModule.registerFileType("hs");
    }

    public static void registerFileType(String string) {
        if (string != null && !_supportedFileTypes.contains(string = XMLLanguageModule.getFileType((String)string))) {
            _supportedFileTypes.addElement(string);
        }
    }

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("XML_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return XMLStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version = '1.0' encoding = 'UTF-8'?>\n");
        stringBuffer.append("<!DOCTYPE department PUBLIC \"department.dtd\"  >\n");
        stringBuffer.append("<!-- Employee roster for Sales department -->\n");
        stringBuffer.append("<Department>\n");
        stringBuffer.append("  <Name>Sales</Name>\n");
        stringBuffer.append("  <Location>San Francisco</Location>\n");
        stringBuffer.append("  <EmployeeList>\n");
        stringBuffer.append("    <Employee>\n");
        stringBuffer.append("      <Name>John Smith</Name>\n");
        stringBuffer.append("      <ID>1219</ID>\n");
        stringBuffer.append("    </Employee>\n");
        stringBuffer.append("    <Employee>\n");
        stringBuffer.append("      <Name>Douglas Johnson</Name>\n");
        stringBuffer.append("      <ID>1232</ID>\n");
        stringBuffer.append("    </Employee>\n");
        stringBuffer.append("    <Employee>\n");
        stringBuffer.append("      <Name>Mark Monroe</Name>\n");
        stringBuffer.append("      <ID>1259</ID>\n");
        stringBuffer.append("    </Employee>\n");
        stringBuffer.append("  </EmployeeList>\n");
        stringBuffer.append("</Department>\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        String[] stringArray = new String[_supportedFileTypes.size()];
        _supportedFileTypes.toArray(stringArray);
        return stringArray;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new XMLStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new XMLLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new XMLBlockRenderer(textBuffer);
    }

    public static String getXMLEditorResource(String string) {
        BundleHelper bundleHelper = new BundleHelper("oracle.bali.xml.editor.resource.XMLEditorBundle", Locale.getDefault());
        return bundleHelper.getString(string);
    }
}

