/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.demo;

import java.io.File;
import java.net.URL;
import java.util.Set;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;

public final class GrammarRegistryTest {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("usage:  SchemaTest [path to schema]");
            System.exit(1);
        }
        SchemaGrammarProvider schemaGrammarProvider = new SchemaGrammarProvider();
        int n = 0;
        while (n < stringArray.length) {
            URL uRL = null;
            try {
                String string = stringArray[n];
                File file = new File(string);
                string = file.getCanonicalPath();
                string = string.charAt(0) == '/' ? "file:" + string : "file:/" + string;
                uRL = new URL(string);
            }
            catch (Exception exception) {
                System.err.println("Could not find file" + stringArray[n]);
            }
            if (uRL != null) {
                try {
                    Set set = schemaGrammarProvider.addSchema(uRL);
                    for (Grammar grammar : set) {
                        System.out.println(grammar.getTargetNamespace());
                        System.out.println(grammar.getElementDefs());
                    }
                }
                catch (GrammarException grammarException) {
                    grammarException.printStackTrace();
                }
            }
            ++n;
        }
        Grammar grammar = schemaGrammarProvider.getGrammarForNamespace("http://xmlns.oracle.com/uix/ui");
        ElementDef elementDef = grammar.getElementDefByName("pageLayout");
        System.out.println(elementDef.getElementDefs());
        System.out.println(elementDef.getAttributeDefs());
        ElementDef elementDef2 = elementDef.getElementDefByName("contents");
        System.out.println(elementDef2.getElementDefs());
        System.out.println(elementDef2.getAttributeDefs());
    }
}

