/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.demo;

import java.io.File;
import java.net.URL;
import oracle.bali.xml.grammar.schema.error.XmlErrorLog;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.XMLError;

public final class SchemaTest {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("usage:  SchemaTest [path to schema]");
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length) {
            URL uRL = null;
            try {
                String string = stringArray[n];
                File file = new File(string);
                string = file.getCanonicalPath();
                string = string.charAt(0) == '/' ? "file:" + string : "file:/" + string;
                uRL = new URL(string);
            }
            catch (Exception exception) {
                System.err.println("Could not find file" + stringArray[n]);
            }
            if (uRL != null) {
                XmlErrorLog xmlErrorLog = new XmlErrorLog();
                boolean bl = false;
                try {
                    SchemaTest.validateSchema(uRL, (XMLError)xmlErrorLog);
                }
                catch (Exception exception) {
                    bl = true;
                    System.out.println();
                    System.out.println("Exception thrown parsing " + stringArray[n] + ":");
                    System.out.println(exception.getMessage());
                }
                if (xmlErrorLog.hasWarnings() || xmlErrorLog.hasErrors() || xmlErrorLog.hasFatalErrors()) {
                    System.out.println();
                    System.out.println("Errors were encountered parsing " + stringArray[n] + ":");
                    System.out.println(xmlErrorLog);
                } else if (!bl) {
                    System.out.println();
                    System.out.println("There were no errors parsing " + stringArray[n] + ":");
                }
            }
            ++n;
        }
    }

    public static void validateSchema(URL uRL, XMLError xMLError) throws Exception {
        if (uRL != null) {
            XSDBuilder xSDBuilder = new XSDBuilder();
            xSDBuilder.setDebugMode(true);
            if (xMLError != null) {
                xSDBuilder.setError(xMLError);
            }
            XMLSchema xMLSchema = xSDBuilder.build(uRL);
        }
    }
}

