/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.demo.XMLEditorDemo;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.gui.demo.DemoXmlContext;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.FindHighlightPlugin;

public final class XMLDemoActions {
    public static final String newActionName = "new-document";
    public static final String openActionName = "open-document";
    public static final String saveActionName = "save-document";
    public static final String saveAsActionName = "saveas-document";
    public static final String undoActionName = "undo-edit";
    public static final String redoActionName = "redo-edit";
    public static final String exitActionName = "exit-program";
    public static final String findActionName = "find";
    public static final String findAgainActionName = "find-again";
    public static final String manageSchemaActionName = "manage-schemas";
    public static final String proxyActionName = "proxy";
    private XMLEditorDemo editorDemo;
    private HashMap actionMap;
    private UndoSupport _undoSupport;
    private static String searchText = "";
    private static boolean fromStart = false;
    private static boolean matchCase = false;
    private static boolean wholeWordOnly = false;
    private static boolean searchForward = true;
    private static boolean highlightAll = true;
    private static boolean wrapAround = true;

    public XMLDemoActions(XMLEditorDemo xMLEditorDemo) {
        this.editorDemo = xMLEditorDemo;
        this.actionMap = new HashMap();
        AbstractAction abstractAction = new NewAction();
        this.addAction(newActionName, abstractAction);
        abstractAction = new OpenAction();
        this.addAction(openActionName, abstractAction);
        abstractAction = new SaveAction();
        this.addAction(saveActionName, abstractAction);
        abstractAction = new SaveAsAction();
        this.addAction(saveAsActionName, abstractAction);
        abstractAction = new UndoAction();
        this.addAction(undoActionName, abstractAction);
        abstractAction = new RedoAction();
        this.addAction(redoActionName, abstractAction);
        abstractAction = new ExitAction();
        this.addAction(exitActionName, abstractAction);
        abstractAction = new InvokerAction("cut-to-clipboard");
        this.addAction("cut-to-clipboard", abstractAction);
        abstractAction = new InvokerAction("copy-to-clipboard");
        this.addAction("copy-to-clipboard", abstractAction);
        abstractAction = new InvokerAction("paste-from-clipboard");
        this.addAction("paste-from-clipboard", abstractAction);
        abstractAction = new InvokerAction("select-all");
        this.addAction("select-all", abstractAction);
        abstractAction = new FindAction(findActionName, 1);
        this.addAction(findActionName, abstractAction);
        abstractAction = new FindAction(findAgainActionName, 2);
        this.addAction(findAgainActionName, abstractAction);
        abstractAction = new ManageSchemaAction();
        this.addAction(manageSchemaActionName, abstractAction);
        abstractAction = new ProxyAction();
        this.addAction(proxyActionName, abstractAction);
        this._undoSupport = new UndoSupport(null);
        xMLEditorDemo.getEditorPane().addPropertyChangeListener((PropertyChangeListener)this._undoSupport);
        xMLEditorDemo.getEditorPane().getDocument().addUndoableEditListener(this._undoSupport);
    }

    public Action findAction(String string) {
        return (Action)this.actionMap.get(string);
    }

    public void addAction(String string, Action action) {
        this.actionMap.put(string, action);
    }

    void save() {
        if (!this.editorDemo.isSaved()) {
            JFileChooser jFileChooser = this._createFileChooser();
            int n = jFileChooser.showSaveDialog(this.getMainFrame());
            if (n == 0) {
                this.saveFile(jFileChooser.getSelectedFile(), false);
            }
        } else {
            this.editorDemo.saveFile(this.editorDemo.getLastFile());
        }
    }

    void saveFile(File file, boolean bl) {
        boolean bl2 = true;
        if (file.exists()) {
            String string = this.editorDemo.getResourceString("FILE_EXISTS");
            String string2 = null;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = file.getName();
            }
            Object[] objectArray = new Object[]{string2};
            MessageFormat messageFormat = new MessageFormat(string);
            String string3 = messageFormat.format(objectArray);
            String string4 = bl ? "SAVE_ITEM" : "SAVEAS_ITEM";
            String string5 = this.editorDemo.getResourceString(string4);
            if (JOptionPane.showConfirmDialog(this.getMainFrame(), string3, string5, 0) == 1) {
                bl2 = false;
            }
        }
        if (bl2) {
            this.editorDemo.saveFile(file);
        } else {
            this.editorDemo.setLastFile(file);
        }
    }

    boolean trySave() {
        boolean bl = true;
        BasicDocument basicDocument = (BasicDocument)this.editorDemo.getEditorPane().getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        if (textBuffer.isModified()) {
            File file = this.editorDemo.isSaved() ? this.editorDemo.getLastFile() : null;
            String string = this.editorDemo.getResourceString("SAVE_CHANGES");
            String string2 = null;
            try {
                string2 = file == null ? "untitled.xml" : file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = file.getName();
            }
            Object[] objectArray = new Object[]{string2};
            MessageFormat messageFormat = new MessageFormat(string);
            String string3 = messageFormat.format(objectArray);
            int n = JOptionPane.showConfirmDialog(this.getMainFrame(), string3, null, 1);
            switch (n) {
                case 0: {
                    this.save();
                    break;
                }
                case 2: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    void updateUndoRedo() {
        Action action = this.findAction(undoActionName);
        action.setEnabled(this._undoSupport.canUndo());
        Action action2 = this.findAction(redoActionName);
        action2.setEnabled(this._undoSupport.canRedo());
    }

    protected BasicEditorPane getEditorPane() {
        return this.editorDemo.getEditorPane();
    }

    protected JFrame getMainFrame() {
        return this.editorDemo.getMainFrame();
    }

    private JFileChooser _createFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        XMLLanguageModule xMLLanguageModule = new XMLLanguageModule();
        String[] stringArray = xMLLanguageModule.getSupportedFileTypes();
        String string = this.editorDemo.getResourceString("EXT_DESCRIPTION");
        MessageFormat messageFormat = new MessageFormat(string);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            string2 = "." + string2;
            Object[] objectArray = new Object[]{string2};
            String string3 = messageFormat.format(objectArray);
            ExtFilter extFilter = new ExtFilter(string2, string3);
            jFileChooser.addChoosableFileFilter(extFilter);
            ++n;
        }
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        jFileChooser.setFileFilter(fileFilterArray[1]);
        jFileChooser.setSelectedFile(this.editorDemo.getLastFile());
        return jFileChooser;
    }

    static XMLEditorDemo ra$editorDemo(XMLDemoActions xMLDemoActions) {
        return xMLDemoActions.editorDemo;
    }

    static JFileChooser mav$_createFileChooser(XMLDemoActions xMLDemoActions) {
        return xMLDemoActions._createFileChooser();
    }

    static UndoSupport ra$_undoSupport(XMLDemoActions xMLDemoActions) {
        return xMLDemoActions._undoSupport;
    }

    static String ra$searchText() {
        return searchText;
    }

    static boolean ra$matchCase() {
        return matchCase;
    }

    static boolean ra$wholeWordOnly() {
        return wholeWordOnly;
    }

    static boolean ra$fromStart() {
        return fromStart;
    }

    static boolean ra$searchForward() {
        return searchForward;
    }

    static boolean ra$highlightAll() {
        return highlightAll;
    }

    static boolean ra$wrapAround() {
        return wrapAround;
    }

    static void wa$searchText(String string) {
        searchText = string;
    }

    static void wa$fromStart(boolean bl) {
        fromStart = bl;
    }

    static void wa$matchCase(boolean bl) {
        matchCase = bl;
    }

    static void wa$wholeWordOnly(boolean bl) {
        wholeWordOnly = bl;
    }

    static void wa$searchForward(boolean bl) {
        searchForward = bl;
    }

    static void wa$highlightAll(boolean bl) {
        highlightAll = bl;
    }

    static void wa$wrapAround(boolean bl) {
        wrapAround = bl;
    }

    public class NewAction
    extends AbstractAction {
        public NewAction() {
            super(XMLDemoActions.newActionName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (XMLDemoActions.this.trySave()) {
                File file = new File("untitled.xml");
                XMLDemoActions.ra$editorDemo(XMLDemoActions.this).openFile(file, false);
            }
        }
    }

    public class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super(XMLDemoActions.openActionName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser;
            int n;
            if (XMLDemoActions.this.trySave() && (n = (jFileChooser = XMLDemoActions.mav$_createFileChooser(XMLDemoActions.this)).showOpenDialog(XMLDemoActions.this.getMainFrame())) == 0) {
                File file = jFileChooser.getSelectedFile();
                XMLDemoActions.ra$editorDemo(XMLDemoActions.this).openFile(file, true);
            }
        }
    }

    public class SaveAction
    extends AbstractAction
    implements PropertyChangeListener,
    DocumentListener {
        public SaveAction() {
            super(XMLDemoActions.saveActionName);
            XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getEditorPane().addPropertyChangeListener((PropertyChangeListener)this);
            XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getEditorPane().getDocument().addDocumentListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XMLDemoActions.this.save();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("document".equals(string)) {
                Document document;
                Document document2 = (Document)propertyChangeEvent.getOldValue();
                if (document2 != null) {
                    document2.removeDocumentListener(this);
                }
                if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                    document.addDocumentListener(this);
                }
            }
        }

        public void update() {
            BasicDocument basicDocument = (BasicDocument)XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getEditorPane().getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            this.setEnabled(textBuffer.isModified());
        }
    }

    public class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            super(XMLDemoActions.saveAsActionName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = XMLDemoActions.mav$_createFileChooser(XMLDemoActions.this);
            int n = jFileChooser.showSaveDialog(XMLDemoActions.this.getMainFrame());
            if (n == 0) {
                XMLDemoActions.this.saveFile(jFileChooser.getSelectedFile(), true);
            }
        }
    }

    public class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super(XMLDemoActions.exitActionName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (XMLDemoActions.this.trySave()) {
                System.exit(0);
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(XMLDemoActions.undoActionName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                XMLDemoActions.ra$_undoSupport(XMLDemoActions.this).undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            XMLDemoActions.this.updateUndoRedo();
        }
    }

    public class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(XMLDemoActions.redoActionName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                XMLDemoActions.ra$_undoSupport(XMLDemoActions.this).redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            XMLDemoActions.this.updateUndoRedo();
        }
    }

    public class InvokerAction
    extends AbstractAction {
        public InvokerAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionInvoker actionInvoker = XMLDemoActions.this.getEditorPane().getActionInvoker();
            actionInvoker.invokeAction((String)this.getValue("Name"));
        }
    }

    public class FindAction
    extends TextAction {
        public static final int FIND = 1;
        public static final int FIND_AGAIN = 2;
        private int findType;

        public FindAction(String string, int n) {
            super(string);
            this.findType = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            boolean bl;
            BasicEditorPane basicEditorPane = (BasicEditorPane)this.getTextComponent(actionEvent);
            if (basicEditorPane == null) {
                return;
            }
            switch (this.findType) {
                case 1: {
                    if (!this.displayDialog(basicEditorPane)) {
                        return;
                    }
                    bl = XMLDemoActions.ra$fromStart();
                    break;
                }
                case 2: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid find type: " + this.findType);
                }
            }
            if (XMLDemoActions.ra$searchText() == null || XMLDemoActions.ra$searchText().length() == 0) {
                basicEditorPane.getToolkit().beep();
                return;
            }
            if (bl) {
                n = 0;
            } else {
                n = basicEditorPane.getCaretPosition();
                if (basicEditorPane.getSelectionStart() != basicEditorPane.getSelectionEnd()) {
                    n = basicEditorPane.getSelectionStart() + 1;
                }
            }
            FindHighlightPlugin findHighlightPlugin = (FindHighlightPlugin)basicEditorPane.getProperty("finder");
            int n2 = findHighlightPlugin.findText(XMLDemoActions.ra$searchText(), n, XMLDemoActions.ra$searchForward(), XMLDemoActions.ra$matchCase(), XMLDemoActions.ra$wrapAround(), XMLDemoActions.ra$wholeWordOnly(), XMLDemoActions.ra$highlightAll());
            if (n2 == -1) {
                JFrame jFrame = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getMainFrame();
                String string = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("FIND_DIALOG_NOT_FOUND");
                JOptionPane.showMessageDialog(jFrame, string);
            } else {
                basicEditorPane.setCaretPositionCenter(n2);
                basicEditorPane.moveCaretPositionCenter(n2 + XMLDemoActions.ra$searchText().length());
                basicEditorPane.requestFocus();
            }
        }

        private boolean displayDialog(BasicEditorPane basicEditorPane) {
            int n;
            String string = "";
            int n2 = basicEditorPane.getSelectionStart();
            if (n2 != (n = basicEditorPane.getSelectionEnd())) {
                try {
                    string = basicEditorPane.getDocument().getText(n2, n - n2);
                }
                catch (BadLocationException badLocationException) {
                    string = "";
                }
            } else {
                string = XMLDemoActions.ra$searchText();
            }
            JTextField jTextField = new JTextField(string, 15);
            jTextField.selectAll();
            String string2 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("FIND_DIALOG_LABEL");
            String string3 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("FIND_DIALOG_MATCH_CASE");
            String string4 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("FIND_DIALOG_WORD");
            String string5 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("FIND_DIALOG_BEGIN_DOC");
            String string6 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("FIND_DIALOG_SEARCH_FORWARD");
            String string7 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("FIND_DIALOG_HIGHLIGHT");
            String string8 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("FIND_DIALOG_WRAP");
            JLabel jLabel = new JLabel(string2);
            JCheckBox jCheckBox = new JCheckBox(string3, XMLDemoActions.ra$matchCase());
            JCheckBox jCheckBox2 = new JCheckBox(string4, XMLDemoActions.ra$wholeWordOnly());
            JCheckBox jCheckBox3 = new JCheckBox(string5, XMLDemoActions.ra$fromStart());
            JCheckBox jCheckBox4 = new JCheckBox(string6, XMLDemoActions.ra$searchForward());
            JCheckBox jCheckBox5 = new JCheckBox(string7, XMLDemoActions.ra$highlightAll());
            JCheckBox jCheckBox6 = new JCheckBox(string8, XMLDemoActions.ra$wrapAround());
            JPanel jPanel = new JPanel();
            jPanel.add(jLabel);
            jPanel.add(jTextField);
            Box box = new Box(1);
            box.add(jCheckBox);
            box.add(jCheckBox3);
            box.add(jCheckBox4);
            box.add(jCheckBox5);
            box.add(jCheckBox6);
            box.add(jCheckBox2);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "Center");
            jPanel2.add((Component)box, "South");
            String string9 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("FIND_DIALOG_TITLE");
            int n3 = JOptionPane.showOptionDialog(XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getMainFrame(), jPanel2, string9, 2, -1, null, null, null);
            boolean bl = false;
            switch (n3) {
                case 0: {
                    XMLDemoActions.wa$searchText(jTextField.getText());
                    XMLDemoActions.wa$fromStart(jCheckBox3.isSelected());
                    XMLDemoActions.wa$matchCase(jCheckBox.isSelected());
                    XMLDemoActions.wa$wholeWordOnly(jCheckBox2.isSelected());
                    XMLDemoActions.wa$searchForward(jCheckBox4.isSelected());
                    XMLDemoActions.wa$highlightAll(jCheckBox5.isSelected());
                    XMLDemoActions.wa$wrapAround(jCheckBox6.isSelected());
                    bl = true;
                    break;
                }
            }
            return bl;
        }
    }

    public class ManageSchemaAction
    extends AbstractAction {
        private File _lastSchemaFile;

        public ManageSchemaAction() {
            super(XMLDemoActions.manageSchemaActionName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("MANAGE_SCHEMA_TITLE");
            String string2 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("MANAGE_SCHEMA_LABEL");
            String string3 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("MANAGE_SCHEMA_ADD");
            JPanel jPanel = new JPanel(new BorderLayout(3, 3));
            JLabel jLabel = new JLabel(string2);
            jLabel.setDisplayedMnemonic(XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceMnemonic("MANAGE_SCHEMA_LABEL_MNEMONIC"));
            jPanel.add("North", jLabel);
            SchemaGrammarProvider schemaGrammarProvider = DemoXmlContext.getSharedGrammarProvider();
            ArrayList arrayList = new ArrayList(schemaGrammarProvider.getGrammars());
            int n = arrayList.size();
            4 var10_10 = new 4(n, 2);
            int n2 = 0;
            while (n2 < n) {
                Grammar grammar = (Grammar)arrayList.get(n2);
                var10_10.setValueAt(grammar.getTargetNamespace(), n2, 0);
                var10_10.setValueAt(grammar.getLocation(), n2, 1);
                ++n2;
            }
            JTable jTable = new JTable(var10_10);
            Dimension dimension = new Dimension(400, (n + 5) * 20);
            jTable.setPreferredScrollableViewportSize(dimension);
            jTable.getTableHeader().setReorderingAllowed(false);
            String string4 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("MANAGE_SCHEMA_NAMESPACE_HEADER");
            String string5 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("MANAGE_SCHEMA_LOCATION_HEADER");
            jTable.getColumnModel().getColumn(0).setHeaderValue(string4);
            jTable.getColumnModel().getColumn(1).setHeaderValue(string5);
            jTable.getColumnModel().setColumnSelectionAllowed(false);
            jTable.setRowSelectionAllowed(true);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            jLabel.setLabelFor(jTable);
            JPanel jPanel2 = new JPanel(new BorderLayout(3, 3));
            jPanel2.add("Center", jScrollPane);
            JButton jButton = new JButton(string3);
            jButton.setMnemonic(XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceMnemonic("MANAGE_SCHEMA_ADD_MNEMONIC"));
            JPanel jPanel3 = new JPanel(new BorderLayout(3, 3));
            jPanel3.add("North", jButton);
            JPanel jPanel4 = new JPanel(new BorderLayout(3, 3));
            jPanel3.add("Center", jPanel4);
            jPanel2.add("East", jPanel3);
            jPanel.add("Center", jPanel2);
            JOptionPane jOptionPane = new JOptionPane(jPanel, -1, 2, null, null, null);
            jButton.addActionListener(new 3(this, jOptionPane, var10_10));
            int n3 = this._showOptionDialog(jOptionPane, XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getMainFrame(), string);
            switch (n3) {
                default: 
            }
        }

        private Set _showAddDialog(Component component) {
            String string = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("ADD_SCHEMA_TITLE");
            String string2 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("ADD_SCHEMA_LABEL");
            String string3 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("ADD_SCHEMA_FILE_LABEL");
            String string4 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("ADD_SCHEMA_URL_LABEL");
            String string5 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("ADD_SCHEMA_BROWSE");
            Component component2 = component;
            JPanel jPanel = new JPanel(new BorderLayout(3, 3));
            jPanel.add("North", new JLabel(string2));
            JRadioButton jRadioButton = new JRadioButton(string3);
            jRadioButton.setMnemonic(XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceMnemonic("ADD_SCHEMA_FILE_MNEMONIC"));
            jRadioButton.setSelected(true);
            DisableTextField disableTextField = new DisableTextField(null);
            disableTextField.setColumns(30);
            JButton jButton = new JButton(string5);
            jButton.setMnemonic(XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceMnemonic("ADD_SCHEMA_BROWSE_MNEMONIC"));
            jButton.addActionListener(new 2(this, disableTextField, component2));
            JPanel jPanel2 = new JPanel(new BorderLayout(3, 3));
            jPanel2.add("West", jRadioButton);
            jPanel2.add("Center", disableTextField);
            jPanel2.add("East", jButton);
            jPanel.add("Center", jPanel2);
            JRadioButton jRadioButton2 = new JRadioButton(string4);
            jRadioButton2.setMnemonic(XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceMnemonic("ADD_SCHEMA_URL_MNEMONIC"));
            jRadioButton2.setSelected(false);
            DisableTextField disableTextField2 = new DisableTextField(null);
            disableTextField2.setColumns(29);
            ((JComponent)disableTextField2).setEnabled(false);
            JPanel jPanel3 = new JPanel(new BorderLayout(3, 3));
            jPanel3.add("West", jRadioButton2);
            jPanel3.add("Center", disableTextField2);
            jPanel.add("South", jPanel3);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            1 var17_17 = new 1(this, jRadioButton, disableTextField2, disableTextField, jButton);
            jRadioButton.addChangeListener(var17_17);
            jRadioButton2.addChangeListener(var17_17);
            int n = JOptionPane.showOptionDialog(component, jPanel, string, 2, -1, null, null, null);
            Set set = Collections.EMPTY_SET;
            switch (n) {
                case 0: {
                    URL uRL = null;
                    if (jRadioButton.isSelected()) {
                        if (disableTextField.getText() != null) {
                            File file = new File(disableTextField.getText());
                            try {
                                uRL = file.toURL();
                            }
                            catch (MalformedURLException malformedURLException) {
                                System.err.println(malformedURLException);
                            }
                        }
                    } else if (disableTextField2.getText() != null) {
                        try {
                            uRL = new URL(disableTextField2.getText());
                        }
                        catch (MalformedURLException malformedURLException) {
                            System.err.println(malformedURLException);
                        }
                    }
                    if (uRL == null) break;
                    try {
                        SchemaGrammarProvider schemaGrammarProvider = DemoXmlContext.getSharedGrammarProvider();
                        set = schemaGrammarProvider.addSchema(uRL);
                    }
                    catch (GrammarException grammarException) {
                        String string6 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("ADD_SCHEMA_ERROR");
                        Object[] objectArray = new Object[]{uRL.toString(), grammarException.toString()};
                        MessageFormat messageFormat = new MessageFormat(string6);
                        String string7 = messageFormat.format(objectArray);
                        JOptionPane.showMessageDialog(component, string7, null, 0);
                    }
                    break;
                }
            }
            return set;
        }

        private int _showOptionDialog(JOptionPane jOptionPane, Component component, String string) {
            JDialog jDialog = jOptionPane.createDialog(component, string);
            jDialog.show();
            Object object = jOptionPane.getValue();
            if (object == null) {
                return -1;
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return -1;
        }

        private boolean _equals(Grammar grammar, Grammar grammar2, boolean bl) {
            boolean bl2;
            if (grammar == grammar2) {
                return true;
            }
            boolean bl3 = bl2 = grammar.getTargetNamespace() == grammar2.getTargetNamespace();
            if (bl) {
                return bl2 && grammar.getLocation() == grammar2.getLocation();
            }
            return bl2;
        }

        static Set mav$_showAddDialog(ManageSchemaAction manageSchemaAction, Component component) {
            return manageSchemaAction._showAddDialog(component);
        }

        static File ra$_lastSchemaFile(ManageSchemaAction manageSchemaAction) {
            return manageSchemaAction._lastSchemaFile;
        }

        static void wa$_lastSchemaFile(ManageSchemaAction manageSchemaAction, File file) {
            manageSchemaAction._lastSchemaFile = file;
        }

        public final class 4
        extends DefaultTableModel {
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public 4(int n, int n2) {
                super(n, n2);
            }
        }

        public final class 3
        implements ActionListener {
            private final /* synthetic */ JOptionPane v$pane;
            private final /* synthetic */ DefaultTableModel v$model;
            final /* synthetic */ ManageSchemaAction this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                Set set = ManageSchemaAction.mav$_showAddDialog(this.this$0, this.v$pane);
                for (Grammar grammar : set) {
                    Object[] objectArray = new Object[]{grammar.getTargetNamespace(), grammar.getLocation()};
                    this.v$model.addRow(objectArray);
                }
            }

            public 3(ManageSchemaAction manageSchemaAction, JOptionPane jOptionPane, DefaultTableModel defaultTableModel) {
                this.v$model = defaultTableModel;
                this.v$pane = jOptionPane;
                this.this$0 = manageSchemaAction;
            }
        }

        public final class 2
        implements ActionListener {
            private final /* synthetic */ JTextField v$fileField;
            private final /* synthetic */ Component v$fileChooserParent;
            final /* synthetic */ ManageSchemaAction this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                String string = this.v$fileField.getText();
                boolean bl = string == null || "".equals(string);
                File file = bl ? ManageSchemaAction.ra$_lastSchemaFile(this.this$0) : new File(string);
                JFileChooser jFileChooser = new JFileChooser();
                String string2 = XMLDemoActions.ra$editorDemo(this.this$0.XMLDemoActions.this).getResourceString("EXT_DESCRIPTION");
                MessageFormat messageFormat = new MessageFormat(string2);
                String string3 = ".xsd";
                Object[] objectArray = new Object[]{string3};
                String string4 = messageFormat.format(objectArray);
                ExtFilter extFilter = new ExtFilter(string3, string4);
                jFileChooser.addChoosableFileFilter(extFilter);
                jFileChooser.setSelectedFile(file);
                int n = jFileChooser.showOpenDialog(this.v$fileChooserParent);
                if (n == 0) {
                    file = jFileChooser.getSelectedFile();
                    ManageSchemaAction.wa$_lastSchemaFile(this.this$0, file);
                    String string5 = null;
                    if (file != null) {
                        try {
                            string5 = file.getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            string5 = null;
                        }
                    }
                    this.v$fileField.setText(string5);
                }
            }

            public 2(ManageSchemaAction manageSchemaAction, JTextField jTextField, Component component) {
                this.v$fileChooserParent = component;
                this.v$fileField = jTextField;
                this.this$0 = manageSchemaAction;
            }
        }

        public final class 1
        implements ChangeListener {
            private final /* synthetic */ JRadioButton v$fileBox;
            private final /* synthetic */ JTextField v$urlField;
            private final /* synthetic */ JTextField v$fileField;
            private final /* synthetic */ JButton v$browseButton;
            final /* synthetic */ ManageSchemaAction this$0;

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = this.v$fileBox.isSelected();
                this.v$urlField.setEnabled(bl ^ true);
                this.v$fileField.setEnabled(bl);
                this.v$browseButton.setEnabled(bl);
            }

            public 1(ManageSchemaAction manageSchemaAction, JRadioButton jRadioButton, JTextField jTextField, JTextField jTextField2, JButton jButton) {
                this.v$browseButton = jButton;
                this.v$fileField = jTextField2;
                this.v$urlField = jTextField;
                this.v$fileBox = jRadioButton;
                this.this$0 = manageSchemaAction;
            }
        }
    }

    public class ProxyAction
    extends AbstractAction {
        public ProxyAction() {
            super(XMLDemoActions.proxyActionName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("PROXY_SERVER_TITLE");
            String string2 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("PROXY_SERVER_LABEL");
            String string3 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceString("PROXY_SERVER_PORT_LABEL");
            char c = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceMnemonic("PROXY_SERVER_LABEL_MNEMONIC");
            char c2 = XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getResourceMnemonic("PROXY_SERVER_PORT_MNEMONIC");
            String string4 = System.getProperty("http.proxyHost");
            String string5 = System.getProperty("http.proxyPort");
            JPanel jPanel = new JPanel(new BorderLayout(3, 3));
            JLabel jLabel = new JLabel(string2);
            jLabel.setDisplayedMnemonic(c);
            JTextField jTextField = new JTextField(string4, 30);
            jLabel.setLabelFor(jTextField);
            JPanel jPanel2 = new JPanel(new BorderLayout(3, 3));
            jPanel2.add("North", jLabel);
            jPanel2.add("Center", jTextField);
            JLabel jLabel2 = new JLabel(string3);
            jLabel2.setDisplayedMnemonic(c2);
            JTextField jTextField2 = new JTextField(string5, 5);
            jLabel2.setLabelFor(jTextField2);
            JPanel jPanel3 = new JPanel(new BorderLayout(3, 3));
            jPanel3.add("North", jLabel2);
            jPanel3.add("Center", jTextField2);
            jPanel.add("Center", jPanel2);
            jPanel.add("East", jPanel3);
            int n = JOptionPane.showOptionDialog(XMLDemoActions.ra$editorDemo(XMLDemoActions.this).getMainFrame(), jPanel, string, 2, -1, null, null, null);
            if (n == 0) {
                string4 = jTextField.getText();
                string5 = jTextField2.getText();
                System.setProperty("http.proxyHost", string4);
                System.setProperty("http.proxyPort", string5);
            }
        }
    }

    private class ExtFilter
    extends FileFilter {
        private String _ext;
        private String _desc;

        public ExtFilter(String string, String string2) {
            this._ext = string.indexOf(".") == -1 ? "." + string : string;
            this._desc = string2;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string == null ? false : string.indexOf(this._ext) != -1;
        }

        public String getDescription() {
            return this._desc;
        }
    }

    private class UndoSupport
    extends UndoManager
    implements PropertyChangeListener {
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            super.undoableEditHappened(undoableEditEvent);
            XMLDemoActions.this.updateUndoRedo();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("document".equals(string)) {
                Document document;
                this.discardAllEdits();
                Document document2 = (Document)propertyChangeEvent.getOldValue();
                if (document2 != null) {
                    document2.removeUndoableEditListener(this);
                }
                if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                    document.addUndoableEditListener(this);
                }
            }
        }

        private UndoSupport() {
        }

        UndoSupport(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DisableTextField
    extends JTextField {
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.setBackground(bl ? UIManager.getColor("TextField.background") : UIManager.getColor("control"));
        }

        private DisableTextField() {
        }

        DisableTextField(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

