/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.bali.xml.dom.buffer.DefaultParserConfiguration;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.demo.XMLDemoActions;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.tooltip.XMLTooltipInsightProvider;
import oracle.bali.xml.editor.plugins.AutomaticEndTagProvider;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.gui.demo.DemoXmlContext;
import oracle.bali.xml.model.XmlContext;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.editor.plugins.StatusBarPlugin;

public final class XMLEditorDemo
implements ToolTipProvider,
PopupManager {
    public static final Color CARET_COLOR = Color.black;
    public static final Color SELECTION_TEXT_COLOR = Color.white;
    public static final Color SELECTION_COLOR = Color.blue;
    public static final String SCHEMA_SWITCH = "-schema";
    public static final String RESOURCE_FILE = "oracle.bali.xml.editor.demo.Resources";
    public static final String RESOURCE_NOT_FOUND = "<NOT FOUND>";
    public static final String UNTITLED_DOCUMENT = "untitled.xml";
    private DemoXmlContext _xmlContext;
    private XMLCompletionInsightProvider _insightPlugin;
    private XMLTooltipInsightProvider _tooltipPlugin;
    private JFrame mainFrame;
    private JScrollPane scrollPane;
    private JPanel mainPanel;
    private BasicEditorPane editorPane;
    private JMenuBar menuBar;
    private XMLDemoActions demoActions;
    private JPopupMenu popupMenu;
    private File _lastFile;
    private boolean _saved;
    private static ResourceBundle resources;

    static {
        try {
            resources = ResourceBundle.getBundle(RESOURCE_FILE, Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Could not find Resources.properties file.");
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string3 != null) {
                if (string3.equals(SCHEMA_SWITCH)) {
                    if (n + 1 < stringArray.length) {
                        string = stringArray[n + 1];
                        ++n;
                    }
                } else {
                    string2 = string3;
                }
            }
            ++n;
        }
        XMLEditorDemo._registerInitialSchema(string);
        new XMLEditorDemo(string2);
    }

    public XMLEditorDemo(String string) {
        this.$init$();
        try {
            UIManager.setLookAndFeel("oracle.bali.ewt.olaf.OracleLookAndFeel");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.editorPane = new BasicEditorPane();
        this.editorPane.setCaretColor(CARET_COLOR);
        this.editorPane.setSelectedTextColor(SELECTION_TEXT_COLOR);
        this.editorPane.setSelectionColor(SELECTION_COLOR);
        this.editorPane.addPopupManager((PopupManager)this);
        this.editorPane.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        FindHighlightPlugin findHighlightPlugin = new FindHighlightPlugin();
        this.editorPane.installPlugin((EditorPlugin)findHighlightPlugin);
        StatusBarPlugin statusBarPlugin = new StatusBarPlugin(this.editorPane.getFont());
        this.editorPane.installPlugin((EditorPlugin)statusBarPlugin);
        XMLLanguageModule.registerFileType("uix");
        XMLLanguageModule xMLLanguageModule = new XMLLanguageModule();
        this.editorPane.installPlugin((EditorPlugin)new AutomaticEndTagProvider());
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.END_TAG", true);
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.REQUIRED_ATTRIBUTE_INSERTION", true);
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.SMART_INDENT", true);
        this.editorPane.putProperty("finder", (Object)findHighlightPlugin);
        this.scrollPane = new JScrollPane((Component)this.editorPane);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        JViewport jViewport = this.scrollPane.getViewport();
        jViewport.setScrollMode(1);
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this.editorPane.installPlugin((EditorPlugin)lineGutterPlugin);
        this.scrollPane.setRowHeaderView((Component)lineGutterPlugin);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.scrollPane, "Center");
        jPanel.add((Component)statusBarPlugin.getPanel(), "South");
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.getContentPane().add(jPanel);
        this.demoActions = new XMLDemoActions(this);
        this.menuBar = this.createMenuBar();
        this.popupMenu = this.createPopupMenu();
        this.mainFrame.setJMenuBar(this.menuBar);
        this.mainFrame.pack();
        this.mainFrame.setSize(640, 480);
        File file = null;
        file = string != null ? new File(string) : new File(UNTITLED_DOCUMENT);
        this.openFile(file, false);
        this.mainFrame.setVisible(true);
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createEditMenu());
        jMenuBar.add(this.createSearchMenu());
        jMenuBar.add(this.createSchemaMenu());
        return jMenuBar;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        DemoMenuItem demoMenuItem = this.createMenuItem("CUT", "cut-to-clipboard");
        DemoMenuItem demoMenuItem2 = this.createMenuItem("COPY", "copy-to-clipboard");
        DemoMenuItem demoMenuItem3 = this.createMenuItem("PASTE", "paste-from-clipboard");
        DemoMenuItem demoMenuItem4 = this.createMenuItem("SELECTALL", "select-all");
        jPopupMenu.add(demoMenuItem);
        jPopupMenu.add(demoMenuItem2);
        jPopupMenu.add(demoMenuItem3);
        jPopupMenu.addSeparator();
        jPopupMenu.add(demoMenuItem4);
        return jPopupMenu;
    }

    private JMenu createFileMenu() {
        String string = this.getResourceString("FILE_MENU");
        char c = this.getResourceMnemonic("FILE_MNEMONIC");
        JMenu jMenu = new JMenu(string);
        if (c != '\u0000') {
            jMenu.setMnemonic(c);
        }
        DemoMenuItem demoMenuItem = this.createMenuItem("NEW", "new-document");
        DemoMenuItem demoMenuItem2 = this.createMenuItem("OPEN", "open-document");
        DemoMenuItem demoMenuItem3 = this.createMenuItem("SAVE", "save-document");
        DemoMenuItem demoMenuItem4 = this.createMenuItem("SAVEAS", "saveas-document");
        DemoMenuItem demoMenuItem5 = this.createMenuItem("EXIT", "exit-program");
        jMenu.add(demoMenuItem);
        jMenu.add(demoMenuItem2);
        jMenu.addSeparator();
        jMenu.add(demoMenuItem3);
        jMenu.add(demoMenuItem4);
        jMenu.addSeparator();
        jMenu.add(demoMenuItem5);
        return jMenu;
    }

    private JMenu createEditMenu() {
        String string = this.getResourceString("EDIT_MENU");
        char c = this.getResourceMnemonic("EDIT_MNEMONIC");
        JMenu jMenu = new JMenu(string);
        if (c != '\u0000') {
            jMenu.setMnemonic(c);
        }
        DemoMenuItem demoMenuItem = this.createMenuItem("UNDO", "undo-edit");
        DemoMenuItem demoMenuItem2 = this.createMenuItem("REDO", "redo-edit");
        DemoMenuItem demoMenuItem3 = this.createMenuItem("CUT", "cut-to-clipboard");
        DemoMenuItem demoMenuItem4 = this.createMenuItem("COPY", "copy-to-clipboard");
        DemoMenuItem demoMenuItem5 = this.createMenuItem("PASTE", "paste-from-clipboard");
        DemoMenuItem demoMenuItem6 = this.createMenuItem("SELECTALL", "select-all");
        jMenu.add(demoMenuItem);
        jMenu.add(demoMenuItem2);
        jMenu.addSeparator();
        jMenu.add(demoMenuItem3);
        jMenu.add(demoMenuItem4);
        jMenu.add(demoMenuItem5);
        jMenu.addSeparator();
        jMenu.add(demoMenuItem6);
        return jMenu;
    }

    private JMenu createSearchMenu() {
        String string = this.getResourceString("SEARCH_MENU");
        char c = this.getResourceMnemonic("SEARCH_MNEMONIC");
        JMenu jMenu = new JMenu(string);
        if (c != '\u0000') {
            jMenu.setMnemonic(c);
        }
        DemoMenuItem demoMenuItem = this.createMenuItem("FIND", "find");
        DemoMenuItem demoMenuItem2 = this.createMenuItem("FIND_AGAIN", "find-again");
        jMenu.add(demoMenuItem);
        jMenu.add(demoMenuItem2);
        return jMenu;
    }

    private JMenu createSchemaMenu() {
        String string = this.getResourceString("SCHEMA_MENU");
        char c = this.getResourceMnemonic("SCHEMA_MNEMONIC");
        JMenu jMenu = new JMenu(string);
        if (c != '\u0000') {
            jMenu.setMnemonic(c);
        }
        DemoMenuItem demoMenuItem = this.createMenuItem("MANAGE", "manage-schemas");
        DemoMenuItem demoMenuItem2 = this.createMenuItem("PROXY", "proxy");
        jMenu.add(demoMenuItem);
        jMenu.add(demoMenuItem2);
        return jMenu;
    }

    private DemoMenuItem createMenuItem(String string, String string2) {
        String string3 = this.getResourceString(string + "_ITEM");
        char c = this.getResourceMnemonic(string + "_MNEMONIC");
        KeyStroke keyStroke = this.getResourceKeyStroke(string + "_KEYSTROKE");
        Action action = this.demoActions.findAction(string2);
        DemoMenuItem demoMenuItem = new DemoMenuItem(string3, action);
        if (c != '\u0000') {
            demoMenuItem.setMnemonic(c);
        }
        if (keyStroke != null) {
            demoMenuItem.setAccelerator(keyStroke);
        }
        return demoMenuItem;
    }

    protected String getResourceString(String string) {
        String string2;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = RESOURCE_NOT_FOUND;
        }
        return string2;
    }

    protected char getResourceMnemonic(String string) {
        String string2 = this.getResourceString(string);
        if (string2.equals(RESOURCE_NOT_FOUND)) {
            return '\u0000';
        }
        return string2.charAt(0);
    }

    private KeyStroke getResourceKeyStroke(String string) {
        String string2 = this.getResourceString(string);
        if (string2.equals(RESOURCE_NOT_FOUND)) {
            return null;
        }
        return KeyStroke.getKeyStroke(string2);
    }

    protected void setTitle(String string) {
        if (string == null) {
            string = UNTITLED_DOCUMENT;
            this._saved = false;
        }
        this.mainFrame.setTitle(this.getResourceString("DEMO_NAME") + " - " + string);
        BasicDocument basicDocument = (BasicDocument)this.editorPane.getDocument();
        basicDocument.setLanguageSupport(string);
    }

    protected void openFile(File file, boolean bl) {
        if (bl && !file.exists()) {
            try {
                this._showOptionPane(new FileNotFoundException(file.getCanonicalPath()));
            }
            catch (IOException iOException) {
                this._showOptionPane(iOException);
            }
            return;
        }
        try {
            DemoXmlContext demoXmlContext = this._xmlContext;
            if (this._insightPlugin != null) {
                this.editorPane.deinstallPlugin((EditorPlugin)this._insightPlugin);
            }
            if (this._tooltipPlugin != null) {
                this.editorPane.deinstallPlugin((EditorPlugin)this._tooltipPlugin);
            }
            this._xmlContext = new DemoXmlContext(file, Locale.getDefault());
            DefaultParserConfiguration defaultParserConfiguration = new DefaultParserConfiguration();
            this._insightPlugin = new XMLCompletionInsightProvider((XmlContext)this._xmlContext, defaultParserConfiguration);
            this._tooltipPlugin = new XMLTooltipInsightProvider((XmlContext)this._xmlContext, defaultParserConfiguration);
            this.editorPane.setDocument(this._xmlContext.getSourceDocument());
            this.editorPane.installPlugin((EditorPlugin)this._insightPlugin);
            this.editorPane.installPlugin((EditorPlugin)this._tooltipPlugin);
            this.setTitle(file.getCanonicalPath());
            this.setLastFile(file);
            this._updateSave();
            if (demoXmlContext != null) {
                demoXmlContext.dispose();
            }
        }
        catch (Exception exception) {
            this._showOptionPane(exception);
        }
    }

    protected void saveFile(File file) {
        if (file != null) {
            try {
                FileWriter fileWriter = new FileWriter(file);
                BasicDocument basicDocument = (BasicDocument)this.editorPane.getDocument();
                TextBuffer textBuffer = basicDocument.getTextBuffer();
                textBuffer.write((Writer)fileWriter);
                this.setTitle(file.getCanonicalPath());
                this.setLastFile(file);
                this._updateSave();
                this._saved = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this._showOptionPane(fileNotFoundException);
            }
            catch (IOException iOException) {
                this._showOptionPane(iOException);
            }
        }
    }

    protected BasicEditorPane getEditorPane() {
        return this.editorPane;
    }

    protected boolean isSaved() {
        return this._saved;
    }

    protected File getLastFile() {
        return this._lastFile;
    }

    protected void setLastFile(File file) {
        this._lastFile = file;
    }

    protected JFrame getMainFrame() {
        return this.mainFrame;
    }

    private static void _registerInitialSchema(String string) {
        if (string == null) {
            return;
        }
        URL uRL = null;
        try {
            String string2 = string;
            File file = new File(string2);
            string2 = file.getCanonicalPath();
            string2 = string2.charAt(0) == '/' ? "file:" + string2 : "file:/" + string2;
            uRL = new URL(string2);
        }
        catch (Exception exception) {
            System.out.println("Could not locate schema file.  " + exception.getMessage());
            uRL = null;
        }
        if (uRL != null) {
            try {
                SchemaGrammarProvider schemaGrammarProvider = DemoXmlContext.getSharedGrammarProvider();
                schemaGrammarProvider.addSchema(uRL);
            }
            catch (GrammarException grammarException) {
                grammarException.printStackTrace();
            }
        }
    }

    private void _showOptionPane(Throwable throwable) {
        JOptionPane.showMessageDialog(this.getMainFrame(), throwable.getLocalizedMessage(), throwable.toString(), 0);
    }

    private void _updateSave() {
        Action action = this.demoActions.findAction("save-document");
        XMLDemoActions.SaveAction saveAction = (XMLDemoActions.SaveAction)action;
        saveAction.update();
    }

    void $init$() {
        this._xmlContext = null;
        this._insightPlugin = null;
        this._tooltipPlugin = null;
    }

    public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
        this.popupMenu.show((Component)basicEditorPane, mouseEvent.getX(), mouseEvent.getY());
    }

    public void hidePopup(BasicEditorPane basicEditorPane) {
        this.popupMenu.setVisible(false);
    }

    public String getToolTipText(BasicEditorPane basicEditorPane, MouseEvent mouseEvent, int n) {
        return "Offset: " + n;
    }

    public static final class DemoMenuItem
    extends JMenuItem
    implements PropertyChangeListener {
        private Action action;

        public DemoMenuItem(String string, Action action) {
            super(string);
            this.action = action;
            if (action != null) {
                this.setActionCommand((String)action.getValue("Name"));
                this.addActionListener(action);
                PropertyChangeListener propertyChangeListener = this.createActionPropertyChangeListener(action);
                action.addPropertyChangeListener(propertyChangeListener);
                this.setEnabled(action.isEnabled());
            }
        }

        protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
            return this;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.setEnabled(bl);
                this.repaint();
            }
        }
    }
}

