/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.List;
import oracle.bali.xml.dom.buffer.DefaultParserConfiguration;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.parser.InsightParser;
import oracle.bali.xml.editor.insight.parser.TextInfo;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.model.XmlContext;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightProvider;

public abstract class AbstractXMLInsightProvider
extends AbstractInsight
implements InsightProvider {
    protected static final int FEEDBACK_MESSAGE_DELAY = 5000;
    protected static final int IN_UNKNOWN = 0;
    protected static final int ELEMENT_NAME = 1;
    protected static final int ELEMENT_LOCAL_NAME = 2;
    protected static final int ATTRIBUTE_NAME = 3;
    protected static final int ATTRIBUTE_LOCAL_NAME = 4;
    protected static final int ATTRIBUTE_VALUE = 5;
    protected static final int ELEMENT_END_TAG = 6;
    protected static final int TEXT = 7;
    private XmlContext _xmlContext;
    private ParserConfiguration _parserConfiguration;
    private InsightParser _insightParser;

    protected AbstractXMLInsightProvider(XmlContext xmlContext) {
        this(xmlContext, new DefaultParserConfiguration());
    }

    protected AbstractXMLInsightProvider(XmlContext xmlContext, ParserConfiguration parserConfiguration) {
        this.$init$();
        this._xmlContext = xmlContext;
        this._parserConfiguration = parserConfiguration;
        this._insightParser = new InsightParser(this._parserConfiguration);
    }

    protected InsightProvider createInsightProvider() {
        return this;
    }

    public void install(BasicEditorPane basicEditorPane) {
        super.install(basicEditorPane);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        super.deinstall(basicEditorPane);
    }

    public XmlContext getXmlContext() {
        return this._xmlContext;
    }

    public ParserConfiguration getParserConfiguration() {
        return this._parserConfiguration;
    }

    public GrammarProvider getGrammarProvider() {
        return this._xmlContext.getGrammarProvider();
    }

    public GrammarResolver getGrammarResolver() {
        return this._xmlContext.getGrammarResolver();
    }

    public InsightParser getInsightParser() {
        return this._insightParser;
    }

    protected void showFeedback(String string) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        FeedbackManager feedbackManager = basicEditorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(basicEditorPane, string);
        }
    }

    protected void showFeedback(String string, int n) {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        FeedbackManager feedbackManager = basicEditorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(basicEditorPane, string, n);
        }
    }

    protected void hideFeedback() {
        BasicEditorPane basicEditorPane = this.getEditorPane();
        FeedbackManager feedbackManager = basicEditorPane.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.hideFeedback(basicEditorPane);
        }
    }

    protected int getContextType(InsightLocation insightLocation) {
        TextInfo textInfo;
        ElementDeclaration elementDeclaration = null;
        List list = insightLocation.getElementDeclarations();
        int n = list.size();
        if (n > 0) {
            elementDeclaration = (ElementDeclaration)list.get(n - 1);
        }
        if (elementDeclaration != null) {
            int n2 = this.getCaretPosition();
            ElementLocator elementLocator = elementDeclaration.getElementLocator();
            if (this._caretInsideElement(elementLocator, elementLocator.isStartTagComplete(), n2)) {
                TextBuffer textBuffer = this.getTextBuffer();
                if (elementDeclaration.isStartTag()) {
                    if (this._caretInElementInsightPosition((ReadTextBuffer)textBuffer, elementDeclaration, elementLocator, n2)) {
                        if (this._caretAfterElementNamespacePrefix((ReadTextBuffer)textBuffer, elementDeclaration, elementLocator, n2)) {
                            return 2;
                        }
                        return 1;
                    }
                    ResolvedName resolvedName = null;
                    AttributeLocator attributeLocator = null;
                    AttributeDeclarations attributeDeclarations = elementDeclaration.getAttributeDeclarations();
                    int n3 = InsightUtils.getAttributeAtCaretPosition(attributeDeclarations, n2);
                    if (n3 != -1) {
                        resolvedName = attributeDeclarations.getResolvedName(n3);
                        attributeLocator = attributeDeclarations.getLocator(n3);
                    }
                    if (this._caretInAttributeInsightPosition((ReadTextBuffer)textBuffer, elementDeclaration, elementLocator, resolvedName, attributeLocator, n2)) {
                        if (this._caretAfterAttrNamespacePrefix((ReadTextBuffer)textBuffer, resolvedName, attributeLocator, n2)) {
                            return 4;
                        }
                        return 3;
                    }
                    if (this._caretInAttributeValueInsightPosition((ReadTextBuffer)textBuffer, elementDeclaration, elementLocator, resolvedName, attributeLocator, n2)) {
                        return 5;
                    }
                } else if (elementDeclaration.isEndTag() && this._caretInElementEndTagInsightPosition((ReadTextBuffer)textBuffer, elementDeclaration, elementLocator, n2)) {
                    return 6;
                }
            }
        }
        if ((textInfo = insightLocation.getCurrentTextInfo()) != null) {
            return 7;
        }
        return 0;
    }

    private boolean _caretInElementInsightPosition(ReadTextBuffer readTextBuffer, ElementDeclaration elementDeclaration, ElementLocator elementLocator, int n) {
        boolean bl = false;
        int n2 = elementLocator.getStartOffset();
        int n3 = elementLocator.getEndOffset();
        if (n > n2 && n <= n3) {
            int n4 = n - 1;
            bl = true;
            while (n4 >= n2) {
                char c = readTextBuffer.getChar(n4);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '/': {
                        bl = false;
                    }
                }
                if (!bl) break;
                --n4;
            }
        }
        return bl;
    }

    private boolean _caretInElementEndTagInsightPosition(ReadTextBuffer readTextBuffer, ElementDeclaration elementDeclaration, ElementLocator elementLocator, int n) {
        boolean bl = false;
        int n2 = elementLocator.getStartOffset();
        int n3 = elementLocator.getEndOffset();
        if (n > n2 + 1 && n <= n3) {
            int n4 = n - 1;
            bl = true;
            while (n4 >= n2) {
                char c = readTextBuffer.getChar(n4);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        bl = false;
                    }
                }
                if (!bl) break;
                --n4;
            }
        }
        return bl;
    }

    private boolean _caretInAttributeInsightPosition(ReadTextBuffer readTextBuffer, ElementDeclaration elementDeclaration, ElementLocator elementLocator, ResolvedName resolvedName, AttributeLocator attributeLocator, int n) {
        boolean bl = false;
        int n2 = elementLocator.getStartOffset();
        int n3 = elementLocator.getEndOffset();
        if (n > n2 && n <= n3) {
            SimpleLocator simpleLocator;
            bl = true;
            if (attributeLocator != null && (simpleLocator = attributeLocator.getEqualsLocator()) != null && n >= ((Locator)simpleLocator).getEndOffset()) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean _caretInAttributeValueInsightPosition(ReadTextBuffer readTextBuffer, ElementDeclaration elementDeclaration, ElementLocator elementLocator, ResolvedName resolvedName, AttributeLocator attributeLocator, int n) {
        TextLocator textLocator;
        boolean bl = false;
        if (attributeLocator != null && (textLocator = attributeLocator.getValueLocator()) != null && n >= textLocator.getStartOffset() && n <= textLocator.getEndOffset()) {
            bl = true;
        }
        return bl;
    }

    private boolean _caretAfterElementNamespacePrefix(ReadTextBuffer readTextBuffer, ElementDeclaration elementDeclaration, ElementLocator elementLocator, int n) {
        boolean bl = false;
        SimpleLocator simpleLocator = elementLocator.getNameLocator();
        if (simpleLocator != null) {
            int n2 = n - 1;
            int n3 = ((Locator)simpleLocator).getStartOffset();
            while (n2 >= n3) {
                char c = readTextBuffer.getChar(n2);
                if (c == ':') {
                    bl = true;
                    break;
                }
                --n2;
            }
        }
        return bl;
    }

    private boolean _caretAfterAttrNamespacePrefix(ReadTextBuffer readTextBuffer, ResolvedName resolvedName, AttributeLocator attributeLocator, int n) {
        SimpleLocator simpleLocator;
        boolean bl = false;
        if (attributeLocator != null && (simpleLocator = attributeLocator.getNameLocator()) != null) {
            int n2 = n - 1;
            int n3 = ((Locator)simpleLocator).getStartOffset();
            while (n2 >= n3) {
                char c = readTextBuffer.getChar(n2);
                if (c == ':') {
                    bl = true;
                    break;
                }
                --n2;
            }
        }
        return bl;
    }

    private boolean _caretInsideElement(Locator locator, boolean bl, int n) {
        if (n > locator.getStartOffset()) {
            int n2 = locator.getEndOffset();
            if (bl ? n < n2 : n <= n2) {
                return true;
            }
        }
        return false;
    }

    void $init$() {
        this._xmlContext = null;
        this._parserConfiguration = null;
        this._insightParser = null;
    }
}

