/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.data.AttributeItem;
import oracle.bali.xml.editor.insight.data.BaseItem;
import oracle.bali.xml.editor.insight.data.NamespaceItem;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemListModel;

public class AttributeInsightData
implements XMLInsightData {
    private Object _defaultData;
    private XMLCompletionInsightProvider _insight;
    private ListDataItemListModel _listModel;
    private InsightLocation _insightLocation;
    private ListDataItem[] _insightDataList;
    private Object[] _matchingDataList;
    private boolean _localNameMode;
    private boolean _showNamespacePrefixes;
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_ATTRIBUTE_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_ATTRIBUTE_DESCRIPTOR"));
    private static final List EMPTY_LIST = new ArrayList();

    public AttributeInsightData(XMLCompletionInsightProvider xMLCompletionInsightProvider, InsightLocation insightLocation, boolean bl) {
        this(xMLCompletionInsightProvider, insightLocation, bl, true);
    }

    public AttributeInsightData(XMLCompletionInsightProvider xMLCompletionInsightProvider, InsightLocation insightLocation, boolean bl, boolean bl2) {
        this.$init$();
        this._insight = xMLCompletionInsightProvider;
        this._insightLocation = insightLocation;
        this._localNameMode = bl;
        this._showNamespacePrefixes = bl2;
        this.fillDataList();
        this.updateData();
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    public boolean inLocalNameMode() {
        return this._localNameMode;
    }

    private ListDataItemListModel buildListModel() {
        if (this._listModel == null) {
            this._listModel = new ListDataItemListModel(this._insightDataList);
        }
        return this._listModel;
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public Object[] getMatchingData() {
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getDefault() {
        return this._defaultData;
    }

    public boolean complete(Object object) {
        int n;
        boolean bl = true;
        BaseItem baseItem = (BaseItem)((Object)object);
        String string = baseItem.getName();
        boolean bl2 = baseItem instanceof NamespaceItem;
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        BasicDocument basicDocument = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n2 = this._insight.getCaretPosition();
        basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (textBuffer.getChar(n3) == ' ' || textBuffer.getChar(n3) == '\t' || textBuffer.getChar(n3) == '\n') break;
            --n3;
        }
        int n4 = ++n3;
        int n5 = 32;
        while (n4 < textBuffer.getLength()) {
            if (textBuffer.getChar(n4) == ' ' || textBuffer.getChar(n4) == '\t' || textBuffer.getChar(n4) == '\n' || textBuffer.getChar(n4) == '=' || textBuffer.getChar(n4) == '<' || textBuffer.getChar(n4) == '>' || textBuffer.getChar(n4) == '/') {
                n5 = textBuffer.getChar(n4);
                break;
            }
            ++n4;
        }
        String string2 = new String(textBuffer.getChars(n3, n4 - n3));
        if (this._localNameMode && (n = string2.indexOf(":")) != -1) {
            string2 = string2.substring(n + 1);
            n3 += n + 1;
        }
        try {
            try {
                String string3 = string;
                if (!bl2) {
                    if (n5 != 61) {
                        string3 = string3 + "=\"";
                    } else {
                        bl = false;
                    }
                }
                basicDocument.remove(n3, n4 - n3);
                basicDocument.insertString(n3, string3, null);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Exception occurred in completion: " + badLocationException);
                badLocationException.printStackTrace();
            }
        }
        finally {
            basicEditorPane.endEdit();
        }
        return bl;
    }

    public void partialComplete() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        BasicDocument basicDocument = this._insight.getDocument();
        basicDocument.readLock();
        try {
            int n2;
            int n3;
            int n4 = n - 1;
            while (n4 >= 0) {
                if (textBuffer.getChar(n4) == ' ' || textBuffer.getChar(n4) == '\t' || textBuffer.getChar(n4) == '\n') break;
                --n4;
            }
            int n5 = ++n4;
            while (n5 < textBuffer.getLength()) {
                if (textBuffer.getChar(n5) == ' ' || textBuffer.getChar(n5) == '\t' || textBuffer.getChar(n5) == '\n' || textBuffer.getChar(n5) == '=' || textBuffer.getChar(n5) == '<' || textBuffer.getChar(n5) == '>' || textBuffer.getChar(n5) == '/') break;
                ++n5;
            }
            String string = new String(textBuffer.getChars(n4, n5 - n4));
            if (this._localNameMode && (n3 = string.indexOf(":")) != -1) {
                string = string.substring(n3 + 1);
                n4 += n3 + 1;
            }
            int n6 = n2 = this._insightDataList != null ? this._insightDataList.length : 0;
            int n7 = n2;
            int n8 = 0;
            while (n8 < n2) {
                BaseItem baseItem = (BaseItem)this._insightDataList[n8];
                String string2 = baseItem.getName();
                if (string2.startsWith(string)) {
                    n6 = n8;
                    break;
                }
                ++n8;
            }
            int n9 = n6;
            while (n9 < n2) {
                BaseItem baseItem = (BaseItem)this._insightDataList[n9];
                String string3 = baseItem.getName();
                if (!string3.startsWith(string)) {
                    n7 = n9;
                    break;
                }
                ++n9;
            }
            if (n6 == n2) {
                basicDocument.readUnlock();
                return;
            }
            BaseItem baseItem = (BaseItem)this._insightDataList[n6];
            String string4 = baseItem.getName();
            if (n7 - n6 > 1) {
                int n10 = n6 + 1;
                while (n10 < n7) {
                    BaseItem baseItem2 = (BaseItem)this._insightDataList[n10];
                    string4 = InsightUtils.getCommonPrefix(string4, baseItem2.getName());
                    ++n10;
                }
            }
            if (!string4.startsWith(string)) {
                System.err.println("userPrefix: " + string);
                System.err.println("commonPrefix: " + string4);
                throw new IllegalStateException("Common text/prefix error");
            }
            basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
            try {
                try {
                    basicDocument.remove(n4, n5 - n4);
                    basicDocument.insertString(n4, string4, null);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Exception occurred in partial completion: " + badLocationException);
                    badLocationException.printStackTrace();
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    public void updateData() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (textBuffer.getChar(n2) == ' ' || textBuffer.getChar(n2) == '\t' || textBuffer.getChar(n2) == '\n') break;
            --n2;
        }
        int n3 = ++n2;
        while (n3 < textBuffer.getLength()) {
            if (textBuffer.getChar(n3) == ' ' || textBuffer.getChar(n3) == '\t' || textBuffer.getChar(n3) == '\n' || textBuffer.getChar(n3) == '=' || textBuffer.getChar(n3) == '<' || textBuffer.getChar(n3) == '>' || textBuffer.getChar(n3) == '/') break;
            ++n3;
        }
        String string = new String(textBuffer.getChars(n2, n3 - n2));
        boolean bl = false;
        boolean bl2 = false;
        int n4 = string.indexOf(58);
        if (n4 != -1 && n > n2 + n4) {
            bl = true;
        }
        if (bl) {
            if (this._localNameMode) {
                string = string.substring(n4 + 1);
                n2 += n4 + 1;
            } else {
                bl2 = true;
            }
        } else if (this._localNameMode) {
            bl2 = true;
        }
        if (bl2 || n < n2 || n > n3) {
            this.clearData();
            return;
        }
        char[] cArray = textBuffer.getChars(n2, n - n2);
        string = new String(cArray);
        this.fillDefault(string);
        this.fillMatchingData(string);
    }

    private void clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new ListDataItem[0];
        }
        this._defaultData = null;
        this._matchingDataList = null;
    }

    private void fillDataList() {
        TreeSet treeSet = new TreeSet();
        List list = this._insightLocation.getElementDeclarations();
        if (list.size() > 0) {
            int n = this._insight.getCaretPosition();
            int n2 = list.size() - 1;
            ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n2);
            NamespaceDeclarations namespaceDeclarations = this._insightLocation.getNamespaceDeclarations();
            ElementDef elementDef = InsightUtils.getElementDef(this._insight.getGrammarProvider(), list, n2);
            if (elementDef != null) {
                Set set = InsightUtils.getExistingAttributes(elementDeclaration, n);
                if (!this._localNameMode) {
                    this._addPrefixes(treeSet, namespaceDeclarations);
                    this._addValidAttributes(treeSet, elementDef, set, null);
                } else {
                    String string;
                    ResolvedName resolvedName = null;
                    AttributeDeclarations attributeDeclarations = elementDeclaration.getAttributeDeclarations();
                    int n3 = InsightUtils.getAttributeAtCaretPosition(attributeDeclarations, n);
                    if (n3 != -1) {
                        resolvedName = attributeDeclarations.getResolvedName(n3);
                    }
                    if (resolvedName != null && (string = resolvedName.getNamespace()) != null) {
                        this._addValidAttributes(treeSet, elementDef, set, string);
                    }
                }
            }
        }
        this._insightDataList = new ListDataItem[treeSet.size()];
        treeSet.toArray(this._insightDataList);
    }

    private void _addPrefixes(TreeSet treeSet, NamespaceDeclarations namespaceDeclarations) {
        if (this._showNamespacePrefixes) {
            Collection collection = namespaceDeclarations.getPrefixDeclarations();
            for (NamespaceDeclaration namespaceDeclaration : collection) {
                if ("http://xmlns.oracle.com/jdeveloper/xmlef/ignored".equals(namespaceDeclaration.getNamespace())) continue;
                treeSet.add(new NamespaceItem(namespaceDeclaration.getNamespace(), namespaceDeclaration.getPrefix(), true));
            }
        }
    }

    private void _addValidAttributes(TreeSet treeSet, ElementDef elementDef, Set set, String string) {
        if (elementDef != null) {
            GrammarProvider grammarProvider;
            Grammar grammar;
            ComplexType complexType;
            Wildcard wildcard;
            this._addCollection(treeSet, elementDef.getAttributeDefs(), set, string);
            Type type = elementDef.getType();
            if (type instanceof ComplexType && (wildcard = (complexType = (ComplexType)type).getAttributeWildcard()) != null && TypeUtils.wildcardAllowsNamespace((Wildcard)wildcard, (String)string) && (grammar = (grammarProvider = this._insight.getGrammarProvider()).getGrammarForNamespace(string)) != null) {
                this._addCollection(treeSet, grammar.getAttributeDefs(), set, string);
            }
        }
    }

    private void _addCollection(TreeSet treeSet, Collection collection, Set set, String string) {
        if (collection != null) {
            ArrayList arrayList = new ArrayList(collection);
            int n = 0;
            while (n < arrayList.size()) {
                AttributeDef attributeDef = (AttributeDef)arrayList.get(n);
                QualifiedName qualifiedName = attributeDef.getQualifiedName();
                if (!set.contains(qualifiedName)) {
                    String string2 = qualifiedName.getNamespace();
                    if (string != null) {
                        if (string.equals(string2)) {
                            treeSet.add(new AttributeItem(attributeDef));
                        }
                    } else if (string2 == null) {
                        treeSet.add(new AttributeItem(attributeDef));
                    }
                }
                ++n;
            }
        }
    }

    private void fillMatchingData(String string) {
        ListDataItemListModel listDataItemListModel = this.buildListModel();
        this._matchingDataList = listDataItemListModel.getMatchingData(string);
    }

    private void fillDefault(String string) {
        this._defaultData = null;
        if (this._insightDataList.length == 0) {
            return;
        }
        int n = this._insightDataList.length;
        int n2 = string.length();
        String string2 = string.toLowerCase();
        int n3 = n2;
        while (n3 > 0) {
            String string3 = string.substring(0, n3);
            BaseItem baseItem = null;
            int n4 = 0;
            while (n4 < n) {
                BaseItem baseItem2 = (BaseItem)this._insightDataList[n4];
                String string4 = baseItem2.getName();
                if (string4.startsWith(string3)) {
                    this._defaultData = baseItem2;
                    return;
                }
                if (baseItem == null && string4.toLowerCase().startsWith(string2)) {
                    baseItem = baseItem2;
                }
                ++n4;
            }
            if (baseItem != null) {
                this._defaultData = baseItem;
                return;
            }
            --n3;
        }
    }

    void $init$() {
        this._defaultData = null;
        this._localNameMode = false;
        this._showNamespacePrefixes = true;
    }
}

