/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.data.BaseItem;
import oracle.bali.xml.editor.insight.data.ElementEndTagItem;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemListModel;

public class ElementEndTagInsightData
implements XMLInsightData {
    private Object _defaultData;
    private XMLCompletionInsightProvider _insight;
    private ListDataItemListModel _listModel;
    private InsightLocation _insightLocation;
    private ListDataItem[] _insightDataList;
    private Object[] _matchingDataList;
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR"));
    private static final List EMPTY_LIST = new ArrayList();

    public ElementEndTagInsightData(XMLCompletionInsightProvider xMLCompletionInsightProvider, InsightLocation insightLocation) {
        this.$init$();
        this._insight = xMLCompletionInsightProvider;
        this._insightLocation = insightLocation;
        this.fillDataList();
        this._updateDataImpl(true);
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    private ListDataItemListModel buildListModel() {
        if (this._listModel == null) {
            this._listModel = new ListDataItemListModel(this._insightDataList);
        }
        return this._listModel;
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public Object[] getMatchingData() {
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getDefault() {
        return this._defaultData;
    }

    public boolean complete(Object object) {
        int n;
        boolean bl = false;
        BaseItem baseItem = (BaseItem)((Object)object);
        String string = baseItem.getName();
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        BasicDocument basicDocument = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n2 = this._insight.getCaretPosition();
        basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
        List list = this._insightLocation.getElementDeclarations();
        int n3 = list.size() - 1;
        ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n3);
        ElementLocator elementLocator = elementDeclaration.getElementLocator();
        boolean bl2 = true;
        if (textBuffer.getChar(elementLocator.getEndOffset() - 1) == '>') {
            bl2 = false;
        }
        int n4 = n = elementLocator.getStartOffset() + 2;
        while (n4 < textBuffer.getLength()) {
            if (textBuffer.getChar(n4) == ' ' || textBuffer.getChar(n4) == '\t' || textBuffer.getChar(n4) == '\n' || textBuffer.getChar(n4) == '<' || textBuffer.getChar(n4) == '>') break;
            ++n4;
        }
        String string2 = new String(textBuffer.getChars(n, n4 - n));
        try {
            try {
                String string3 = string;
                if (bl2) {
                    string3 = string3 + ">";
                }
                basicDocument.remove(n, n4 - n);
                basicDocument.insertString(n, string3, null);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Exception occurred in completion: " + badLocationException);
                badLocationException.printStackTrace();
            }
        }
        finally {
            basicEditorPane.endEdit();
        }
        return bl;
    }

    public void partialComplete() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        BasicDocument basicDocument = this._insight.getDocument();
        basicDocument.readLock();
        try {
            int n2;
            int n3;
            List list = this._insightLocation.getElementDeclarations();
            int n4 = list.size() - 1;
            ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n4);
            ElementLocator elementLocator = elementDeclaration.getElementLocator();
            int n5 = n3 = elementLocator.getStartOffset() + 2;
            while (n5 < textBuffer.getLength()) {
                if (textBuffer.getChar(n5) == ' ' || textBuffer.getChar(n5) == '\t' || textBuffer.getChar(n5) == '\n' || textBuffer.getChar(n5) == '<' || textBuffer.getChar(n5) == '>') break;
                ++n5;
            }
            String string = new String(textBuffer.getChars(n3, n5 - n3));
            int n6 = n2 = this._insightDataList != null ? this._insightDataList.length : 0;
            int n7 = n2;
            int n8 = 0;
            while (n8 < n2) {
                BaseItem baseItem = (BaseItem)this._insightDataList[n8];
                String string2 = baseItem.getName();
                if (string2.startsWith(string)) {
                    n6 = n8;
                    break;
                }
                ++n8;
            }
            int n9 = n6;
            while (n9 < n2) {
                BaseItem baseItem = (BaseItem)this._insightDataList[n9];
                String string3 = baseItem.getName();
                if (!string3.startsWith(string)) {
                    n7 = n9;
                    break;
                }
                ++n9;
            }
            if (n6 == n2) {
                basicDocument.readUnlock();
                return;
            }
            BaseItem baseItem = (BaseItem)this._insightDataList[n6];
            String string4 = baseItem.getName();
            if (n7 - n6 > 1) {
                int n10 = n6 + 1;
                while (n10 < n7) {
                    BaseItem baseItem2 = (BaseItem)this._insightDataList[n10];
                    string4 = InsightUtils.getCommonPrefix(string4, baseItem2.getName());
                    ++n10;
                }
            }
            if (!string4.startsWith(string)) {
                System.err.println("userPrefix: " + string);
                System.err.println("commonPrefix: " + string4);
                throw new IllegalStateException("Common text/prefix error");
            }
            basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
            try {
                try {
                    basicDocument.remove(n3, n5 - n3);
                    basicDocument.insertString(n3, string4, null);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Exception occurred in partial completion: " + badLocationException);
                    badLocationException.printStackTrace();
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    public void updateData() {
        this._updateDataImpl(false);
    }

    private void _updateDataImpl(boolean bl) {
        int n;
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n2 = this._insight.getCaretPosition();
        List list = this._insightLocation.getElementDeclarations();
        int n3 = list.size() - 1;
        ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n3);
        ElementLocator elementLocator = elementDeclaration.getElementLocator();
        int n4 = n = elementLocator.getStartOffset() + 2;
        while (n4 < textBuffer.getLength()) {
            if (textBuffer.getChar(n4) == ' ' || textBuffer.getChar(n4) == '\t' || textBuffer.getChar(n4) == '\n' || textBuffer.getChar(n4) == '<' || textBuffer.getChar(n4) == '>') break;
            ++n4;
        }
        if (n2 < n || n2 > n4) {
            if (!bl) {
                this.clearData();
                return;
            }
        } else {
            String string = new String(textBuffer.getChars(n, n2 - n));
            this.fillDefault(string);
            this.fillMatchingData(string);
        }
    }

    private void clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new ListDataItem[0];
        }
        this._defaultData = null;
        this._matchingDataList = null;
    }

    private void fillDataList() {
        ElementDeclaration elementDeclaration;
        ResolvedName resolvedName;
        ElementDeclaration elementDeclaration2;
        ElementEndTagItem elementEndTagItem = null;
        List list = this._insightLocation.getElementDeclarations();
        int n = list.size();
        if (n >= 2 && !(elementDeclaration2 = (ElementDeclaration)list.get(n - 1)).isStartTag() && elementDeclaration2.isEndTag() && (resolvedName = (elementDeclaration = (ElementDeclaration)list.get(n - 2)).getResolvedName()) != null) {
            String string = resolvedName.getPrefix();
            String string2 = resolvedName.getLocalName();
            if (string2 != null) {
                elementEndTagItem = new ElementEndTagItem(string, string2);
            }
        }
        if (elementEndTagItem != null) {
            this._insightDataList = new ListDataItem[1];
            this._insightDataList[0] = elementEndTagItem;
        } else {
            this._insightDataList = new ListDataItem[0];
        }
    }

    private void fillMatchingData(String string) {
        ListDataItemListModel listDataItemListModel = this.buildListModel();
        this._matchingDataList = listDataItemListModel.getMatchingData(string);
    }

    private void fillDefault(String string) {
        this._defaultData = null;
        if (this._insightDataList.length == 0) {
            return;
        }
        int n = this._insightDataList.length;
        int n2 = string.length();
        String string2 = string.toLowerCase();
        int n3 = n2;
        while (n3 > 0) {
            String string3 = string.substring(0, n3);
            BaseItem baseItem = null;
            int n4 = 0;
            while (n4 < n) {
                BaseItem baseItem2 = (BaseItem)this._insightDataList[n4];
                String string4 = baseItem2.getName();
                if (string4.startsWith(string3)) {
                    this._defaultData = baseItem2;
                    return;
                }
                if (baseItem == null && string4.toLowerCase().startsWith(string2)) {
                    baseItem = baseItem2;
                }
                ++n4;
            }
            if (baseItem != null) {
                this._defaultData = baseItem;
                return;
            }
            --n3;
        }
    }

    void $init$() {
        this._defaultData = null;
    }
}

