/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.data.BaseItem;
import oracle.bali.xml.editor.insight.data.ElementItem;
import oracle.bali.xml.editor.insight.data.NamespaceItem;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemListModel;

public class ElementInsightData
implements XMLInsightData {
    private Object _defaultData;
    private boolean _localNameMode;
    private XMLCompletionInsightProvider _insight;
    private ListDataItemListModel _listModel;
    private InsightLocation _insightLocation;
    private ListDataItem[] _insightDataList;
    private Object[] _matchingDataList;
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR"));
    private static final HashSet _NAMESPACE_DECL_FILTER = new HashSet();

    public ElementInsightData(XMLCompletionInsightProvider xMLCompletionInsightProvider, InsightLocation insightLocation, boolean bl) {
        this.$init$();
        this._insight = xMLCompletionInsightProvider;
        this._insightLocation = insightLocation;
        this._localNameMode = bl;
        this.fillDataList();
        this._updateDataImpl();
    }

    public final boolean inLocalNameMode() {
        return this._localNameMode;
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    private ListDataItemListModel buildListModel() {
        if (this._listModel == null) {
            this._listModel = new ListDataItemListModel(this._insightDataList);
        }
        return this._listModel;
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public Object[] getMatchingData() {
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getDefault() {
        return this._defaultData;
    }

    public boolean complete(Object object) {
        int n;
        int n2;
        boolean bl = false;
        BaseItem baseItem = (BaseItem)((Object)object);
        String string = baseItem.getName();
        if (baseItem instanceof NamespaceItem) {
            bl = true;
        }
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        BasicDocument basicDocument = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n3 = this._insight.getCaretPosition();
        basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
        List list = this._insightLocation.getElementDeclarations();
        int n4 = list.size() - 1;
        ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n4);
        int n5 = n2 = elementDeclaration.getElementLocator().getStartOffset() + 1;
        while (n5 < textBuffer.getLength()) {
            if (textBuffer.getChar(n5) == ' ' || textBuffer.getChar(n5) == '\t' || textBuffer.getChar(n5) == '\n' || textBuffer.getChar(n5) == '/' || textBuffer.getChar(n5) == '<' || textBuffer.getChar(n5) == '>') break;
            ++n5;
        }
        String string2 = new String(textBuffer.getChars(n2, n5 - n2));
        if (this._localNameMode && (n = string2.indexOf(":")) != -1) {
            string2 = string2.substring(n + 1);
            n2 += n + 1;
        }
        TreeSet treeSet = null;
        if (baseItem instanceof ElementItem) {
            try {
                if (EditorProperties.getProperties().getBooleanProperty("XMLLanguageModule.REQUIRED_ATTRIBUTE_INSERTION")) {
                    ElementItem elementItem = (ElementItem)baseItem;
                    ElementDef elementDef = elementItem.getElementDef();
                    treeSet = this.getMissingRequiredAttributes(elementDef, elementDeclaration, n3);
                }
            }
            catch (Exception exception) {
                treeSet = null;
            }
        }
        try {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                if (treeSet != null && treeSet.size() > 0) {
                    NamespaceDeclarations namespaceDeclarations = this._insightLocation.getNamespaceDeclarations();
                    for (QualifiedName qualifiedName : treeSet) {
                        String string3 = null;
                        String string4 = qualifiedName.getNamespace();
                        if (string4 != null && string4.length() > 0 && (string3 = InsightUtils.getPrefix(namespaceDeclarations, string4)) == null) continue;
                        stringBuffer.append(" ");
                        if (string3 != null) {
                            stringBuffer.append(string3);
                            stringBuffer.append(":");
                        }
                        stringBuffer.append(qualifiedName.getName());
                        stringBuffer.append("=\"\"");
                    }
                }
                basicDocument.remove(n2, n5 - n2);
                basicDocument.insertString(n2, stringBuffer.toString(), null);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Exception occurred in completion: " + badLocationException);
                badLocationException.printStackTrace();
            }
        }
        finally {
            basicEditorPane.endEdit();
        }
        return bl;
    }

    public void partialComplete() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        BasicDocument basicDocument = this._insight.getDocument();
        basicDocument.readLock();
        try {
            int n;
            int n2;
            int n3;
            List list = this._insightLocation.getElementDeclarations();
            int n4 = list.size() - 1;
            ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n4);
            int n5 = n3 = elementDeclaration.getElementLocator().getStartOffset() + 1;
            while (n5 < textBuffer.getLength()) {
                if (textBuffer.getChar(n5) == ' ' || textBuffer.getChar(n5) == '\t' || textBuffer.getChar(n5) == '\n' || textBuffer.getChar(n5) == '/' || textBuffer.getChar(n5) == '<' || textBuffer.getChar(n5) == '>') break;
                ++n5;
            }
            String string = new String(textBuffer.getChars(n3, n5 - n3));
            if (this._localNameMode && (n2 = string.indexOf(":")) != -1) {
                string = string.substring(n2 + 1);
                n3 += n2 + 1;
            }
            int n6 = n = this._insightDataList != null ? this._insightDataList.length : 0;
            int n7 = n;
            int n8 = 0;
            while (n8 < n) {
                BaseItem baseItem = (BaseItem)this._insightDataList[n8];
                String string2 = baseItem.getName();
                if (string2.startsWith(string)) {
                    n6 = n8;
                    break;
                }
                ++n8;
            }
            int n9 = n6;
            while (n9 < n) {
                BaseItem baseItem = (BaseItem)this._insightDataList[n9];
                String string3 = baseItem.getName();
                if (!string3.startsWith(string)) {
                    n7 = n9;
                    break;
                }
                ++n9;
            }
            if (n6 == n) {
                basicDocument.readUnlock();
                return;
            }
            BaseItem baseItem = (BaseItem)this._insightDataList[n6];
            String string4 = baseItem.getName();
            if (n7 - n6 > 1) {
                int n10 = n6 + 1;
                while (n10 < n7) {
                    BaseItem baseItem2 = (BaseItem)this._insightDataList[n10];
                    string4 = InsightUtils.getCommonPrefix(string4, baseItem2.getName());
                    ++n10;
                }
            }
            if (!string4.startsWith(string)) {
                System.err.println("userPrefix: " + string);
                System.err.println("commonPrefix: " + string4);
                throw new IllegalStateException("Common text/prefix error");
            }
            basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
            try {
                try {
                    basicDocument.remove(n3, n5 - n3);
                    basicDocument.insertString(n3, string4, null);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Exception occurred in partial completion: " + badLocationException);
                    badLocationException.printStackTrace();
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    public void updateData() {
        this._updateDataImpl();
    }

    protected final XMLCompletionInsightProvider getInsightProvider() {
        return this._insight;
    }

    protected final InsightLocation getInsightLocation() {
        return this._insightLocation;
    }

    protected void fillDataList() {
        TreeSet treeSet = new TreeSet();
        List list = this._insightLocation.getElementDeclarations();
        if (list.size() > 0) {
            ElementDef elementDef;
            int n = list.size() - 1;
            int n2 = list.size() - 2;
            NamespaceDeclarations namespaceDeclarations = this._insightLocation.getNamespaceDeclarations();
            String string = namespaceDeclarations.getDefaultNamespace();
            if (list.size() > 1 && (elementDef = InsightUtils.getElementDef(this._insight.getGrammarProvider(), list, n2)) != null) {
                ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n);
                String string2 = null;
                if (this._localNameMode) {
                    ResolvedName resolvedName = elementDeclaration.getResolvedName();
                    string2 = resolvedName.getNamespace();
                } else {
                    this.addPrefixes(treeSet, namespaceDeclarations);
                    string2 = string;
                }
                this.addValidChildren(treeSet, elementDef, string2);
            }
            if (list.size() == 1) {
                ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n);
                String string3 = null;
                if (this._localNameMode) {
                    ResolvedName resolvedName = elementDeclaration.getResolvedName();
                    string3 = resolvedName.getNamespace();
                } else {
                    this.addPrefixes(treeSet, namespaceDeclarations);
                    string3 = string;
                }
                GrammarProvider grammarProvider = this._insight.getGrammarProvider();
                this.addTopLevelElements(treeSet, grammarProvider.getGrammarForNamespace(string3));
            }
        }
        this.postProcessDataList(treeSet);
        this._insightDataList = new ListDataItem[treeSet.size()];
        treeSet.toArray(this._insightDataList);
    }

    protected void postProcessDataList(TreeSet treeSet) {
    }

    protected void addPrefixes(TreeSet treeSet, NamespaceDeclarations namespaceDeclarations) {
        Collection collection = namespaceDeclarations.getPrefixDeclarations();
        for (NamespaceDeclaration namespaceDeclaration : collection) {
            if (_NAMESPACE_DECL_FILTER.contains(namespaceDeclaration.getNamespace())) continue;
            treeSet.add(new NamespaceItem(namespaceDeclaration.getNamespace(), namespaceDeclaration.getPrefix()));
        }
    }

    protected void addValidChildren(TreeSet treeSet, ElementDef elementDef, String string) {
        if (elementDef != null) {
            GrammarProvider grammarProvider;
            Grammar grammar;
            this.addCollection(treeSet, elementDef.getElementDefs(), string);
            List list = TypeUtils.getElementWildcards((ElementDef)elementDef);
            Wildcard wildcard = TypeUtils.getMatchingWildcard((List)list, (String)string);
            if (wildcard != null && (grammar = (grammarProvider = this._insight.getGrammarProvider()).getGrammarForNamespace(string)) != null) {
                this.addCollection(treeSet, grammar.getElementDefs(), string);
            }
        }
    }

    protected void addCollection(TreeSet treeSet, Collection collection, String string) {
        if (collection != null) {
            ArrayList arrayList = new ArrayList(collection);
            int n = 0;
            while (n < arrayList.size()) {
                ElementDef elementDef = (ElementDef)arrayList.get(n);
                String string2 = elementDef.getTargetNamespace();
                if (string == null) {
                    if (string2 == null) {
                        treeSet.add(new ElementItem(elementDef));
                    }
                } else if (string.equals(string2)) {
                    treeSet.add(new ElementItem(elementDef));
                }
                ++n;
            }
        }
    }

    protected void addTopLevelElements(TreeSet treeSet, Grammar grammar) {
        if (grammar != null) {
            this.addCollection(treeSet, grammar.getElementDefs(), grammar.getTargetNamespace());
        }
    }

    protected TreeSet getMissingRequiredAttributes(ElementDef elementDef, ElementDeclaration elementDeclaration, int n) {
        Collection collection;
        TreeSet<QualifiedName> treeSet = new TreeSet<QualifiedName>();
        if (elementDef != null && (collection = elementDef.getAttributeDefs()) != null) {
            ArrayList arrayList = InsightUtils.getRequiredAttributeDefs(collection);
            Set set = InsightUtils.getExistingAttributes(elementDeclaration, n);
            int n2 = 0;
            while (n2 < arrayList.size()) {
                AttributeDef attributeDef = (AttributeDef)arrayList.get(n2);
                QualifiedName qualifiedName = attributeDef.getQualifiedName();
                if (!set.contains(qualifiedName)) {
                    treeSet.add(qualifiedName);
                }
                ++n2;
            }
        }
        return treeSet;
    }

    private void _updateDataImpl() {
        int n;
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n2 = this._insight.getCaretPosition();
        List list = this._insightLocation.getElementDeclarations();
        ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(list.size() - 1);
        int n3 = n = elementDeclaration.getElementLocator().getStartOffset() + 1;
        while (n3 < textBuffer.getLength()) {
            if (textBuffer.getChar(n3) == ' ' || textBuffer.getChar(n3) == '\t' || textBuffer.getChar(n3) == '\n' || textBuffer.getChar(n3) == '/' || textBuffer.getChar(n3) == '<' || textBuffer.getChar(n3) == '>') break;
            ++n3;
        }
        String string = new String(textBuffer.getChars(n, n3 - n));
        boolean bl = false;
        boolean bl2 = false;
        int n4 = string.indexOf(58);
        if (n4 != -1 && n2 > n + n4) {
            bl = true;
        }
        if (bl) {
            if (this._localNameMode) {
                string = string.substring(n4 + 1);
                n += n4 + 1;
            } else {
                bl2 = true;
            }
        } else if (this._localNameMode) {
            bl2 = true;
        }
        if (bl2 || n2 < n || n2 > n3) {
            this._clearData();
            return;
        }
        string = new String(textBuffer.getChars(n, n2 - n));
        this._fillDefault(string);
        this._fillMatchingData(string);
    }

    private void _clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new ListDataItem[0];
        }
        this._defaultData = null;
        this._matchingDataList = null;
    }

    private void _fillMatchingData(String string) {
        ListDataItemListModel listDataItemListModel = this.buildListModel();
        this._matchingDataList = listDataItemListModel.getMatchingData(string);
    }

    private void _fillDefault(String string) {
        this._defaultData = null;
        if (this._insightDataList.length == 0) {
            return;
        }
        int n = this._insightDataList.length;
        int n2 = string.length();
        String string2 = string.toLowerCase();
        int n3 = n2;
        while (n3 > 0) {
            String string3 = string.substring(0, n3);
            BaseItem baseItem = null;
            int n4 = 0;
            while (n4 < n) {
                BaseItem baseItem2 = (BaseItem)this._insightDataList[n4];
                String string4 = baseItem2.getName();
                if (string4.startsWith(string3)) {
                    this._defaultData = baseItem2;
                    return;
                }
                if (baseItem == null && string4.toLowerCase().startsWith(string2)) {
                    baseItem = baseItem2;
                }
                ++n4;
            }
            if (baseItem != null) {
                this._defaultData = baseItem;
                return;
            }
            --n3;
        }
    }

    void $init$() {
        this._defaultData = null;
        this._localNameMode = false;
    }

    static {
        _NAMESPACE_DECL_FILTER.add("http://www.w3.org/XML/1998/namespace");
        _NAMESPACE_DECL_FILTER.add("http://www.w3.org/2000/xmlns/");
        _NAMESPACE_DECL_FILTER.add("http://www.w3.org/2001/XMLSchema-instance");
        _NAMESPACE_DECL_FILTER.add("http://xmlns.oracle.com/jdeveloper/xmlef/ignored");
    }
}

