/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.beans.PropertyVetoException;
import java.util.Set;
import java.util.TreeSet;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.ValueInsightData;
import oracle.bali.xml.editor.insight.data.AttributeValueItemItem;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.javatools.editor.insight.ListDataItem;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnumerationValueInsightData
extends ValueInsightData {
    public ListDataItem[] getListDataItems(QualifiedName qualifiedName, ElementDef elementDef, AttributeDef attributeDef, ElementDeclaration elementDeclaration, AttributeDeclarations attributeDeclarations, int n, int n2) {
        TreeSet<AttributeValueItemItem> treeSet = null;
        XmlContext xmlContext = this.getProvider().getXmlContext();
        if (xmlContext != null) {
            XmlModel xmlModel = xmlContext.getModel();
            DomModel domModel = xmlModel.getDomModel();
            xmlModel.acquireReadLock();
            try {
                Node node;
                DomPosition domPosition = domModel.getDomPosition(n2);
                if (domPosition != null && (node = domPosition.getTargetNode()) != null && node.getNodeType() == 1) {
                    Attr attr;
                    Element element = (Element)node;
                    int n3 = domModel.getTextOffset(DomPositionFactory.createDomPosition((Node)element, (int)1));
                    ElementLocator elementLocator = elementDeclaration.getElementLocator();
                    if (elementLocator.getStartOffset() == n3 && (attr = element.getAttributeNodeNS(qualifiedName.getNamespace(), qualifiedName.getName())) != null) {
                        treeSet = new TreeSet();
                        BaseInspectorGui baseInspectorGui = (BaseInspectorGui)((GuiXmlContext)xmlContext).getGui(XmlUsage.PROPERTY_INSPECTOR);
                        Set set = baseInspectorGui.getAttributeValues(attr);
                        if (set != null) {
                            for (AttributeValueItem attributeValueItem : set) {
                                if (attributeValueItem.getDisplayText() == null) continue;
                                treeSet.add(new AttributeValueItemItem(attributeValueItem, attr));
                            }
                        }
                    }
                }
            }
            finally {
                xmlModel.releaseReadLock();
            }
        }
        if (treeSet == null) {
            treeSet = new TreeSet<AttributeValueItemItem>();
            if (attributeDef != null) {
                InsightUtils.getAttributeValues(attributeDef, treeSet);
            }
        }
        ListDataItem[] listDataItemArray = new ListDataItem[treeSet.size()];
        treeSet.toArray(listDataItemArray);
        return listDataItemArray;
    }

    protected String getSelectedText(Object object) {
        if (object instanceof AttributeValueItemItem) {
            AttributeValueItem attributeValueItem = ((AttributeValueItemItem)((Object)object)).getItem();
            try {
                String string = attributeValueItem.selectValue();
                return string;
            }
            catch (PropertyVetoException propertyVetoException) {
                String string = null;
                return string;
            }
        }
        return super.getSelectedText(object);
    }
}

