/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.insight.data.TextItem;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.util.AttributeValueUtils;
import oracle.javatools.buffer.ReadTextBuffer;

public final class InsightUtils {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    public static ElementDef getElementDef(GrammarProvider grammarProvider, List list, int n) {
        ElementDef elementDef = null;
        int n2 = 0;
        while (n2 <= n) {
            ElementDef elementDef2 = null;
            ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n2);
            ResolvedName resolvedName = elementDeclaration.getResolvedName();
            if (resolvedName != null) {
                String string = resolvedName.getNamespace();
                String string2 = resolvedName.getLocalName();
                if (string2 != null) {
                    Grammar grammar;
                    if (elementDef != null) {
                        elementDef2 = elementDef.getElementDefByName(string, string2);
                    }
                    if (elementDef2 == null && (grammar = grammarProvider.getGrammarForNamespace(string)) != null) {
                        elementDef2 = grammar.getElementDefByName(string2);
                    }
                }
            }
            elementDef = elementDef2;
            ++n2;
        }
        return elementDef;
    }

    public static String getPrefix(NamespaceDeclarations namespaceDeclarations, String string) {
        String string2 = null;
        if (string != null) {
            Collection collection = namespaceDeclarations.getPrefixDeclarations();
            for (NamespaceDeclaration namespaceDeclaration : collection) {
                if (!string.equals(namespaceDeclaration.getNamespace())) continue;
                string2 = namespaceDeclaration.getPrefix();
                break;
            }
        }
        return string2;
    }

    public static int getAttributeAtCaretPosition(AttributeDeclarations attributeDeclarations, int n) {
        int n2 = -1;
        AttributeLocator attributeLocator = null;
        int n3 = attributeDeclarations.getLength();
        int n4 = 0;
        while (n4 < n3) {
            attributeLocator = attributeDeclarations.getLocator(n4);
            if (n >= attributeLocator.getStartOffset() && n <= attributeLocator.getEndOffset()) {
                n2 = n4;
                break;
            }
            ++n4;
        }
        return n2;
    }

    public static Set getExistingAttributes(ElementDeclaration elementDeclaration, int n) {
        HashSet<QualifiedName> hashSet = new HashSet<QualifiedName>(11);
        AttributeDeclarations attributeDeclarations = elementDeclaration.getAttributeDeclarations();
        int n2 = attributeDeclarations.getLength();
        int n3 = 0;
        while (n3 < n2) {
            ResolvedName resolvedName;
            AttributeLocator attributeLocator = attributeDeclarations.getLocator(n3);
            if ((n < attributeLocator.getStartOffset() || n > attributeLocator.getEndOffset()) && (resolvedName = attributeDeclarations.getResolvedName(n3)) != null) {
                String string = resolvedName.getNamespace();
                String string2 = resolvedName.getLocalName();
                if (string2 != null && string2.length() > 0) {
                    QualifiedName qualifiedName = QualifiedName.getQualifiedName((String)string, (String)string2);
                    hashSet.add(qualifiedName);
                }
            }
            ++n3;
        }
        return hashSet;
    }

    public static ArrayList getRequiredAttributeDefs(Collection collection) {
        ArrayList<AttributeDef> arrayList = new ArrayList<AttributeDef>(1);
        if (collection != null) {
            ArrayList arrayList2 = new ArrayList(collection);
            int n = 0;
            while (n < arrayList2.size()) {
                AttributeDef attributeDef = (AttributeDef)arrayList2.get(n);
                if (attributeDef.isRequired()) {
                    arrayList.add(attributeDef);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static String getCommonPrefix(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != string2.charAt(n2)) {
                return string.substring(0, n2);
            }
            ++n2;
        }
        return string.substring(0, n);
    }

    public static String getBufferText(ReadTextBuffer readTextBuffer, int n, int n2) {
        String string = "";
        int n3 = n2 - n;
        char[] cArray = readTextBuffer.getChars(n, n3);
        if (cArray != null && cArray.length > 0) {
            string = new String(cArray);
        }
        return string;
    }

    public static void getAttributeValues(AttributeDef attributeDef, TreeSet treeSet) {
        Set set = AttributeValueUtils.getAttributeValues((AttributeDef)attributeDef);
        for (String string : set) {
            TextItem textItem = new TextItem(string);
            treeSet.add(textItem);
        }
    }

    private InsightUtils() {
    }
}

