/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.data.BaseItem;
import oracle.bali.xml.editor.insight.data.TextItem;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.parser.TextInfo;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.util.AttributeValueUtils;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemListModel;

public class TextInsightData
implements XMLInsightData {
    private Object _defaultData;
    private XMLCompletionInsightProvider _insight;
    private ListDataItemListModel _listModel;
    private InsightLocation _insightLocation;
    private ListDataItem[] _insightDataList;
    private Object[] _matchingDataList;
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_VALUE_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_VALUE_DESCRIPTOR"));

    public TextInsightData(XMLCompletionInsightProvider xMLCompletionInsightProvider, InsightLocation insightLocation) {
        this.$init$();
        this._insight = xMLCompletionInsightProvider;
        this._insightLocation = insightLocation;
        this._fillDataList();
        this._updateDataImpl();
    }

    public ListModel getListModel() {
        return this._buildListModel();
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public Object[] getMatchingData() {
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getDefault() {
        return this._defaultData;
    }

    public boolean complete(Object object) {
        ListDataItem listDataItem = (ListDataItem)object;
        String string = listDataItem.getName();
        if (string == null) {
            return false;
        }
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        BasicDocument basicDocument = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
        TextInfo textInfo = this._insightLocation.getCurrentTextInfo();
        TextLocator textLocator = textInfo.getLocator();
        int n = textLocator.getStartOffset();
        int n2 = this._guessTextEndOffset((ReadTextBuffer)textBuffer, textLocator);
        try {
            try {
                basicDocument.remove(n, n2 - n);
                basicDocument.insertString(n, string, null);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Exception occurred in completion: " + badLocationException);
                badLocationException.printStackTrace();
            }
        }
        finally {
            basicEditorPane.endEdit();
        }
        return false;
    }

    public void partialComplete() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        BasicDocument basicDocument = this._insight.getDocument();
        basicDocument.readLock();
        try {
            int n;
            TextInfo textInfo = this._insightLocation.getCurrentTextInfo();
            TextLocator textLocator = textInfo.getLocator();
            int n2 = textLocator.getStartOffset();
            int n3 = this._guessTextEndOffset((ReadTextBuffer)textBuffer, textLocator);
            String string = "";
            if (n3 > n2) {
                string = new String(textBuffer.getChars(n2, n3 - n2));
            }
            int n4 = n = this._insightDataList != null ? this._insightDataList.length : 0;
            int n5 = n;
            int n6 = 0;
            while (n6 < n) {
                ListDataItem listDataItem = this._insightDataList[n6];
                String string2 = listDataItem.getName();
                if (string2.startsWith(string)) {
                    n4 = n6;
                    break;
                }
                ++n6;
            }
            int n7 = n4;
            while (n7 < n) {
                ListDataItem listDataItem = this._insightDataList[n7];
                String string3 = listDataItem.getName();
                if (!string3.startsWith(string)) {
                    n5 = n7;
                    break;
                }
                ++n7;
            }
            if (n4 == n) {
                basicDocument.readUnlock();
                return;
            }
            ListDataItem listDataItem = this._insightDataList[n4];
            String string4 = listDataItem.getName();
            if (n5 - n4 > 1) {
                int n8 = n4 + 1;
                while (n8 < n5) {
                    ListDataItem listDataItem2 = this._insightDataList[n8];
                    string4 = InsightUtils.getCommonPrefix(string4, listDataItem2.getName());
                    ++n8;
                }
            }
            if (!string4.startsWith(string)) {
                System.err.println("userPrefix: " + string);
                System.err.println("commonPrefix: " + string4);
                throw new IllegalStateException("Common text/prefix error");
            }
            basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
            try {
                try {
                    if (n3 > n2) {
                        basicDocument.remove(n2, n3 - n2);
                    }
                    basicDocument.insertString(n2, string4, null);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Exception occurred in partial completion: " + badLocationException);
                    badLocationException.printStackTrace();
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    public void updateData() {
        this._updateDataImpl();
    }

    public void updateInsightLocation(InsightLocation insightLocation) {
        int n;
        TextInfo textInfo = this._insightLocation.getCurrentTextInfo();
        int n2 = textInfo.getLocator().getStartOffset();
        TextInfo textInfo2 = insightLocation.getCurrentTextInfo();
        if (textInfo2 != null && (n = textInfo2.getLocator().getStartOffset()) == n2) {
            this._insightLocation = insightLocation;
        }
    }

    private ListDataItemListModel _buildListModel() {
        if (this._listModel == null) {
            this._listModel = new ListDataItemListModel(this._insightDataList);
        }
        return this._listModel;
    }

    private void _updateDataImpl() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        TextInfo textInfo = this._insightLocation.getCurrentTextInfo();
        TextLocator textLocator = textInfo.getLocator();
        int n2 = textLocator.getStartOffset();
        int n3 = this._guessTextEndOffset((ReadTextBuffer)textBuffer, textLocator);
        if (n < n2 || n > n3) {
            this._clearData();
            return;
        }
        String string = "";
        if (n > n2) {
            if (n < n3) {
                n3 = n;
            }
            string = new String(textBuffer.getChars(n2, n3 - n2));
        }
        this._setDefault(string);
        this._fillMatchingData(string);
    }

    private int _guessTextEndOffset(ReadTextBuffer readTextBuffer, TextLocator textLocator) {
        int n = textLocator.getEndOffset();
        int n2 = textLocator.getStartOffset();
        boolean bl = false;
        if (n2 >= 0) {
            while (n2 < n && !bl) {
                char c = readTextBuffer.getChar(n2);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                ++n2;
            }
        }
        return n2;
    }

    private void _clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new ListDataItem[0];
        }
        this._defaultData = null;
        this._matchingDataList = null;
    }

    private void _fillDataList() {
        TreeSet treeSet = new TreeSet();
        List list = this._insightLocation.getElementDeclarations();
        if (list.size() > 0) {
            SimpleType simpleType;
            int n = list.size() - 1;
            ElementDef elementDef = InsightUtils.getElementDef(this._insight.getGrammarProvider(), list, n);
            if (elementDef != null && TypeUtils.isSimpleTypeOrComplexTextOnlyElement((GrammarComponent)elementDef) && (simpleType = TypeUtils.getSimpleTypeAncestor((Type)elementDef.getType())) != null) {
                this._addSimpleTypeValues(treeSet, simpleType);
            }
        }
        this._insightDataList = new ListDataItem[treeSet.size()];
        treeSet.toArray(this._insightDataList);
    }

    private void _addSimpleTypeValues(TreeSet treeSet, SimpleType simpleType) {
        Set set = AttributeValueUtils.getAttributeValues((SimpleType)simpleType);
        for (String string : set) {
            TextItem textItem = new TextItem(string);
            treeSet.add(textItem);
        }
    }

    private void _fillMatchingData(String string) {
        ListDataItemListModel listDataItemListModel = this._buildListModel();
        this._matchingDataList = listDataItemListModel.getMatchingData(string);
    }

    private void _setDefault(String string) {
        this._defaultData = null;
        if (this._insightDataList.length == 0) {
            return;
        }
        int n = this._insightDataList.length;
        int n2 = string.length();
        String string2 = string.toLowerCase();
        int n3 = n2;
        while (n3 > 0) {
            String string3 = string.substring(0, n3);
            BaseItem baseItem = null;
            int n4 = 0;
            while (n4 < n) {
                BaseItem baseItem2 = (BaseItem)this._insightDataList[n4];
                String string4 = baseItem2.getName();
                if (string4.startsWith(string3)) {
                    this._defaultData = baseItem2;
                    return;
                }
                if (baseItem == null && string4.toLowerCase().startsWith(string2)) {
                    baseItem = baseItem2;
                }
                ++n4;
            }
            if (baseItem != null) {
                this._defaultData = baseItem;
                return;
            }
            --n3;
        }
    }

    void $init$() {
        this._defaultData = null;
    }
}

