/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.Arrays;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemListModel;

public abstract class ValueInsightData
implements XMLInsightData {
    private XMLCompletionInsightProvider _insight;
    private InsightLocation _insightLocation;
    private ListDataItemListModel _listModel;
    private ListDataItem[] _insightDataList;
    private Object[] _matchingDataList;
    private Object _defaultData;
    private AttributeLocator _attrLocator;
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_VALUE_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_VALUE_DESCRIPTOR"));

    public void initialize(XMLCompletionInsightProvider xMLCompletionInsightProvider, InsightLocation insightLocation) {
        this._insight = xMLCompletionInsightProvider;
        this._insightLocation = insightLocation;
        this._attrLocator = null;
        this._clearData();
        List list = this._insightLocation.getElementDeclarations();
        if (list.size() > 0) {
            int n = this._insight.getCaretPosition();
            int n2 = list.size() - 1;
            ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n2);
            ResolvedName resolvedName = null;
            AttributeDeclarations attributeDeclarations = elementDeclaration.getAttributeDeclarations();
            int n3 = InsightUtils.getAttributeAtCaretPosition(attributeDeclarations, n);
            if (n3 != -1) {
                resolvedName = attributeDeclarations.getResolvedName(n3);
                this._attrLocator = attributeDeclarations.getLocator(n3);
            }
            if (resolvedName != null) {
                String string = resolvedName.getNamespace();
                String string2 = resolvedName.getLocalName();
                if (string2 != null && string2.length() > 0) {
                    QualifiedName qualifiedName = QualifiedName.getQualifiedName((String)string, (String)string2);
                    AttributeDef attributeDef = null;
                    ElementDef elementDef = InsightUtils.getElementDef(this.getProvider().getGrammarProvider(), list, n2);
                    if (elementDef != null) {
                        attributeDef = elementDef.getAttributeDefByName(qualifiedName);
                    }
                    this._insightDataList = this.getListDataItems(qualifiedName, elementDef, attributeDef, elementDeclaration, attributeDeclarations, n3, n);
                    if (this._insightDataList == null) {
                        this._insightDataList = new ListDataItem[0];
                    } else {
                        Arrays.sort(this._insightDataList);
                        this.updateData();
                    }
                }
            }
        }
    }

    public abstract ListDataItem[] getListDataItems(QualifiedName var1, ElementDef var2, AttributeDef var3, ElementDeclaration var4, AttributeDeclarations var5, int var6, int var7);

    public ListModel getListModel() {
        return this._buildListModel();
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public Object[] getMatchingData() {
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] objectArray = this.getMatchingData();
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getDefault() {
        return this._defaultData;
    }

    public boolean complete(Object object) {
        boolean bl = false;
        String string = this.getSelectedText(object);
        if (string == null) {
            return false;
        }
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        BasicDocument basicDocument = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
        TextLocator textLocator = this._attrLocator.getValueLocator();
        int n2 = ((Locator)textLocator).getStartOffset();
        int n3 = this.guessValueEndOffset((ReadTextBuffer)textBuffer, n2);
        String string2 = new String(textBuffer.getChars(n2, n3 - n2));
        try {
            try {
                String string3 = "\"" + string + "\"";
                basicDocument.remove(n2, n3 - n2);
                basicDocument.insertString(n2, string3, null);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Exception occurred in completion: " + badLocationException);
                badLocationException.printStackTrace();
            }
        }
        finally {
            basicEditorPane.endEdit();
        }
        return false;
    }

    public void partialComplete() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        BasicDocument basicDocument = this._insight.getDocument();
        basicDocument.readLock();
        try {
            int n2;
            char c;
            char c2;
            TextLocator textLocator = this._attrLocator.getValueLocator();
            int n3 = ((Locator)textLocator).getStartOffset();
            int n4 = this.guessValueEndOffset((ReadTextBuffer)textBuffer, n3);
            if (n4 - n3 > 0 && ((c2 = textBuffer.getChar(n3)) == '\"' || c2 == '\'')) {
                ++n3;
            }
            if (n4 - n3 > 0 && ((c = textBuffer.getChar(n4 - 1)) == '\"' || c == '\'')) {
                --n4;
            }
            String string = new String(textBuffer.getChars(n3, n4 - n3));
            int n5 = n2 = this._insightDataList != null ? this._insightDataList.length : 0;
            int n6 = n2;
            int n7 = 0;
            while (n7 < n2) {
                ListDataItem listDataItem = this._insightDataList[n7];
                String string2 = listDataItem.getName();
                if (string2.startsWith(string)) {
                    n5 = n7;
                    break;
                }
                ++n7;
            }
            int n8 = n5;
            while (n8 < n2) {
                ListDataItem listDataItem = this._insightDataList[n8];
                String string3 = listDataItem.getName();
                if (!string3.startsWith(string)) {
                    n6 = n8;
                    break;
                }
                ++n8;
            }
            if (n5 == n2) {
                basicDocument.readUnlock();
                return;
            }
            ListDataItem listDataItem = this._insightDataList[n5];
            String string4 = listDataItem.getName();
            if (n6 - n5 > 1) {
                int n9 = n5 + 1;
                while (n9 < n6) {
                    ListDataItem listDataItem2 = this._insightDataList[n9];
                    string4 = InsightUtils.getCommonPrefix(string4, listDataItem2.getName());
                    ++n9;
                }
            }
            if (!string4.startsWith(string)) {
                System.err.println("userPrefix: " + string);
                System.err.println("commonPrefix: " + string4);
                throw new IllegalStateException("Common text/prefix error");
            }
            basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
            try {
                try {
                    basicDocument.remove(n3, n4 - n3);
                    basicDocument.insertString(n3, string4, null);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Exception occurred in partial completion: " + badLocationException);
                    badLocationException.printStackTrace();
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    public void updateData() {
        char c;
        char c2;
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        TextLocator textLocator = this._attrLocator.getValueLocator();
        int n2 = ((Locator)textLocator).getStartOffset();
        int n3 = this.guessValueEndOffset((ReadTextBuffer)textBuffer, n2);
        if (n < n2 || n > n3) {
            this._clearData();
            return;
        }
        if (n3 - n2 > 0 && ((c2 = textBuffer.getChar(n2)) == '\"' || c2 == '\'')) {
            ++n2;
        }
        if (n3 - n2 > 0 && ((c = textBuffer.getChar(n3 - 1)) == '\"' || c == '\'')) {
            --n3;
        }
        String string = "";
        if (n > n2) {
            if (n < n3) {
                n3 = n;
            }
            string = new String(textBuffer.getChars(n2, n3 - n2));
        }
        this._setDefault(string);
        this.fillMatchingData(string);
    }

    protected String getSelectedText(Object object) {
        ListDataItem listDataItem = (ListDataItem)object;
        return listDataItem.getName();
    }

    protected int guessValueEndOffset(ReadTextBuffer readTextBuffer, int n) {
        char c = '\u0000';
        int n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        int n3 = -1;
        int n4 = -1;
        if (n2 >= 0) {
            while (n2 < readTextBuffer.getLength() && !bl) {
                char c2 = readTextBuffer.getChar(n2);
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (c == '\u0000') {
                            bl = true;
                        }
                        if (n3 != -1) break;
                        n3 = n2;
                        break;
                    }
                    case '/': {
                        if (c == '\u0000') {
                            bl = true;
                        }
                        n4 = n2;
                        break;
                    }
                    case '=': 
                    case '>': 
                    case '?': {
                        if (c == '\u0000') {
                            bl = true;
                            break;
                        }
                        bl2 = true;
                        if (n3 != -1) break;
                        n3 = n2;
                        break;
                    }
                    case '<': {
                        bl = true;
                        bl3 = false;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        if (c != '\u0000') {
                            if (c != c2) break;
                            c = '\u0000';
                            break;
                        }
                        c = c2;
                        break;
                    }
                }
                if (bl) continue;
                ++n2;
            }
            if (!bl3 || bl2) {
                if (n4 != -1 && n4 < n2) {
                    n2 = n4;
                }
                if (n3 != -1 && n3 < n2) {
                    n2 = n3;
                }
            }
        }
        return n2;
    }

    private void _clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new ListDataItem[0];
        }
        this._defaultData = null;
        this._listModel = null;
        this._matchingDataList = null;
    }

    private void fillMatchingData(String string) {
        ListDataItemListModel listDataItemListModel = this._buildListModel();
        this._matchingDataList = listDataItemListModel.getMatchingData(string);
    }

    private void _setDefault(String string) {
        this._defaultData = null;
        if (this._insightDataList.length == 0 || string == null) {
            return;
        }
        int n = this._insightDataList.length;
        int n2 = string.length();
        String string2 = string.toLowerCase();
        int n3 = n2;
        while (n3 > 0) {
            String string3 = string.substring(0, n3);
            ListDataItem listDataItem = null;
            int n4 = 0;
            while (n4 < n) {
                ListDataItem listDataItem2 = this._insightDataList[n4];
                String string4 = listDataItem2.getName();
                if (string4.startsWith(string3)) {
                    this._defaultData = listDataItem2;
                    return;
                }
                if (listDataItem == null && string4.toLowerCase().startsWith(string2)) {
                    listDataItem = listDataItem2;
                }
                ++n4;
            }
            if (listDataItem != null) {
                this._defaultData = listDataItem;
                return;
            }
            --n3;
        }
    }

    protected XMLCompletionInsightProvider getProvider() {
        return this._insight;
    }

    protected InsightLocation getInsightLocation() {
        return this._insightLocation;
    }

    private ListDataItemListModel _buildListModel() {
        if (this._listModel == null) {
            this._listModel = new ListDataItemListModel(this._insightDataList);
        }
        return this._listModel;
    }

    void $init$() {
        this._defaultData = null;
        this._attrLocator = null;
    }

    public ValueInsightData() {
        this.$init$();
    }
}

