/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.AbstractXMLInsightProvider;
import oracle.bali.xml.editor.insight.AttributeInsightData;
import oracle.bali.xml.editor.insight.ElementEndTagInsightData;
import oracle.bali.xml.editor.insight.ElementInsightData;
import oracle.bali.xml.editor.insight.EnumerationValueInsightData;
import oracle.bali.xml.editor.insight.TextInsightData;
import oracle.bali.xml.editor.insight.ValueInsightData;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.data.AttributeItem;
import oracle.bali.xml.editor.insight.data.AttributeValueItemItem;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.parser.InsightParser;
import oracle.bali.xml.editor.insight.tooltip.XMLTooltipInsightProvider;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlUsage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightView;

public class XMLCompletionInsightProvider
extends AbstractXMLInsightProvider {
    private static final int FEEDBACK_MESSAGE_DELAY = 5000;
    private static final String RESOURCE_KEY_NO_INSIGHT = "XMLEDITOR.INSIGHT.NO_INSIGHT";
    private String _feedBackString = XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.NO_INSIGHT");
    private ValueInsightData _valueInsight;
    private XMLTooltipInsightProvider _tooltipProvider;
    private EnumerationValueInsightData _enumerationValueInsight;

    public XMLCompletionInsightProvider(XmlContext xmlContext, ParserConfiguration parserConfiguration) {
        super(xmlContext, parserConfiguration);
    }

    public void setValueInsightData(ValueInsightData valueInsightData) {
        this._valueInsight = valueInsightData;
    }

    public ValueInsightData getValueInsightData() {
        return this._valueInsight;
    }

    public void setXMLTooltipInsightProvider(XMLTooltipInsightProvider xMLTooltipInsightProvider) {
        this._tooltipProvider = xMLTooltipInsightProvider;
    }

    public XMLTooltipInsightProvider getXMLTooltipInsightProvider() {
        return this._tooltipProvider;
    }

    public int getInsightType() {
        return 1;
    }

    public void showInsight(boolean bl) {
        super.showInsight(false);
    }

    protected boolean isExactMatchSupported(InsightData insightData) {
        return insightData != null && insightData instanceof ElementEndTagInsightData;
    }

    public boolean isInsightTriggerChar(char c) {
        if (c == '<' || c == ':' || c == ' ') {
            return true;
        }
        if (c == '/') {
            return true;
        }
        return c == '\"';
    }

    public InsightView getInsightView() {
        return new ListInsightView((ListCellRenderer)((Object)new Renderer(null)));
    }

    public final InsightData getInsightData(BasicEditorPane basicEditorPane) {
        Object[] objectArray;
        int n;
        InsightParser insightParser = this.getInsightParser();
        InsightLocation insightLocation = insightParser.determineInsightLocation(this.getTextBuffer(), this.getCaretPosition());
        InsightData insightData = this.getInsightDataImpl(basicEditorPane, insightLocation, n = this.getContextType(insightLocation));
        if (insightData != null && (objectArray = insightData.getData()).length == 0) {
            insightData = null;
        }
        if (insightData == null) {
            if (n == 5 && this._tooltipProvider != null) {
                this._tooltipProvider.showInsight();
            } else {
                this.showFeedback(this._feedBackString, 5000);
            }
        } else {
            this.hideFeedback();
        }
        return insightData;
    }

    public final InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
        InsightParser insightParser = this.getInsightParser();
        InsightLocation insightLocation = insightParser.determineInsightLocation(this.getTextBuffer(), this.getCaretPosition());
        int n = this.getContextType(insightLocation);
        return this.updateInsightDataImpl(basicEditorPane, insightData, insightLocation, n);
    }

    protected InsightData getInsightDataImpl(BasicEditorPane basicEditorPane, InsightLocation insightLocation, int n) {
        XMLInsightData xMLInsightData = null;
        switch (n) {
            case 1: {
                xMLInsightData = new ElementInsightData(this, insightLocation, false);
                break;
            }
            case 2: {
                xMLInsightData = new ElementInsightData(this, insightLocation, true);
                break;
            }
            case 3: {
                xMLInsightData = new AttributeInsightData(this, insightLocation, false, this.supportsAttributeNamespaceInsight());
                break;
            }
            case 4: {
                xMLInsightData = new AttributeInsightData(this, insightLocation, true, this.supportsAttributeNamespaceInsight());
                break;
            }
            case 5: {
                xMLInsightData = this._getAttributeValueInsightData(insightLocation);
                break;
            }
            case 6: {
                xMLInsightData = new ElementEndTagInsightData(this, insightLocation);
                break;
            }
            case 7: {
                xMLInsightData = new TextInsightData(this, insightLocation);
                break;
            }
        }
        return xMLInsightData;
    }

    protected InsightData updateInsightDataImpl(BasicEditorPane basicEditorPane, InsightData insightData, InsightLocation insightLocation, int n) {
        if (insightData instanceof XMLInsightData) {
            XMLInsightData xMLInsightData = (XMLInsightData)insightData;
            switch (n) {
                case 1: {
                    if (xMLInsightData instanceof ElementInsightData && !((ElementInsightData)xMLInsightData).inLocalNameMode()) {
                        xMLInsightData.updateData();
                        break;
                    }
                    xMLInsightData = new ElementInsightData(this, insightLocation, false);
                    break;
                }
                case 2: {
                    if (xMLInsightData instanceof ElementInsightData && ((ElementInsightData)xMLInsightData).inLocalNameMode()) {
                        xMLInsightData.updateData();
                        break;
                    }
                    xMLInsightData = new ElementInsightData(this, insightLocation, true);
                    break;
                }
                case 3: {
                    if (xMLInsightData instanceof AttributeInsightData && !((AttributeInsightData)xMLInsightData).inLocalNameMode()) {
                        xMLInsightData.updateData();
                        break;
                    }
                    xMLInsightData = new AttributeInsightData(this, insightLocation, false, this.supportsAttributeNamespaceInsight());
                    break;
                }
                case 4: {
                    if (xMLInsightData instanceof AttributeInsightData && ((AttributeInsightData)xMLInsightData).inLocalNameMode()) {
                        xMLInsightData.updateData();
                        break;
                    }
                    xMLInsightData = new AttributeInsightData(this, insightLocation, true, this.supportsAttributeNamespaceInsight());
                    break;
                }
                case 5: {
                    if (xMLInsightData instanceof ValueInsightData) {
                        xMLInsightData.updateData();
                        break;
                    }
                    xMLInsightData = this._getAttributeValueInsightData(insightLocation);
                    break;
                }
                case 6: {
                    if (xMLInsightData instanceof ElementEndTagInsightData) {
                        xMLInsightData.updateData();
                        break;
                    }
                    xMLInsightData = new ElementEndTagInsightData(this, insightLocation);
                    break;
                }
                case 7: {
                    if (xMLInsightData instanceof TextInsightData) {
                        TextInsightData textInsightData = (TextInsightData)xMLInsightData;
                        textInsightData.updateInsightLocation(insightLocation);
                        textInsightData.updateData();
                        break;
                    }
                    xMLInsightData = new TextInsightData(this, insightLocation);
                    break;
                }
                default: {
                    xMLInsightData = null;
                }
            }
            return xMLInsightData;
        }
        return insightData;
    }

    protected boolean supportsAttributeNamespaceInsight() {
        return true;
    }

    protected ValueInsightData getDefaultValueInsightData(InsightLocation insightLocation) {
        if (this._enumerationValueInsight == null) {
            this._enumerationValueInsight = new EnumerationValueInsightData();
        }
        return this._enumerationValueInsight;
    }

    private ValueInsightData _getAttributeValueInsightData(InsightLocation insightLocation) {
        ValueInsightData valueInsightData;
        ValueInsightData valueInsightData2 = this.getValueInsightData();
        if (valueInsightData2 != null) {
            valueInsightData2.initialize(this, insightLocation);
            Object[] objectArray = valueInsightData2.getData();
            if (objectArray.length == 0) {
                valueInsightData2 = null;
            }
        }
        if (valueInsightData2 == null && (valueInsightData = this.getDefaultValueInsightData(insightLocation)) != null) {
            valueInsightData.initialize(this, insightLocation);
            valueInsightData2 = valueInsightData;
        }
        return valueInsightData2;
    }

    private class Renderer
    extends ListDataItemCellRenderer {
        private boolean _required;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof AttributeValueItemItem) {
                AttributeValueItemItem attributeValueItemItem = (AttributeValueItemItem)((Object)object);
                GuiXmlContext guiXmlContext = (GuiXmlContext)XMLCompletionInsightProvider.this.getXmlContext();
                BaseInspectorGui baseInspectorGui = (BaseInspectorGui)guiXmlContext.getGui(XmlUsage.PROPERTY_INSPECTOR);
                ListCellRenderer listCellRenderer = baseInspectorGui.getCustomListCellRenderer(attributeValueItemItem.getAttribute(), attributeValueItemItem.getItem());
                if (listCellRenderer != null) {
                    return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
                }
            }
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this._required = false;
            Font font = component.getFont();
            if (font == null) {
                font = jList.getFont();
            }
            if (object instanceof AttributeItem && ((AttributeItem)((Object)object)).isRequired()) {
                this._required = true;
                if (!font.isBold()) {
                    font = font.deriveFont(1);
                }
            }
            component.setFont(font);
            return component;
        }

        public Dimension getPreferredSize() {
            Font font;
            if (this._required && (font = this.getFont()) != null && !font.isBold()) {
                Font font2 = font.deriveFont(1);
                this.setFont(font2);
                Dimension dimension = super.getPreferredSize();
                this.setFont(font);
                return dimension;
            }
            return super.getPreferredSize();
        }

        public Object getPrototypeCell(JList jList, ListModel listModel) {
            ListDataItem listDataItem = null;
            int n = 0;
            Font font = jList.getFont();
            FontMetrics fontMetrics = jList.getFontMetrics(font);
            Font font2 = null;
            FontMetrics fontMetrics2 = null;
            int n2 = listModel.getSize();
            int n3 = 0;
            while (n3 < n2) {
                AttributeItem attributeItem;
                FontMetrics fontMetrics3 = fontMetrics;
                ListDataItem listDataItem2 = (ListDataItem)listModel.getElementAt(n3);
                if (listDataItem2 instanceof AttributeItem && (attributeItem = (AttributeItem)listDataItem2).isRequired()) {
                    if (fontMetrics2 == null) {
                        font2 = font.deriveFont(1);
                        fontMetrics2 = jList.getFontMetrics(font2);
                    }
                    fontMetrics3 = fontMetrics2;
                }
                int n4 = fontMetrics3.stringWidth(listDataItem2.getDisplayText());
                Icon icon = listDataItem2.getIcon();
                if (icon != null) {
                    n4 = n4 + this.getIconTextGap() + icon.getIconWidth();
                }
                if (n4 > n) {
                    n = n4;
                    listDataItem = listDataItem2;
                }
                ++n3;
            }
            return listDataItem;
        }

        private Renderer() {
        }

        Renderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

