/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight.parser;

import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.insight.parser.DocumentTypeInfo;
import oracle.bali.xml.editor.insight.parser.TextInfo;
import oracle.javatools.buffer.TextBuffer;

public class InsightLocation {
    private List _elementDecls;
    private NamespaceDeclarations _namespaceDecls;
    private TextBuffer _buffer;
    private LocatorManager _manager;
    private int _caretPosition;
    private DocumentTypeInfo _doctype;
    private TextInfo _textInfo;

    public InsightLocation(TextBuffer textBuffer, int n) {
        this.$init$();
        this._buffer = textBuffer;
        this._caretPosition = n;
        this._manager = new LocatorManager(textBuffer.getLineMap());
        this._elementDecls = new ArrayList();
        this._namespaceDecls = new NamespaceDeclarations();
    }

    public List getElementDeclarations() {
        return this._elementDecls;
    }

    public void append(ElementDeclaration elementDeclaration) {
        this._elementDecls.add(elementDeclaration);
    }

    public void remove(ResolvedName resolvedName) {
        int n = this._elementDecls.size() - 1;
        while (n >= 0) {
            ElementDeclaration elementDeclaration = (ElementDeclaration)this._elementDecls.get(n);
            ResolvedName resolvedName2 = elementDeclaration.getResolvedName();
            if (resolvedName2 != null && resolvedName2.matches(resolvedName)) {
                this._elementDecls.remove(n);
                break;
            }
            --n;
        }
    }

    public NamespaceDeclarations getNamespaceDeclarations() {
        return this._namespaceDecls;
    }

    public TextBuffer getTextBuffer() {
        return this._buffer;
    }

    public int getCaretPosition() {
        return this._caretPosition;
    }

    public LocatorManager getLocatorManager() {
        return this._manager;
    }

    public void setDocumentType(DocumentTypeInfo documentTypeInfo) {
        this._doctype = documentTypeInfo;
    }

    public DocumentTypeInfo getDocumentType() {
        return this._doctype;
    }

    public void setCurrentTextInfo(TextInfo textInfo) {
        this._textInfo = textInfo;
    }

    public TextInfo getCurrentTextInfo() {
        return this._textInfo;
    }

    void $init$() {
        this._elementDecls = null;
        this._namespaceDecls = null;
        this._buffer = null;
        this._manager = null;
        this._caretPosition = -1;
        this._doctype = null;
        this._textInfo = null;
    }
}

