/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight.parser;

import java.util.Collections;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.DocumentHandler;
import oracle.bali.xml.dom.buffer.parser.DocumentScanner;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.insight.parser.DocumentTypeInfo;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.parser.TextInfo;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;

public class InsightParser
implements DocumentHandler {
    private ParserConfiguration _parserConfiguration;
    private InsightLocation _insightLocation;
    private int _caretPosition;

    public InsightParser(ParserConfiguration parserConfiguration) {
        this.$init$();
        this._parserConfiguration = parserConfiguration;
    }

    public InsightLocation determineInsightLocation(TextBuffer textBuffer, int n) {
        this._caretPosition = n;
        this._insightLocation = new InsightLocation(textBuffer, n);
        DocumentScanner documentScanner = this._parserConfiguration.createDocumentScanner();
        documentScanner.setReuseAttributeDeclarations(false);
        documentScanner.scanDocument((ReadTextBuffer)textBuffer, this, this._insightLocation.getLocatorManager(), this._insightLocation.getNamespaceDeclarations(), n);
        return this._insightLocation;
    }

    public void handleStartElement(ResolvedName resolvedName, AttributeDeclarations attributeDeclarations, ElementLocator elementLocator) {
        if (this._caretPosition > elementLocator.getStartOffset()) {
            ElementDeclaration elementDeclaration = new ElementDeclaration(attributeDeclarations);
            elementDeclaration.setResolvedName(resolvedName);
            elementDeclaration.setElementLocator(elementLocator);
            elementDeclaration.setStartTag(true);
            elementDeclaration.setEndTag(false);
            this._insightLocation.append(elementDeclaration);
        }
        this._considerAddingFakeTextInfo(elementLocator, elementLocator.isStartTagComplete());
    }

    public void handleEmptyElement(ResolvedName resolvedName, AttributeDeclarations attributeDeclarations, ElementLocator elementLocator) {
        if (this._caretInsideElement(elementLocator, elementLocator.isStartTagComplete())) {
            ElementDeclaration elementDeclaration = new ElementDeclaration(attributeDeclarations);
            elementDeclaration.setResolvedName(resolvedName);
            elementDeclaration.setElementLocator(elementLocator);
            elementDeclaration.setStartTag(true);
            elementDeclaration.setEndTag(true);
            this._insightLocation.append(elementDeclaration);
        }
        this._considerAddingFakeTextInfo(elementLocator, elementLocator.isStartTagComplete());
    }

    public void handleEndElement(ResolvedName resolvedName, SimpleLocator simpleLocator, boolean bl) {
        if (this._caretPosition > simpleLocator.getStartOffset()) {
            if (this._caretInsideElement(simpleLocator, bl)) {
                ElementDeclaration elementDeclaration = new ElementDeclaration();
                elementDeclaration.setResolvedName(resolvedName);
                ElementLocator elementLocator = this._insightLocation.getLocatorManager().createElementLocator(simpleLocator);
                elementLocator.setStartTagComplete(bl);
                elementDeclaration.setElementLocator(elementLocator);
                elementDeclaration.setStartTag(false);
                elementDeclaration.setEndTag(true);
                this._insightLocation.append(elementDeclaration);
            } else {
                this._insightLocation.remove(resolvedName);
            }
        }
        this._considerAddingFakeTextInfo(simpleLocator, bl);
    }

    public void handleText(String string, TextLocator textLocator) {
        if (this._caretPosition >= textLocator.getStartOffset() && this._caretPosition <= textLocator.getEndOffset()) {
            TextInfo textInfo = new TextInfo(string, textLocator);
            this._insightLocation.setCurrentTextInfo(textInfo);
        }
    }

    public void handleDocumentType(ResolvedName resolvedName, String string, String string2, SimpleLocator simpleLocator) {
        if (this._insightLocation.getDocumentType() == null) {
            DocumentTypeInfo documentTypeInfo = new DocumentTypeInfo(resolvedName, string, string2, simpleLocator);
            this._insightLocation.setDocumentType(documentTypeInfo);
        }
    }

    public void handleCDATASection(String string, SimpleLocator simpleLocator) {
        this._considerAddingFakeTextInfo(simpleLocator, true);
    }

    public void handleProcessingInstruction(String string, String string2, SimpleLocator simpleLocator) {
        this._considerAddingFakeTextInfo(simpleLocator, true);
    }

    public void handleXMLDeclaration(String string, String string2, String string3, DeclarationLocator declarationLocator) {
    }

    public void handleComment(String string, SimpleLocator simpleLocator) {
        this._considerAddingFakeTextInfo(simpleLocator, true);
    }

    private boolean _caretInsideElement(Locator locator, boolean bl) {
        if (this._caretPosition > locator.getStartOffset()) {
            int n = locator.getEndOffset();
            if (bl ? this._caretPosition < n : this._caretPosition <= n) {
                return true;
            }
        }
        return false;
    }

    private void _considerAddingFakeTextInfo(Locator locator, boolean bl) {
        if (bl && locator.getEndOffset() == this._caretPosition && this._insightLocation.getElementDeclarations().size() > 0) {
            LocatorManager locatorManager = this._insightLocation.getLocatorManager();
            SimpleLocator simpleLocator = locatorManager.createSimpleLocator(this._caretPosition, this._caretPosition);
            TextLocator textLocator = locatorManager.createTextLocator(Collections.singletonList(simpleLocator));
            TextInfo textInfo = new TextInfo("", textLocator);
            this._insightLocation.setCurrentTextInfo(textInfo);
        }
    }

    void $init$() {
        this._parserConfiguration = null;
        this._insightLocation = null;
        this._caretPosition = -1;
    }
}

