/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight.tooltip;

import java.util.List;
import javax.swing.ListModel;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.tooltip.XMLTooltipInsightData;
import oracle.bali.xml.editor.insight.tooltip.XMLTooltipInsightProvider;
import oracle.bali.xml.editor.insight.tooltip.data.ValueTypeTooltipDataItem;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.SimpleType;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.editor.insight.TooltipDataItemListModel;

public class ValueTypeTooltipInsightData
extends XMLTooltipInsightData {
    private XMLTooltipInsightProvider _insight;
    private TooltipDataItemListModel _listModel;
    private InsightLocation _insightLocation;
    private TooltipDataItem[] _insightDataList;

    protected ValueTypeTooltipInsightData(XMLTooltipInsightProvider xMLTooltipInsightProvider, InsightLocation insightLocation) {
        this._insight = xMLTooltipInsightProvider;
        this._insightLocation = insightLocation;
        this._fillDataList();
    }

    public ListModel getListModel() {
        return this._buildListModel();
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public void updateData() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (textBuffer.getChar(n2) == '=' || textBuffer.getChar(n2) == '\"') break;
            --n2;
        }
        int n3 = ++n2;
        while (n3 < textBuffer.getLength()) {
            if (textBuffer.getChar(n3) == ' ' || textBuffer.getChar(n3) == '\t' || textBuffer.getChar(n3) == '\n' || textBuffer.getChar(n3) == '=' || textBuffer.getChar(n3) == '<' || textBuffer.getChar(n3) == '>' || textBuffer.getChar(n3) == '\"') break;
            ++n3;
        }
        if (n < n2 || n > n3) {
            this._clearData();
            return;
        }
    }

    private void _clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new TooltipDataItem[0];
        }
        this._listModel = null;
    }

    private TooltipDataItemListModel _buildListModel() {
        if (this._listModel == null) {
            this._listModel = new TooltipDataItemListModel(this._insightDataList);
        }
        return this._listModel;
    }

    private void _fillDataList() {
        ValueTypeTooltipDataItem valueTypeTooltipDataItem = null;
        List list = this._insightLocation.getElementDeclarations();
        if (list.size() > 0) {
            int n = this._insight.getCaretPosition();
            int n2 = list.size() - 1;
            ElementDeclaration elementDeclaration = (ElementDeclaration)list.get(n2);
            ResolvedName resolvedName = null;
            AttributeDeclarations attributeDeclarations = elementDeclaration.getAttributeDeclarations();
            int n3 = InsightUtils.getAttributeAtCaretPosition(attributeDeclarations, n);
            if (n3 != -1) {
                resolvedName = attributeDeclarations.getResolvedName(n3);
            }
            if (resolvedName != null) {
                SimpleType simpleType;
                AttributeDef attributeDef;
                ElementDef elementDef;
                String string = resolvedName.getNamespace();
                String string2 = resolvedName.getLocalName();
                if (string2 != null && string2.length() > 0 && (elementDef = InsightUtils.getElementDef(this._insight.getGrammarProvider(), list, n2)) != null && (attributeDef = elementDef.getAttributeDefByName(string, string2)) != null && (simpleType = attributeDef.getType()) != null && simpleType.getName() != null) {
                    valueTypeTooltipDataItem = new ValueTypeTooltipDataItem(simpleType);
                }
            }
        }
        if (valueTypeTooltipDataItem == null) {
            this._insightDataList = new TooltipDataItem[0];
        } else {
            this._insightDataList = new TooltipDataItem[1];
            this._insightDataList[0] = valueTypeTooltipDataItem;
        }
    }
}

