/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight.tooltip;

import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.AbstractXMLInsightProvider;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.parser.InsightParser;
import oracle.bali.xml.editor.insight.tooltip.ValueTypeTooltipInsightData;
import oracle.bali.xml.editor.insight.tooltip.XMLTooltipInsightData;
import oracle.bali.xml.model.XmlContext;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.TooltipInsightView;

public class XMLTooltipInsightProvider
extends AbstractXMLInsightProvider {
    private static final int FEEDBACK_MESSAGE_DELAY = 5000;
    private static final String RESOURCE_KEY_NO_INSIGHT = "XMLEDITOR.INSIGHT.NO_INSIGHT";
    private String _feedBackString = XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.NO_INSIGHT");

    public XMLTooltipInsightProvider(XmlContext xmlContext, ParserConfiguration parserConfiguration) {
        super(xmlContext, parserConfiguration);
    }

    public int getInsightType() {
        return 2;
    }

    public boolean isInsightTriggerChar(char c) {
        return false;
    }

    public InsightData getInsightData(BasicEditorPane basicEditorPane) {
        Object[] objectArray;
        ValueTypeTooltipInsightData valueTypeTooltipInsightData = null;
        InsightParser insightParser = this.getInsightParser();
        InsightLocation insightLocation = insightParser.determineInsightLocation(this.getTextBuffer(), this.getCaretPosition());
        int n = this.getContextType(insightLocation);
        if (n == 5) {
            valueTypeTooltipInsightData = new ValueTypeTooltipInsightData(this, insightLocation);
        }
        if (valueTypeTooltipInsightData != null && (objectArray = valueTypeTooltipInsightData.getData()).length == 0) {
            valueTypeTooltipInsightData = null;
        }
        if (valueTypeTooltipInsightData == null) {
            this.showFeedback(this._feedBackString, 5000);
        } else {
            this.hideFeedback();
        }
        return valueTypeTooltipInsightData;
    }

    public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
        if (insightData instanceof XMLTooltipInsightData) {
            XMLTooltipInsightData xMLTooltipInsightData = (XMLTooltipInsightData)insightData;
            InsightParser insightParser = this.getInsightParser();
            InsightLocation insightLocation = insightParser.determineInsightLocation(this.getTextBuffer(), this.getCaretPosition());
            int n = this.getContextType(insightLocation);
            if (n == 5) {
                xMLTooltipInsightData.updateData();
            } else {
                insightData = null;
            }
        }
        return insightData;
    }

    public InsightView getInsightView() {
        return new TooltipInsightView();
    }
}

