/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.plugins;

import java.beans.PropertyChangeEvent;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.plugins.EditorPlugin;

public class AutomaticEndTagProvider
implements EditorPlugin,
CharacterTypedListener {
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR"));

    public void install(BasicEditorPane basicEditorPane) {
        basicEditorPane.addCharacterTypedListener((CharacterTypedListener)this);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        basicEditorPane.removeCharacterTypedListener((CharacterTypedListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void characterTyped(BasicEditorPane basicEditorPane, int n, char c) {
        if (c == '>') {
            this._checkForEndTagInsertion(basicEditorPane, n, c);
        }
    }

    private void _checkForEndTagInsertion(BasicEditorPane basicEditorPane, int n, char c) {
        boolean bl = false;
        try {
            bl = EditorProperties.getProperties().getBooleanProperty("XMLLanguageModule.END_TAG");
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            TextBuffer textBuffer = basicDocument.getTextBuffer();
            String string = null;
            try {
                if (n > 0) {
                    String string2;
                    int n2;
                    int n3 = 80;
                    if (n < n3) {
                        n3 = n;
                    }
                    if ((n2 = (string2 = basicDocument.getText(n - n3, n3)).lastIndexOf(60)) != -1 && (string2 = string2.substring(n2 + 1)).charAt(0) != '-' && string2.charAt(0) != '!' && string2.charAt(0) != '?' && string2.indexOf(62) == -1 && string2.indexOf(47) == -1) {
                        int n4 = string2.indexOf(32);
                        if (n4 == -1) {
                            n4 = string2.length();
                        }
                        if ((string2 = string2.substring(0, n4)) != null && string2.length() > 0) {
                            string = "</" + string2 + ">";
                        }
                    }
                }
            }
            catch (Exception exception) {
                string = null;
            }
            if (string != null) {
                basicEditorPane.beginEdit(EDIT_DESCRIPTOR);
                try {
                    try {
                        basicDocument.insertString(n + 1, string, null);
                        basicEditorPane.setCaretPosition(n + 1);
                    }
                    catch (BadLocationException badLocationException) {
                        System.err.println("Exception occurred in completion: " + badLocationException);
                        badLocationException.printStackTrace();
                    }
                }
                finally {
                    basicEditorPane.endEdit();
                }
            }
        }
    }
}

