/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Action;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.ServiceProvider;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.task.StandardTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.util.DomPositionMapper;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.TreeWalker;

public abstract class AbstractModel
implements ServiceProvider {
    public static final String DOM_DOCUMENT_CHANGED_PROPERTY = "documentChanged";
    public static final String DROP_LOCATION_PROPERTY = "dropLocation";
    public static final String CURSOR_LOCATION_PROPERTY = "cursorLocation";
    public static final String RANGE_SELECTION_PROPERTY = "rangeSelection";
    public static final String SELECTION_CLEARED_PROPERTY = "selectionCleared";
    public static final String READONLY_PROPERTY = "readOnly";
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Logger _LOGGER;
    private final XmlModelEvent _emptyEvent = new XmlModelEvent(this);

    static {
        $assertionsDisabled = AbstractModel.class.desiredAssertionStatus() ^ true;
        _LOGGER = Logger.getLogger("oracle.bali.xml.model");
    }

    AbstractModel() {
        this._emptyEvent.prepareForDelivery();
    }

    public abstract XmlModel getBaseModel();

    public abstract DomModel getDomModel();

    public abstract XmlContext getContext();

    public abstract Object getService(Object var1);

    public abstract void startTransaction(String var1);

    public abstract boolean commitTransaction() throws XmlCommitException;

    public abstract void rollbackTransaction();

    public abstract void addModelListener(XmlModelListener var1);

    public abstract void removeModelListener(XmlModelListener var1);

    public abstract boolean isDeliveringEvents();

    public abstract Selection getSelection();

    public abstract String getTranslatedString(String var1);

    public final String getTranslatedString(String string, Object[] objectArray) {
        return FastMessageFormat.formatMessage(this.getTranslatedString(string), objectArray);
    }

    public final String getTranslatedString(String string, String string2) {
        return FastMessageFormat.formatMessage(this.getTranslatedString(string), string2);
    }

    public abstract Action getAction(String var1);

    public abstract Document getDocument();

    public abstract TreeWalker createTreeWalker();

    public abstract TreeTraversal getTreeTraversal();

    public abstract XmlMetadataResolver getXmlMetadataResolver();

    public abstract XmlKey getNodeXmlKey(Node var1);

    public final DomPosition remapPosition(DomPosition domPosition) {
        Node node;
        if (domPosition != null && (node = this.remapNode(domPosition.getTargetNode())) != null) {
            return domPosition.createDomPosition(node);
        }
        return null;
    }

    public final Node remapNode(Node node) {
        List list;
        if (node != null && !(list = DomUtils.getNodePath((TreeTraversal)this.getTreeTraversal(), (Node)node, null)).isEmpty()) {
            return this.remapNode(list);
        }
        return null;
    }

    public final boolean isInModelDocumentHierarchy(Node node) {
        if (node == null || DomUtils.getOwnerDocument((Node)node) != this.getDocument()) {
            return false;
        }
        if (DomUtils.isAttribute((Node)node)) {
            node = ((Attr)node).getOwnerElement();
        }
        return DomUtils.isInDocumentHierarchy((TreeTraversal)this.getTreeTraversal(), (Node)node);
    }

    public final boolean isInModelDocumentHierarchy(DomPosition domPosition) {
        if (domPosition == null) {
            return false;
        }
        return this.isInModelDocumentHierarchy(domPosition.getTargetNode());
    }

    public abstract DomPosition convertInsertionPosition(DomPosition var1);

    public abstract Node remapNode(List var1);

    public abstract Collection deleteNodes(String var1, Collection var2, boolean var3) throws XmlCommitException;

    public abstract Collection deleteNodes(String var1, DomRange var2, boolean var3) throws XmlCommitException;

    public abstract Collection insertNodes(DomPosition var1, String var2, Collection var3, boolean var4) throws XmlCommitException;

    public abstract boolean isReadOnly();

    public abstract Transferable createTransferable();

    public boolean requiresValidModel() {
        return false;
    }

    public final Logger getLogger() {
        return _LOGGER;
    }

    public final Node insertXmlKey(XmlKey xmlKey, DomPosition domPosition) throws XmlCommitException {
        if (xmlKey != null && domPosition != null) {
            Node[] nodeArray = new Node[1];
            new 1(this, xmlKey, domPosition, nodeArray).runThrowingXCE(this);
            return nodeArray[0];
        }
        return null;
    }

    public final Node insertNode(Node node, DomPosition domPosition) throws XmlCommitException {
        return this.insertNode(node, domPosition, true);
    }

    public final Node insertNode(Node node, DomPosition domPosition, boolean bl) throws XmlCommitException {
        String string;
        this.acquireReadLock();
        try {
            string = FastMessageFormat.formatMessage(this.getTranslatedString("INSERT_NODE_DESCRIPTION_FORMAT"), this.getXmlMetadataResolver().getMediumDisplayName(node));
        }
        finally {
            this.releaseReadLock();
        }
        Collection collection = this.insertNodes(domPosition, string, Collections.singleton(node), bl);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return (Node)collection.iterator().next();
    }

    public final void insertIntoTextNode(CharacterData characterData, int n, String string) {
        this.__verifyWriteLock();
        if (!this.isInModelDocumentHierarchy(characterData)) {
            throw new IllegalArgumentException("node null or not in hierarchy: " + characterData);
        }
        if (string == null) {
            throw new IllegalArgumentException("null data");
        }
        String string2 = characterData.getNodeValue();
        int n2 = string2.length();
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("offset out of bounds");
        }
        MapperForInsertOrDeleteFromText mapperForInsertOrDeleteFromText = new MapperForInsertOrDeleteFromText(characterData, n, string.length());
        characterData.setNodeValue(this._insertIntoString(string2, n, string));
        mapperForInsertOrDeleteFromText.applyMappings();
    }

    public final void deleteFromTextNode(CharacterData characterData, int n, int n2) {
        this.__verifyWriteLock();
        if (!this.isInModelDocumentHierarchy(characterData)) {
            throw new IllegalArgumentException("node null or not in hierarchy");
        }
        String string = characterData.getNodeValue();
        int n3 = string.length();
        if (n < 0 || n2 <= 0 || n + n2 > n3 || n2 >= n3) {
            throw new IllegalArgumentException("offset/length out of bounds");
        }
        MapperForInsertOrDeleteFromText mapperForInsertOrDeleteFromText = new MapperForInsertOrDeleteFromText(characterData, n, -n2);
        characterData.setNodeValue(this._deleteFromString(string, n, n2));
        mapperForInsertOrDeleteFromText.applyMappings();
    }

    public final void mergeTextNodes(Text text, Text text2) {
        if (text == null || text2 == null) {
            throw new IllegalArgumentException("one node was null");
        }
        this.__verifyWriteLock();
        TreeTraversal treeTraversal = this.getTreeTraversal();
        if (treeTraversal.getNextSibling((Node)text) != text2) {
            if (treeTraversal.getPreviousSibling((Node)text) == text2) {
                Text text3 = text;
                text = text2;
                text2 = text3;
            } else {
                throw new IllegalArgumentException("nodes must be siblings!");
            }
        }
        this.mergeTextNodesImpl(text, text2);
    }

    public final Text splitTextNode(Text text, int n) {
        if (text == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.__verifyWriteLock();
        int n2 = text.getLength();
        if (n <= 0 || n >= n2) {
            return null;
        }
        return this.splitTextNodeImpl(text, n);
    }

    public final DomPosition splitAtPositionIfNeeded(DomPosition domPosition, boolean bl) {
        Node node;
        this.__verifyWriteLock();
        if (domPosition.hasTextOffset() && DomUtils.isText((Node)(node = domPosition.getTargetNode()))) {
            int n = domPosition.getTextOffset();
            Text text = (Text)node;
            if (n == 0) {
                return DomPositionFactory.before((Node)text);
            }
            if (n == text.getLength()) {
                return DomPositionFactory.after((Node)text);
            }
            Text text2 = this.splitTextNode(text, n);
            if (text2 != null) {
                if (bl) {
                    return DomPositionFactory.after((Node)node);
                }
                return DomPositionFactory.before((Node)text2);
            }
        }
        return domPosition;
    }

    protected Collection getNodesForDeletion(DomRange domRange, boolean bl) {
        this.__verifyWriteLock();
        TreeTraversal treeTraversal = this.getTreeTraversal();
        DomPosition domPosition = this.splitAtPositionIfNeeded(domRange.getEnd(), false);
        DomPosition domPosition2 = this.splitAtPositionIfNeeded(domRange.getStart(), true);
        if (bl) {
            DomPosition domPosition3 = null;
            if (domPosition2 != domRange.getStart()) {
                domPosition3 = domPosition2;
            } else if (domPosition != domRange.getEnd()) {
                domPosition3 = domPosition;
            } else if (domPosition2.isBefore()) {
                if (domPosition.isBefore()) {
                    domPosition3 = domPosition;
                } else {
                    Node node = domPosition2.getTargetNode();
                    Node node2 = treeTraversal.getPreviousSibling(node);
                    if (node2 != null) {
                        domPosition3 = DomPositionFactory.after((Node)node2);
                    } else {
                        Node node3 = treeTraversal.getNextSibling(domPosition.getTargetNode());
                        if (node3 != null) {
                            domPosition3 = DomPositionFactory.before((Node)node3);
                        } else {
                            Node node4 = treeTraversal.getParentNode(node);
                            if (node4 != null) {
                                domPosition3 = DomPositionFactory.inside((Node)node4);
                            }
                        }
                    }
                }
            } else {
                domPosition3 = domPosition2;
            }
            Selection selection = this.getSelection();
            if (domPosition3 == null) {
                selection.clear();
                selection.setCursorLocation(null);
            } else {
                domPosition3 = this.getTextPositionIfPossible(domPosition3);
                selection.setCursorLocation(domPosition3);
                selection.setRangeSelection(DomRange.create((DomPosition)domPosition3, (DomPosition)domPosition3, (TreeTraversal)treeTraversal));
            }
        }
        if (domPosition2 != domRange.getStart() || domPosition != domRange.getEnd()) {
            domRange = DomRange.create((DomPosition)domPosition2, (DomPosition)domPosition, (TreeTraversal)treeTraversal);
        }
        return domRange.getNodesEntirelyInRange(treeTraversal);
    }

    protected void selectInsertedNodes(Collection collection) {
        this.__verifyWriteLock();
        if (collection != null) {
            if (collection.isEmpty()) {
                this.getSelection().clear();
            } else {
                this.getSelection().set(collection);
                Node node = (Node)collection.iterator().next();
                this.getSelection().setCursorLocation(DomPositionFactory.createInsideOrAfterPosition((Node)node));
            }
        }
    }

    protected abstract Text splitTextNodeImpl(Text var1, int var2);

    protected abstract void mergeTextNodesImpl(Text var1, Text var2);

    public abstract void acquireReadLock();

    public abstract void releaseReadLock();

    abstract void __acquireWriteLock();

    abstract void __releaseWriteLock();

    abstract void __verifyLock();

    abstract void __verifyWriteLock();

    protected final DomPosition getTextPositionIfPossible(DomPosition domPosition) {
        Node node;
        this.__verifyLock();
        if (domPosition.hasTextOffset()) {
            return domPosition;
        }
        Node node2 = domPosition.getTargetNode();
        if (DomUtils.isText((Node)node2)) {
            Text text = (Text)node2;
            if (domPosition.isBefore()) {
                return DomPositionFactory.createTextPosition((CharacterData)text, (int)0);
            }
            if (!$assertionsDisabled && !domPosition.isAfter()) {
                throw new AssertionError();
            }
            return DomPositionFactory.createTextPosition((CharacterData)text, (int)text.getLength());
        }
        if (domPosition.isBefore()) {
            Node node3 = node2.getPreviousSibling();
            if (DomUtils.isText((Node)node3)) {
                Text text = (Text)node3;
                return DomPositionFactory.createTextPosition((CharacterData)text, (int)text.getLength());
            }
        } else if (domPosition.isAfter() && DomUtils.isText((Node)(node = node2.getNextSibling()))) {
            Text text = (Text)node;
            return DomPositionFactory.createTextPosition((CharacterData)text, (int)0);
        }
        return domPosition;
    }

    protected final void deliverInvalidateEvent(XmlModelEvent xmlModelEvent, Iterator iterator) {
        xmlModelEvent.prepareForDelivery();
        this._deliverEventUnderReadLock(xmlModelEvent, iterator, true);
    }

    protected final void deliverNoChangeEvent(Iterator iterator) {
        this._deliverEventUnderReadLock(this._emptyEvent, iterator, false);
    }

    /*
     * Exception decompiling
     */
    private void _deliverEventUnderReadLock(XmlModelEvent var1_1, Iterator var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final XmlModelEvent createEvent(boolean bl) {
        this.acquireReadLock();
        try {
            int n;
            Document document;
            Set set = this.getSelection().getSelectedNodeSet();
            Set set2 = null;
            Set set3 = null;
            if (bl) {
                document = this.getDocument();
                n = 1;
                set2 = set;
            } else {
                document = null;
                n = 2;
                set3 = set;
            }
            HashMap hashMap = new HashMap(11);
            this.addCurrentPropertiesToEvent(hashMap, bl);
            XmlModelEvent xmlModelEvent = new XmlModelEvent(this, document, n, hashMap, set2, set3, null, NodeChangeDetails.NO_DETAILS_AVAILABLE);
            this.releaseReadLock();
            return xmlModelEvent;
        }
        catch (Throwable throwable) {
            this.releaseReadLock();
            throw throwable;
        }
    }

    protected void addCurrentPropertiesToEvent(Map map, boolean bl) {
        PropertyChange propertyChange;
        PropertyChange propertyChange2;
        PropertyChange propertyChange3;
        Selection selection = this.getSelection();
        Document document = this.getDocument();
        DomPosition domPosition = selection.getDropLocation();
        DomPosition domPosition2 = selection.getCursorLocation();
        if (bl) {
            propertyChange3 = PropertyChange.getPropertyChange(DOM_DOCUMENT_CHANGED_PROPERTY, null, document);
            propertyChange2 = PropertyChange.getPropertyChange(DROP_LOCATION_PROPERTY, null, domPosition);
            propertyChange = PropertyChange.getPropertyChange(CURSOR_LOCATION_PROPERTY, null, domPosition2);
        } else {
            propertyChange3 = PropertyChange.getPropertyChange(DOM_DOCUMENT_CHANGED_PROPERTY, document, null);
            propertyChange2 = PropertyChange.getPropertyChange(DROP_LOCATION_PROPERTY, domPosition, null);
            propertyChange = PropertyChange.getPropertyChange(CURSOR_LOCATION_PROPERTY, domPosition2, null);
        }
        if (propertyChange3 != null) {
            map.put(DOM_DOCUMENT_CHANGED_PROPERTY, propertyChange3);
        }
        if (propertyChange2 != null) {
            map.put(DROP_LOCATION_PROPERTY, propertyChange2);
        }
        if (propertyChange != null) {
            map.put(CURSOR_LOCATION_PROPERTY, propertyChange);
        }
    }

    private String _deleteFromString(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() - n2);
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(string.substring(n + n2));
        return stringBuffer.toString();
    }

    private String _insertIntoString(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length());
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(string2);
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public final class 1
    extends StandardTransactionTask {
        private final /* synthetic */ XmlKey v$xmlKey;
        private final /* synthetic */ DomPosition v$position;
        private final /* synthetic */ Node[] v$ret;
        final /* synthetic */ AbstractModel this$0;

        protected String computeTransactionName(AbstractModel abstractModel) {
            return abstractModel.getTranslatedString("INSERT_NODE_DESCRIPTION_FORMAT", this.this$0.getXmlMetadataResolver().getShortDisplayName(this.v$xmlKey));
        }

        protected void performTask(AbstractModel abstractModel) throws XmlCommitException {
            Collection collection;
            Node node = XmlModelUtils.createNodeFromKey(abstractModel, this.v$xmlKey, this.v$position);
            if (node != null && (collection = abstractModel.insertNodes(this.v$position, "internal txn", DomUtils.nodeToList((Node)node), true)) != null && !collection.isEmpty()) {
                this.v$ret[0] = collection.contains(node) ? node : (Node)collection.iterator().next();
                return;
            }
            this.cancelTask();
        }

        public 1(AbstractModel abstractModel, XmlKey xmlKey, DomPosition domPosition, Node[] nodeArray) {
            this.v$ret = nodeArray;
            this.v$position = domPosition;
            this.v$xmlKey = xmlKey;
            this.this$0 = abstractModel;
        }
    }

    protected class MapperForMergeTextNodes
    extends DomPositionMapper {
        private final Text _target;
        private final Text _source;
        private final int _targetOldLength;

        public MapperForMergeTextNodes(Text text, Text text2) {
            super(AbstractModel.this);
            this._target = text;
            this._source = text2;
            this._targetOldLength = this._target.getLength();
        }

        protected DomPosition mapPosition(DomPosition domPosition) {
            Node node = domPosition.getTargetNode();
            if (node == this._source) {
                if (domPosition.isBefore()) {
                    return DomPositionFactory.createTextPosition((CharacterData)this._target, (int)this._targetOldLength);
                }
                if (domPosition.isAfter()) {
                    return DomPositionFactory.after((Node)this._target);
                }
                if (domPosition.hasTextOffset()) {
                    return DomPositionFactory.createTextPosition((CharacterData)this._target, (int)(this._targetOldLength + domPosition.getTextOffset()));
                }
            } else if (node == this._target && domPosition.isAfter()) {
                return DomPositionFactory.createTextPosition((CharacterData)this._target, (int)this._targetOldLength);
            }
            return domPosition;
        }
    }

    protected class MapperForSplitTextNode
    extends DomPositionMapper {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final Text _original;
        private Text _created;
        private final int _splitOffset;

        public MapperForSplitTextNode(Text text, int n) {
            super(AbstractModel.this);
            this._original = text;
            this._splitOffset = n;
        }

        public void setCreated(Text text) {
            this._created = text;
        }

        static {
            $assertionsDisabled = MapperForSplitTextNode.class.desiredAssertionStatus() ^ true;
        }

        protected DomPosition mapPosition(DomPosition domPosition) {
            if (!$assertionsDisabled && this._created == null) {
                throw new AssertionError();
            }
            if (domPosition != null && domPosition.getTargetNode() == this._original) {
                int n;
                if (domPosition.isAfter()) {
                    return DomPositionFactory.after((Node)this._created);
                }
                if (domPosition.hasTextOffset() && (n = domPosition.getTextOffset()) > this._splitOffset) {
                    return DomPositionFactory.createTextPosition((CharacterData)this._created, (int)(n - this._splitOffset));
                }
            }
            return domPosition;
        }
    }

    private class MapperForInsertOrDeleteFromText
    extends DomPositionMapper {
        private final CharacterData _node;
        private final int _offset;
        private final int _delta;

        public MapperForInsertOrDeleteFromText(CharacterData characterData, int n, int n2) {
            super(AbstractModel.this);
            this._node = characterData;
            this._offset = n;
            this._delta = n2;
        }

        protected DomPosition mapPosition(DomPosition domPosition) {
            if (this._delta != 0 && domPosition.hasTextOffset() && domPosition.getTargetNode() == this._node) {
                int n = -1;
                int n2 = domPosition.getTextOffset();
                if (this._delta < 0) {
                    if (this._offset < n2) {
                        n = Math.max(this._offset, n2 + this._delta);
                    }
                } else if (this._offset <= n2) {
                    n = n2 + this._delta;
                }
                if (n != -1) {
                    return DomPositionFactory.createTextPosition((CharacterData)this._node, (int)n);
                }
            }
            return domPosition;
        }
    }
}

