/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomMutationListener;
import oracle.bali.xml.dom.changes.AbstractAttrChange;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

final class ModelSelection
extends Selection {
    private DomPosition _pendingCursorLocation;

    ModelSelection(XmlModel xmlModel) {
        super(xmlModel);
    }

    public DomPosition getCursorLocation() {
        this._fixPendingCursorIfNeeded();
        return super.getCursorLocation();
    }

    public DomPosition setCursorLocation(DomPosition domPosition) {
        DomPosition domPosition2 = super.setCursorLocation(domPosition);
        this._pendingCursorLocation = null;
        return domPosition2;
    }

    protected void restoreSnapshotState(Map map) {
        super.restoreSnapshotState(map);
        this._pendingCursorLocation = null;
    }

    protected boolean commitTransaction() {
        this._fixPendingCursorIfNeeded();
        return super.commitTransaction();
    }

    void __attachToDomModel() {
        XmlModel xmlModel = this.getModel().getBaseModel();
        DomModel domModel = xmlModel.getDomModel();
        domModel.addDomMutationListener(new SelectionDomMutationListener(null));
    }

    private void _fixPendingCursorIfNeeded() {
        if (this._pendingCursorLocation != null) {
            if (this.getModel().isInModelDocumentHierarchy(this._pendingCursorLocation)) {
                this.setCursorLocation(this._pendingCursorLocation);
            }
            this._pendingCursorLocation = null;
        }
    }

    private void _setPendingCursorLocation(DomPosition domPosition) {
        if (domPosition != this.getCursorLocation()) {
            this.setCursorLocationImpl(null);
            this._pendingCursorLocation = domPosition;
        }
    }

    static void mav$_setPendingCursorLocation(ModelSelection modelSelection, DomPosition domPosition) {
        modelSelection._setPendingCursorLocation(domPosition);
    }

    private class SelectionDomMutationListener
    implements DomChangeHandler,
    DomMutationListener {
        private transient MutationEvent _mEvent;

        public void domMutated(DomModel domModel, DomChange domChange, MutationEvent mutationEvent) {
            if (!ModelSelection.this.isInTransaction()) {
                return;
            }
            this._mEvent = mutationEvent;
            try {
                if (domChange == null) {
                    this._handleDocumentReplacement();
                } else {
                    domChange.process(this);
                }
            }
            finally {
                this._mEvent = null;
            }
        }

        public void handleAttrAddedChange(AttrAddedChange attrAddedChange) {
        }

        public void handleAttrRemovedChange(AttrRemovedChange attrRemovedChange) {
            if (this._hasRangeSelectionTargetingAttribute(attrRemovedChange)) {
                ModelSelection.this.clearRangeSelectionPreservingNodes();
            }
        }

        public void handleAttrValueChange(AttrValueChange attrValueChange) {
            if (this._hasRangeSelectionTargetingAttribute(attrValueChange)) {
                String string = attrValueChange.getNewValue();
                DomRange domRange = ModelSelection.this.getRangeSelection();
                DomPosition domPosition = domRange.getStart();
                int n = domPosition.getTextOffset();
                if (n >= string.length()) {
                    ModelSelection.this.clearRangeSelectionPreservingNodes();
                } else {
                    DomPosition domPosition2 = domRange.getEnd();
                    if (domPosition2.getTextOffset() > string.length()) {
                        DomPosition domPosition3 = domPosition2.createPositionWithNewOffset(string.length());
                        DomRange domRange2 = domRange.getRangeWithNewEnd(ModelSelection.this.getModel().getTreeTraversal(), domPosition3);
                        ModelSelection.this.setRangeSelection(domRange2);
                    }
                }
            }
        }

        public void handleNodeInsertedChange(NodeInsertedChange nodeInsertedChange) {
            Node node = nodeInsertedChange.getNodeRef().getCorrespondingNode(ModelSelection.this.getSelectionDocument());
            ModelSelection.this.addNodeSubtreeIfWithinSelectedRange(node);
        }

        public void handleNodeRemovedChange(NodeRemovedChange nodeRemovedChange) {
            Node node = this._mEvent != null ? (Node)((Object)this._mEvent.getTarget()) : null;
            if (node == null || node.getNodeType() == 9) {
                this._handleDocumentReplacement();
            } else {
                ModelSelection.this.handleRemovalFromModel(node);
                this._fixCursorAndDropPositions(node);
            }
        }

        public void handleNodeValueChange(NodeValueChange nodeValueChange) {
            if (ModelSelection.this.hasRangeSelection()) {
                int n;
                int n2;
                DomRange domRange = ModelSelection.this.getRangeSelection();
                DomPosition domPosition = domRange.getStart();
                DomPosition domPosition2 = domRange.getEnd();
                Node node = nodeValueChange.getNodeRef().getCorrespondingNode(ModelSelection.this.getSelectionDocument());
                String string = nodeValueChange.getNewValue();
                DomPosition domPosition3 = domPosition;
                DomPosition domPosition4 = domPosition2;
                if (domPosition.hasTextOffset() && domPosition.getTargetNode() == node && (n2 = domPosition.getTextOffset()) >= string.length()) {
                    if (domPosition2.hasTextOffset() && domPosition2.getTargetNode() == node) {
                        ModelSelection.this.clearRangeSelectionPreservingNodes();
                        return;
                    }
                    domPosition3 = domPosition.getAfterPosition();
                }
                if (domPosition2.hasTextOffset() && domPosition2.getTargetNode() == node && (n = domPosition2.getTextOffset()) > string.length()) {
                    domPosition4 = domPosition2.createPositionWithNewOffset(string.length());
                }
                if (domPosition != domPosition3 || domPosition2 != domPosition4) {
                    ModelSelection.this.setRangeSelection(ModelSelection.this.createDomRange(domPosition3, domPosition4));
                }
            }
        }

        private void _handleDocumentReplacement() {
            Iterator iterator = ModelSelection.this.getSelectedNodes();
            ArrayList<Node> arrayList = new ArrayList<Node>(ModelSelection.this.getSelectedNodesCount());
            List list = new LinkedList();
            AbstractModel abstractModel = ModelSelection.this.getModel();
            TreeTraversal treeTraversal = abstractModel.getTreeTraversal();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                list = DomUtils.getNodePath((TreeTraversal)treeTraversal, (Node)node, list);
                Node node2 = null;
                if (!list.isEmpty()) {
                    node2 = abstractModel.remapNode(list);
                }
                if (node2 == null || DomUtils.isDocument((Node)node2)) continue;
                arrayList.add(node2);
            }
            ModelSelection.this.clear();
            ModelSelection.this.add(arrayList);
            ModelSelection.this.setCursorLocation(abstractModel.remapPosition(ModelSelection.this.getCursorLocation()));
            ModelSelection.this.setDropLocation(null);
        }

        private boolean _hasRangeSelectionTargetingAttribute(AbstractAttrChange abstractAttrChange) {
            DomRange domRange = ModelSelection.this.getRangeSelection();
            if (domRange != null) {
                QualifiedName qualifiedName;
                QualifiedName qualifiedName2;
                Element element = abstractAttrChange.getOwnerElement(ModelSelection.this.getSelectionDocument());
                DomPosition domPosition = domRange.getStart();
                if (domPosition.hasAttributeQName() && domPosition.getTargetNode() == element && (qualifiedName2 = domPosition.getAttributeQName()) == (qualifiedName = QualifiedName.getQualifiedName((String)abstractAttrChange.getAffectedAttrNamespace(), (String)abstractAttrChange.getAffectedAttrLocalName()))) {
                    return true;
                }
            }
            return false;
        }

        private DomPosition _updatePositionForDeletion(DomPosition domPosition, Node node) {
            if (domPosition == null) {
                return null;
            }
            Node node2 = domPosition.getTargetNode();
            if (!DomUtils.isNodeOrDescendant((Node)node2, (Node)node)) {
                return domPosition;
            }
            Node node3 = node2.getPreviousSibling();
            int n = 2;
            if (node3 == null) {
                node3 = node2.getNextSibling();
                if (node3 == null) {
                    node3 = node2.getParentNode();
                    n = 0;
                } else {
                    n = 1;
                }
            }
            if (node3 == null) {
                return null;
            }
            return DomPositionFactory.createDomPosition((Node)node3, (int)n);
        }

        private void _fixCursorAndDropPositions(Node node) {
            DomPosition domPosition = ModelSelection.this.getCursorLocation();
            DomPosition domPosition2 = this._updatePositionForDeletion(domPosition, node);
            ModelSelection.mav$_setPendingCursorLocation(ModelSelection.this, domPosition2);
            DomPosition domPosition3 = ModelSelection.this.getDropLocation();
            DomPosition domPosition4 = this._updatePositionForDeletion(domPosition3, node);
            ModelSelection.this.setDropLocation(domPosition4);
        }

        private SelectionDomMutationListener() {
        }

        SelectionDomMutationListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

