/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.metadata.refinfo.RefInfo;
import oracle.bali.xml.validator.DefaultValidationContext;
import oracle.bali.xml.validator.PerValidationState;
import oracle.bali.xml.validator.ValidationException;
import oracle.bali.xml.validator.ValidatorCallback;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class ModelValidationContext
extends DefaultValidationContext {
    private List _list = Collections.EMPTY_LIST;
    private XmlModel _model;

    public ModelValidationContext(GrammarResolver grammarResolver, ErrorHandler errorHandler, ValidatorCallback validatorCallback, XmlModel xmlModel) {
        super(grammarResolver, errorHandler, validatorCallback);
        this._model = xmlModel;
    }

    public List getRefInfos() {
        return Collections.unmodifiableList(this._list);
    }

    public void performAdditionalValidation(PerValidationState perValidationState, Element element, ElementDef elementDef, int n, boolean bl) {
        super.performAdditionalValidation(perValidationState, element, elementDef, n, bl);
        this._checkRefInfo(element);
    }

    public void performAdditionalValidation(PerValidationState perValidationState, Attr attr, AttributeDef attributeDef, int n) {
        super.performAdditionalValidation(perValidationState, attr, attributeDef, n);
        this._checkRefInfo(attr);
    }

    private void _checkRefInfo(Node node) {
        RefInfo refInfo = this._model.getXmlMetadataResolver().getRefInfo(node);
        if (refInfo != null) {
            if (this._list == Collections.EMPTY_LIST) {
                this._list = new ArrayList();
            }
            this._list.add(refInfo);
            try {
                refInfo.validate(this._model.getContext(), node);
            }
            catch (ValidationException validationException) {
                if (refInfo.getErrorLevel() == 0) {
                    this.reportErrorImpl(validationException);
                } else if (refInfo.getErrorLevel() == 1) {
                    this.reportWarningImpl(validationException);
                }
            }
            catch (Exception exception) {
                this._model.getContext().getLogger().log(Level.FINEST, "RefInfo " + refInfo + " threw exception ", exception);
            }
        }
    }
}

