/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.SelectionTransaction;
import oracle.bali.xml.model.SetChangeListener;
import oracle.bali.xml.share.UnmodifiableArrayList;
import oracle.bali.xml.share.UnmodifiableIterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class Selection {
    static final /* synthetic */ boolean $assertionsDisabled;
    private SelectionTransaction _currTransaction;
    private SelectionTransaction _rootTransaction;
    private DomRange _rangeSelection;
    private final AbstractModel _owner;
    private final LinkedHashSet _selectedNodes;
    private final LinkedList _removeList;
    private final LinkedList _addList;
    private DomPosition _cursorLocation;
    private DomPosition _dropLocation;
    private static final Logger _LOGGER;

    public Selection(AbstractModel abstractModel) {
        this.$init$();
        if (abstractModel == null) {
            throw new IllegalArgumentException("No owner specified");
        }
        this._owner = abstractModel;
        this._startTransaction();
        this._rootTransaction = this._currTransaction;
    }

    public DomPosition getCursorLocation() {
        return this._cursorLocation;
    }

    public DomPosition setCursorLocation(DomPosition domPosition) {
        this.checkTransaction();
        domPosition = this.getModel().convertInsertionPosition(domPosition);
        this.checkValidDomPosition(domPosition);
        this.setCursorLocationImpl(domPosition);
        return domPosition;
    }

    public DomPosition getDropLocation() {
        return this._dropLocation;
    }

    public DomPosition setDropLocation(DomPosition domPosition) {
        this.checkTransaction();
        this.checkValidDomPosition(domPosition);
        this.setDropLocationImpl(domPosition);
        return domPosition;
    }

    public Node getEarliestSelectedNode() {
        this._verifyLock();
        Iterator iterator = this.getSelectedNodes();
        Node node = null;
        TreeTraversal treeTraversal = this.getModel().getTreeTraversal();
        while (iterator.hasNext()) {
            node = DomUtils.earlierPreorderNode((TreeTraversal)treeTraversal, node, (Node)((Node)iterator.next()));
        }
        return node;
    }

    public final AbstractModel getModel() {
        return this._owner;
    }

    public Node getLatestSelectedNode() {
        this._verifyLock();
        Iterator iterator = this.getSelectedNodes();
        TreeTraversal treeTraversal = this.getModel().getTreeTraversal();
        Node node = null;
        while (iterator.hasNext()) {
            node = DomUtils.laterPreorderNode((TreeTraversal)treeTraversal, node, (Node)((Node)iterator.next()));
        }
        return node;
    }

    public Node getFirstSelectedNode() {
        this._verifyLock();
        Iterator iterator = this.getSelectedNodes();
        if (iterator.hasNext()) {
            return (Node)iterator.next();
        }
        return null;
    }

    public boolean isEmpty() {
        this._verifyLock();
        return this._selectedNodes.isEmpty();
    }

    static {
        $assertionsDisabled = Selection.class.desiredAssertionStatus() ^ true;
        _LOGGER = Logger.getLogger(Selection.class.getName());
    }

    public boolean clear() {
        this.checkTransaction();
        this._currTransaction.__selectionCleared();
        if (this._selectedNodes.isEmpty()) {
            if (!$assertionsDisabled && this._rangeSelection != null) {
                throw new AssertionError();
            }
            return false;
        }
        this._removeList.addAll(this._selectedNodes);
        this._selectedNodes.clear();
        this._rangeSelection = null;
        if (_LOGGER.isLoggable(Level.FINE)) {
            _LOGGER.log(Level.FINE, "Cleared selection: {0}", this);
        }
        return true;
    }

    public final boolean add(Node node) {
        this.checkTransaction();
        this.checkValidNode(node);
        return this.addImpl(node);
    }

    public final boolean remove(Node node) {
        this.checkTransaction();
        this.checkValidNode(node);
        return this.removeImpl(node);
    }

    public final boolean set(Node node) {
        return this.set(Collections.singleton(node));
    }

    public final boolean set(Collection collection) {
        this.checkTransaction();
        if (this._selectedNodes.equals(collection)) {
            return false;
        }
        this.clear();
        this.add(collection);
        return true;
    }

    public final void remove(Collection collection) {
        this.checkTransaction();
        for (Node node : collection) {
            this.checkValidNode(node);
            this.removeImpl(node);
        }
    }

    public final void add(Collection collection) {
        this.checkTransaction();
        for (Node node : collection) {
            this.checkValidNode(node);
            this.addImpl(node);
        }
    }

    public Node[] getSelectedNodesArray() {
        this._verifyLock();
        Node[] nodeArray = new Node[this.size()];
        if (nodeArray.length != 0) {
            nodeArray = this._selectedNodes.toArray(nodeArray);
        }
        return nodeArray;
    }

    public List getSelectedNodesList() {
        this._verifyLock();
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new UnmodifiableArrayList(this.getSelectedNodesArray());
    }

    public int size() {
        this._verifyLock();
        return this._selectedNodes.size();
    }

    public boolean contains(Node node) {
        this._verifyLock();
        this.checkValidNode(node);
        return this._selectedNodes.contains(node);
    }

    public boolean containsOnly(Node node) {
        this._verifyLock();
        this.checkValidNode(node);
        return this._selectedNodes.size() == 1 && node == this.getFirstSelectedNode();
    }

    public Iterator getSelectedNodes() {
        this._verifyLock();
        return new LockAssertingUnmodifiableIterator(this._selectedNodes.iterator());
    }

    public int getSelectedNodesCount() {
        this._verifyLock();
        return this._selectedNodes.size();
    }

    public final DomRange createDomRange(DomPosition domPosition, DomPosition domPosition2) {
        this._verifyLock();
        return DomRange.create((DomPosition)domPosition, (DomPosition)domPosition2, (TreeTraversal)this.getModel().getTreeTraversal());
    }

    public void extendRangeSelection(DomPosition domPosition) {
        this.checkTransaction();
        if (!this.hasRangeSelection()) {
            throw new IllegalStateException("can't extend since there is no current range!");
        }
        TreeTraversal treeTraversal = this.getModel().getTreeTraversal();
        DomRange domRange = this.getRangeSelection();
        if (domRange.compareTo(treeTraversal, domPosition, true) != 0) {
            this.setRangeSelection(domRange.getExtendedRange(treeTraversal, domPosition));
        }
    }

    public void moveRangeSelectionStart(DomPosition domPosition) {
        this.checkTransaction();
        if (!this.hasRangeSelection()) {
            throw new IllegalStateException("can't move selection start since there is no current range!");
        }
        DomRange domRange = this.getRangeSelection();
        DomRange domRange2 = domRange.getRangeWithNewStart(this.getModel().getTreeTraversal(), domPosition);
        this.setRangeSelection(domRange2);
    }

    public void moveRangeSelectionEnd(DomPosition domPosition) {
        this.checkTransaction();
        if (!this.hasRangeSelection()) {
            throw new IllegalStateException("can't move selection end since there is no current range!");
        }
        DomRange domRange = this.getRangeSelection();
        DomRange domRange2 = domRange.getRangeWithNewEnd(this.getModel().getTreeTraversal(), domPosition);
        this.setRangeSelection(domRange2);
    }

    public void setRangeSelection(DomRange domRange) {
        this.checkTransaction();
        if (domRange == null) {
            this.clear();
        } else if (!domRange.equals((Object)this._rangeSelection)) {
            this.set(domRange.getNodesInRange(this.getModel().getTreeTraversal()));
            this._rangeSelection = domRange;
        }
    }

    public boolean hasRangeSelection() {
        return this._rangeSelection != null;
    }

    public DomRange getRangeSelection() {
        this._verifyLock();
        return this._rangeSelection;
    }

    public void checkValidNode(Node node) {
        Document document;
        this._verifyLock();
        if (node == null) {
            throw new IllegalArgumentException("null node!");
        }
        Document document2 = node.getOwnerDocument();
        if (document2 != (document = this.getSelectionDocument()) && node != document) {
            throw new DOMException(4, "Not selection document:" + document2);
        }
        if (!this.getModel().isInModelDocumentHierarchy(node)) {
            throw new IllegalArgumentException("Node not in document hierarchy!");
        }
    }

    public void checkValidDomPosition(DomPosition domPosition) {
        this._verifyLock();
        if (domPosition != null) {
            this.checkValidNode(domPosition.getTargetNode());
        }
    }

    public String toString() {
        return super.toString() + " selection=" + this._selectedNodes;
    }

    public final void acquireModelReadLock() {
        this.getModel().acquireReadLock();
    }

    public final void releaseModelReadLock() {
        this.getModel().releaseReadLock();
    }

    protected boolean addImpl(Node node) {
        return Selection.addNodeDirectly(this, node);
    }

    protected boolean removeImpl(Node node) {
        return Selection.removeNodeDirectly(this, node);
    }

    protected Map getSnapshotState(Map map) {
        map.put("cursorLocation", this._cursorLocation);
        map.put("dropLocation", this._dropLocation);
        map.put("rangeSelection", this._rangeSelection);
        return map;
    }

    protected void restoreSnapshotState(Map map) {
        this.setCursorLocationImpl((DomPosition)map.get("cursorLocation"));
        this.setDropLocationImpl((DomPosition)map.get("dropLocation"));
        this._rangeSelection = (DomRange)map.get("rangeSelection");
    }

    protected void addSelectionChangeListener(SetChangeListener setChangeListener) {
        this._currTransaction.addSelectionChangeListener(setChangeListener);
    }

    protected void removeSelectionChangeListener(SetChangeListener setChangeListener) {
        this._currTransaction.removeSelectionChangeListener(setChangeListener);
    }

    protected void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._currTransaction.addPropertyChangeListener(propertyChangeListener);
    }

    protected void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._currTransaction.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void checkTransaction() {
        if (!this.isInTransaction()) {
            throw new IllegalStateException("No Mutation allowed outside of transaction");
        }
        this._verifyWriteLock();
    }

    protected static boolean removeNodeDirectly(Selection selection, Node node) {
        selection._verifyWriteLock();
        boolean bl = selection._selectedNodes.remove(node);
        if (bl) {
            selection._removeList.add(node);
            selection._rangeSelection = null;
        }
        if (_LOGGER.isLoggable(Level.FINE)) {
            _LOGGER.log(Level.FINE, "removeNode: {0} from selection {1} (model={2}) {3}", new Object[]{selection.getModel().getXmlMetadataResolver().getMediumDisplayName(node), selection, selection.getModel(), bl ? "" : " (node was already not selected)"});
        }
        return bl;
    }

    protected static boolean addNodeDirectly(Selection selection, Node node) {
        selection._verifyWriteLock();
        boolean bl = selection._selectedNodes.add(node);
        if (bl) {
            selection._addList.add(node);
            selection._rangeSelection = null;
        }
        if (_LOGGER.isLoggable(Level.FINE)) {
            _LOGGER.log(Level.FINE, "addNode: {0} to selection {1} (model={2}) {3}", new Object[]{selection.getModel().getXmlMetadataResolver().getMediumDisplayName(node), selection, selection.getModel(), bl ? "" : " (node was already selected)"});
        }
        return bl;
    }

    protected final void clearRangeSelectionPreservingNodes() {
        this._rangeSelection = null;
    }

    protected final void addNodeSubtreeIfWithinSelectedRange(Node node) {
        if (this.hasRangeSelection() && this.getRangeSelection().isInRange(this.getModel().getTreeTraversal(), node)) {
            this._updateNodeSubtree(node, true);
        }
    }

    protected final void handleRemovalFromModel(Node node) {
        this.checkTransaction();
        DomRange domRange = this.getRangeSelection();
        TreeTraversal treeTraversal = this.getTreeTraversal();
        Set set = DomUtils.getNodesInSubtree((TreeTraversal)treeTraversal, (Node)node);
        this.remove(set);
        if (domRange != null) {
            DomPosition domPosition = domRange.getStart();
            Node node2 = domPosition.getTargetNode();
            DomPosition domPosition2 = domRange.getEnd();
            Node node3 = domPosition2.getTargetNode();
            boolean bl = set.contains(node2);
            boolean bl2 = set.contains(node3);
            if (bl && bl2) {
                this.clearRangeSelectionPreservingNodes();
            } else if (!bl && !bl2) {
                this._rangeSelection = domRange;
            } else if (bl) {
                Node node4 = this._nextNodeNotInSet(set, node2, node3);
                if (node4 == null) {
                    this.clearRangeSelectionPreservingNodes();
                } else if (node4 == node3) {
                    if (domPosition2.isBefore()) {
                        this.clearRangeSelectionPreservingNodes();
                    } else {
                        this._rangeSelection = this.createDomRange(domPosition2.getBeforePosition(), domPosition2);
                    }
                } else {
                    this._rangeSelection = this.createDomRange(DomPositionFactory.createDomPosition((Node)node4, (int)1), domPosition2);
                }
            } else if (bl2) {
                DomPosition domPosition3 = null;
                if (node3 == node) {
                    Node node5 = treeTraversal.getNextSibling(node3);
                    if (node5 != null) {
                        domPosition3 = DomPositionFactory.createDomPosition((Node)node5, (int)1);
                    } else {
                        Node node6 = treeTraversal.getPreviousSibling(node3);
                        if (node6 != null) {
                            domPosition3 = DomPositionFactory.createDomPosition((Node)node6, (int)2);
                        } else {
                            Node node7 = treeTraversal.getParentNode(node3);
                            domPosition3 = DomPositionFactory.createDomPosition((Node)node7, (int)0);
                        }
                    }
                }
                if (domPosition3 == null) {
                    this.clearRangeSelectionPreservingNodes();
                } else {
                    this._rangeSelection = this.createDomRange(domPosition, domPosition3);
                }
            }
        }
    }

    protected final Document getSelectionDocument() {
        this._verifyLock();
        return this.getModel().getDocument();
    }

    protected final TreeTraversal getTreeTraversal() {
        this._verifyLock();
        return this.getModel().getTreeTraversal();
    }

    protected LinkedHashSet getSelectedNodeStorage() {
        this._verifyLock();
        if (this.isInTransaction()) {
            throw new IllegalStateException("No updating selection storage inside transaction");
        }
        return this._selectedNodes;
    }

    protected Set getSelectedNodeSet() {
        this._verifyLock();
        return this._selectedNodes;
    }

    protected final boolean isInTransaction() {
        return this._rootTransaction != this._currTransaction;
    }

    protected final void setCursorLocationImpl(DomPosition domPosition) {
        this._cursorLocation = domPosition;
    }

    protected final void setDropLocationImpl(DomPosition domPosition) {
        this._dropLocation = domPosition;
    }

    void __startTransaction() {
        this.getModel().__acquireWriteLock();
        this._startTransaction();
    }

    private void _startTransaction() {
        this._currTransaction = new SelectionTransaction(this._currTransaction, this._addList.size(), this._removeList.size(), this.getSnapshotState(new HashMap(7)));
    }

    void __rollbackTransaction() {
        this._currTransaction = this._currTransaction.rollback(this, this._selectedNodes, this._addList, this._removeList);
        this.getModel().__releaseWriteLock();
    }

    protected boolean commitTransaction() {
        this._currTransaction = this._currTransaction.commit(this, this._addList, this._removeList);
        this.getModel().__releaseWriteLock();
        return this._currTransaction == this._rootTransaction;
    }

    private Node _nextNodeNotInSet(Set set, Node node, Node node2) {
        this._verifyLock();
        Node node3 = node;
        while ((node3 = this.getTreeTraversal().getNextNode(node3)) != null && node3 != node2 && set.contains(node3)) {
        }
        return node3;
    }

    private void _updateNodeSubtree(Node node, boolean bl) {
        this._verifyLock();
        if (bl) {
            boolean bl2 = this._selectedNodes.add(node);
            if (bl2) {
                this._addList.add(node);
            }
        } else {
            boolean bl3 = this._selectedNodes.remove(node);
            if (bl3) {
                this._removeList.add(node);
            }
        }
        TreeTraversal treeTraversal = this.getModel().getTreeTraversal();
        Node node2 = treeTraversal.getFirstChild(node);
        while (node2 != null) {
            this._updateNodeSubtree(node2, bl);
            node2 = treeTraversal.getNextSibling(node2);
        }
    }

    private void _verifyLock() {
        this.getModel().__verifyLock();
    }

    private void _verifyWriteLock() {
        this.getModel().__verifyWriteLock();
    }

    void $init$() {
        this._rangeSelection = null;
        this._selectedNodes = new LinkedHashSet();
        this._removeList = new LinkedList();
        this._addList = new LinkedList();
    }

    static void mav$_verifyLock(Selection selection) {
        selection._verifyLock();
    }

    public class LockAssertingUnmodifiableIterator
    extends UnmodifiableIterator {
        public LockAssertingUnmodifiableIterator(Iterator iterator) {
            super(iterator);
        }

        public Object next() {
            Selection.mav$_verifyLock(Selection.this);
            return super.next();
        }

        public boolean hasNext() {
            Selection.mav$_verifyLock(Selection.this);
            return super.hasNext();
        }
    }
}

