/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.SetChangeEvent;
import oracle.bali.xml.model.SetChangeListener;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.bali.xml.share.SafePropertyChangeSupport;

class SelectionTransaction {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final int _addStartIndex;
    private final int _removeStartIndex;
    private final Map _snapshotState;
    private final SelectionTransaction _parentTransaction;
    private SafeListenerManager _selectionChangeListeners;
    private SafePropertyChangeSupport _propertyChangeSupport;
    private boolean _cleared;

    public SelectionTransaction(SelectionTransaction selectionTransaction, int n, int n2, Map map) {
        this.$init$();
        this._parentTransaction = selectionTransaction;
        this._addStartIndex = n;
        this._removeStartIndex = n2;
        this._snapshotState = map;
    }

    public void addSelectionChangeListener(SetChangeListener setChangeListener) {
        if (this._selectionChangeListeners == null) {
            this._selectionChangeListeners = new SafeListenerManager();
        }
        this._selectionChangeListeners.addListener(setChangeListener);
    }

    public void removeSelectionChangeListener(SetChangeListener setChangeListener) {
        this._selectionChangeListeners.removeListener(setChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new SafePropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    void __selectionCleared() {
        this._cleared = true;
    }

    static {
        $assertionsDisabled = SelectionTransaction.class.desiredAssertionStatus() ^ true;
    }

    private void _calculateRefCounts(ListIterator listIterator, ListIterator listIterator2, Map map) {
        if (!($assertionsDisabled || map != null && map.isEmpty())) {
            throw new AssertionError();
        }
        SelectionTransaction._updateRefCounts(listIterator, 1, map);
        SelectionTransaction._updateRefCounts(listIterator2, -1, map);
    }

    private void _rollbackSelectionChanges(Set set, LinkedList linkedList, LinkedList linkedList2) {
        Map map = this._createRefCountMap(linkedList, linkedList2);
        List list = linkedList.subList(this._addStartIndex, linkedList.size());
        List list2 = linkedList2.subList(this._removeStartIndex, linkedList2.size());
        this._calculateRefCounts(list.listIterator(), list2.listIterator(), map);
        list.clear();
        list2.clear();
        if (map.isEmpty()) {
            return;
        }
        for (Object k : map.keySet()) {
            int n = ((Number)map.get(k)).intValue();
            if (!($assertionsDisabled || n >= -1 && n <= 1)) {
                throw new AssertionError();
            }
            if (n == -1) {
                set.add(k);
                continue;
            }
            if (n != 1) continue;
            set.remove(k);
        }
    }

    private static void _updateRefCounts(ListIterator listIterator, int n, Map map) {
        if (!$assertionsDisabled && n != 1 && n != -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        if (!listIterator.hasNext()) {
            return;
        }
        Integer n2 = IntegerUtils.getInteger((int)n);
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            Object object = map.get(e);
            int n3 = n;
            if (object != null) {
                n3 += ((Number)object).intValue();
                object = IntegerUtils.getInteger((int)n3);
            } else {
                object = n2;
            }
            map.put(e, object);
        }
    }

    private static void _calculateAddedAndRemovedSets(Map map, Set set, Set set2) {
        if (!($assertionsDisabled || set != null && set.isEmpty())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || set2 != null && set2.isEmpty())) {
            throw new AssertionError();
        }
        if (map != null) {
            for (Object k : map.keySet()) {
                int n = ((Number)map.get(k)).intValue();
                if (!($assertionsDisabled || n >= -1 && n <= 1)) {
                    throw new AssertionError();
                }
                if (n == -1) {
                    set2.add(k);
                    continue;
                }
                if (n != 1) continue;
                set.add(k);
            }
        }
    }

    public SelectionTransaction rollback(Selection selection, Set set, LinkedList linkedList, LinkedList linkedList2) {
        if (this._parentTransaction == null) {
            throw new IllegalStateException("No parent transaction to rollback");
        }
        this._rollbackSelectionChanges(set, linkedList, linkedList2);
        selection.restoreSnapshotState(this._snapshotState);
        return this._parentTransaction;
    }

    public SelectionTransaction commit(Selection selection, LinkedList linkedList, LinkedList linkedList2) {
        if (this._parentTransaction == null) {
            throw new IllegalStateException("No parent transaction to commit");
        }
        this._parentTransaction._mergeChildTransactionState(selection, linkedList, linkedList2, this);
        return this._parentTransaction;
    }

    private Map _createRefCountMap(List list, List list2) {
        int n = list.size() - this._addStartIndex;
        int n2 = list2.size() - this._removeStartIndex;
        return new HashMap((int)((double)(n + n2) * 1.5));
    }

    private void _mergeChildTransactionState(Selection selection, List list, List list2, SelectionTransaction selectionTransaction) {
        this._cleared |= selectionTransaction._cleared;
        if (this._selectionChangeListeners != null && !this._selectionChangeListeners.isEmpty()) {
            Map map = this._createRefCountMap(list, list2);
            this._calculateRefCounts(list.listIterator(selectionTransaction._addStartIndex), list2.listIterator(selectionTransaction._removeStartIndex), map);
            int n = (int)((double)map.size() * 1.5);
            HashSet hashSet = new HashSet(n);
            HashSet hashSet2 = new HashSet(n);
            SelectionTransaction._calculateAddedAndRemovedSets(map, hashSet, hashSet2);
            if (this._parentTransaction == null) {
                list.clear();
                list2.clear();
            }
            this._fireSelectionChanged(selection, hashSet, hashSet2);
        }
        this._firePropertyChanges(selection, selectionTransaction._snapshotState, this._cleared);
        if (this._parentTransaction == null) {
            this._cleared = false;
        }
    }

    private void _firePropertyChanges(Selection selection, Map map, boolean bl) {
        if (this._propertyChangeSupport != null && this._propertyChangeSupport.hasListeners()) {
            Map map2 = selection.getSnapshotState(new HashMap(7));
            Iterator iterator = map.keySet().iterator();
            LinkedList<PropertyChangeEvent> linkedList = new LinkedList<PropertyChangeEvent>();
            while (iterator.hasNext()) {
                Object v;
                Object k = iterator.next();
                Object v2 = map2.get(k);
                if (v2 == (v = map.get(k)) || v2 != null && v2.equals(v)) continue;
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(selection, (String)k, v, v2);
                linkedList.add(propertyChangeEvent);
            }
            if (bl) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(selection, "selectionCleared", Boolean.FALSE, Boolean.TRUE);
                linkedList.add(propertyChangeEvent);
            }
            this._propertyChangeSupport.firePropertyChanges(linkedList);
        }
    }

    private void _fireSelectionChanged(Selection selection, Set set, Set set2) {
        if (!$assertionsDisabled && (this._selectionChangeListeners == null || this._selectionChangeListeners.isEmpty())) {
            throw new AssertionError();
        }
        if (set != null && !set.isEmpty() || set2 != null && !set2.isEmpty()) {
            SetChangeEvent setChangeEvent = new SetChangeEvent(selection, set, set2);
            Iterator iterator = this._selectionChangeListeners.iterator();
            while (iterator.hasNext()) {
                SetChangeListener setChangeListener = (SetChangeListener)iterator.next();
                try {
                    setChangeListener.setChanged(setChangeEvent);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    selection.getModel().getLogger().log(Level.SEVERE, "Exception during selection change event firing:", throwable);
                }
            }
        }
    }

    void $init$() {
        this._cleared = false;
    }
}

