/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.SynchronizedDomModel;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.instance.XmlInstanceGrammarProvider;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.ServiceProvider;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContextSetupHook;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.XmlViewFactory;
import oracle.bali.xml.model.action.ActionManager;
import oracle.bali.xml.model.action.ClearAction;
import oracle.bali.xml.model.action.CopyAction;
import oracle.bali.xml.model.action.CutAction;
import oracle.bali.xml.model.action.DuplicateAction;
import oracle.bali.xml.model.action.PasteAction;
import oracle.bali.xml.model.datatransfer.AugmentingClipboardManager;
import oracle.bali.xml.model.datatransfer.operation.OperationManager;
import oracle.bali.xml.model.datatransfer.operation.StandardOperationFactory;
import oracle.bali.xml.model.event.XmlContextLifecycleListener;
import oracle.bali.xml.model.metadata.refinfo.IntrospectionRefInfoResolver;
import oracle.bali.xml.model.metadata.refinfo.RefInfoResolver;
import oracle.bali.xml.model.view.IdentityView;
import oracle.bali.xml.preference.Preference;
import oracle.bali.xml.preference.XmlPreferenceManager;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.MultiUndoableEdit;
import oracle.bali.xml.share.SafeListenerManager;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.bali.xml.share.clipboard.StandaloneClipboardManager;
import oracle.bali.xml.util.ContextualActionProvider;
import oracle.bali.xml.util.NodeCreator;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.bali.xml.util.XmlCustomizeAction;
import oracle.javatools.datatransfer.DataTransferPluginRegistry;
import oracle.javatools.logging.LogUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class XmlContext
extends DomModelContext
implements ServiceProvider {
    public static final String CUT_COMMAND = "cut";
    public static final String COPY_COMMAND = "copy";
    public static final String PASTE_COMMAND = "paste";
    public static final String PASTE_SPECIAL_COMMAND = "paste_special";
    public static final String DUPLICATE_COMMAND = "duplicate";
    public static final String CLEAR_COMMAND = "clear";
    public static final String REFRESH_COMMAND = "refresh";
    public static final String GOTO_SOURCE_COMMAND = "gotosource";
    public static final String GOTO_DECLARATION_COMMAND = "gotodeclaration";
    public static final String UNDO_COMMAND = "undo";
    public static final String REDO_COMMAND = "redo";
    public static final String NEXT_NODE_COMMAND = "nextNode";
    public static final String PREV_NODE_COMMAND = "prevNode";
    public static final String NEXT_INSERTION_POS_COMMAND = "nextInsertionPos";
    public static final String PREV_INSERTION_POS_COMMAND = "prevInsertionPos";
    public static final String NEXT_SIBLING_INSERTION_POS_COMMAND = "nextSiblingInsertionPos";
    public static final String PREV_SIBLING_INSERTION_POS_COMMAND = "prevSiblingInsertionPos";
    public static final String PARENT_INSERTION_POS_COMMAND = "parentInsertionPos";
    public static final String FIRST_CHILD_INSERTION_POS_COMMAND = "firstChildInsertionPos";
    public static final String CUSTOMIZE_NODE_COMMAND = "customizeNode";
    public static final String CONVERT_NODE_COMMAND = "convertNode";
    public static final String SURROUND_NODE_COMMAND = "surroundNode";
    public static final String ACTION_MUTATES_MODEL_PROPERTY = "XmlContext.MUTATES_MODEL";
    public static final String ACTION_HIDE_WHEN_DISABLED_PROPERTY = "XmlContext._HIDE_WHEN_DISABLED";
    public static final String ACTIVE_VIEW_PROPERTY = "XmlContext.ACTIVE_VIEW";
    public static final String CLIPBOARD_FLAVORS_PROPERTY = "XmlContext.CLIPBOARD_FLAVORS";
    public static final String CONTEXT_SECTION_ID_ACTION_PROPERTY = "XmlContext.CONTEXT_SECTION_ID_ACTION_PROPERTY";
    public static final Float INSERTION_SECTION_ID_VALUE;
    public static final Object BASE_TYPE_WEBAPP_ROOT;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Object _UNSET_VALUE;
    private static final String _SAVE_TRANSACTION_STACKS_SYSTEM_PROPERTY = "oracle.bali.xml.transactionStacks";
    private static final SafeListenerManager _sSetupHooks;
    private static final ClipboardManager _STANDALONE_CLIPBOARD_MANAGER;
    private final ListenerImpls _listenerImpls;
    private final ActionManager _actionManager;
    private ResourceBundle _bundle;
    private XmlView _activeView;
    private IdentityView[] _identityViews;
    private XmlModel _flattenedModel;
    private XmlModel _sourceModel;
    private XmlPreferenceManager _preferenceManager;
    private GrammarProvider _grammarProvider;
    private GrammarResolver _grammarResolver;
    private PreferenceChangeListenersManager _prefChangeListenerManager;
    private TransactionToken _token;
    private final ClipboardManager _clipboardManager;
    private final Logger _logger;
    private final LinkedList _viewFactories;
    private final Set _propertyChangeListeners;
    private final Map _views;
    private final List _serviceProviders;
    private final Map _services;
    private final SafeListenerManager _lifecycleListeners;
    private final transient List _mappingList;
    private transient ArrayList _propertyChangeListenersList;
    private transient ArrayList _transactionOwners;
    private final SafeListenerManager _undoListeners;
    private final DataTransferPluginRegistry _dataTransferPluginRegistry;
    private final List _currUndoableEdits;
    private final OperationManager _opManager;
    private static transient boolean _sSaveTransactionStackTraces;
    private RefInfoResolver _refInfoResolver;
    private final SafeListenerManager _globalContextualActionProviders;

    static {
        $assertionsDisabled = XmlContext.class.desiredAssertionStatus() ^ true;
        INSERTION_SECTION_ID_VALUE = new Float(5.0f);
        BASE_TYPE_WEBAPP_ROOT = new String("webapp root");
        _UNSET_VALUE = new Object();
        _sSetupHooks = new SafeListenerManager();
        _STANDALONE_CLIPBOARD_MANAGER = new StandaloneClipboardManager();
        String string = System.getProperty(_SAVE_TRANSACTION_STACKS_SYSTEM_PROPERTY, "false");
        _sSaveTransactionStackTraces = string.equalsIgnoreCase("true");
    }

    public XmlContext() {
        this.$init$();
        this._logger = this.createLogger();
        this._viewFactories = new LinkedList();
        this._viewFactories.add(new XmlViewFactory());
        this._actionManager = new ActionManager(this);
        this._clipboardManager = new AugmentingClipboardManager(this, this.getUnderlyingClipboardManager());
    }

    public final void finishInitialization() {
        this._bundle = this.createBundle();
        this.initActions();
        this.initOperations();
    }

    public static void registerSetupHook(XmlContextSetupHook xmlContextSetupHook) {
        _sSetupHooks.addListener(xmlContextSetupHook);
    }

    public static void unregisterSetupHook(XmlContextSetupHook xmlContextSetupHook) {
        _sSetupHooks.removeListener(xmlContextSetupHook);
    }

    private void _initializeModel(XmlModel xmlModel) {
        xmlModel.__attachContext(this);
        xmlModel.__acquireWriteLock();
        try {
            this._preferenceManager = this.createPreferenceManager(xmlModel.getClass().getName());
            this._prefChangeListenerManager = new PreferenceChangeListenersManager(this);
            xmlModel.__addUndoableEditListener(this._listenerImpls);
            xmlModel.contextAttached();
            xmlModel.postAttachmentHook();
            Iterator iterator = _sSetupHooks.iterator();
            while (iterator.hasNext()) {
                XmlContextSetupHook xmlContextSetupHook = (XmlContextSetupHook)iterator.next();
                try {
                    xmlContextSetupHook.setup(this);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    LogRecord logRecord = new LogRecord(Level.SEVERE, "Exception thrown when running setup hook {0} on context {1}!");
                    logRecord.setThrown(throwable);
                    logRecord.setParameters(new Object[]{xmlContextSetupHook, this});
                    this.getLogger().log(logRecord);
                }
            }
            xmlModel.__initializationComplete();
            xmlModel.postCreationHook();
        }
        finally {
            xmlModel.__releaseWriteLock();
        }
    }

    public final void setModel(XmlModel xmlModel) {
        try {
            this._flattenedModel = xmlModel;
            this._setSourceModel(xmlModel);
        }
        catch (RuntimeException runtimeException) {
            this._flattenedModel = null;
            throw runtimeException;
        }
        this.modelAttachmentComplete();
    }

    public final void setModels(XmlModel xmlModel, XmlModel xmlModel2) {
        if (xmlModel == xmlModel2) {
            this.setModel(xmlModel);
        } else {
            this._setSourceModel(xmlModel);
            this._setFlattenedModel(xmlModel2);
            this.modelAttachmentComplete();
        }
    }

    public final XmlModel getModel() {
        return this._flattenedModel;
    }

    public final XmlModel getSourceModel() {
        return this._sourceModel;
    }

    public XmlModel getRelatedXmlModel(URL uRL) {
        return null;
    }

    public final void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this._undoListeners.addListener(undoableEditListener);
    }

    public final void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this._undoListeners.removeListener(undoableEditListener);
    }

    public final Node remapNode(Document document, Node node) {
        Document document2 = node.getOwnerDocument();
        if (document2 == document) {
            return node;
        }
        return this._mapNodeToDocument(document, node);
    }

    public final Node sourceToFlattened(Node node) {
        if (this._sourceModel == this._flattenedModel) {
            return node;
        }
        return this._mapNodeToDocument(this._flattenedModel.getDomModel().getDocument(), node);
    }

    public Node flattenedToSource(Node node) {
        if (this._sourceModel == this._flattenedModel) {
            return node;
        }
        return this._mapNodeToDocument(this._sourceModel.getDomModel().getDocument(), node);
    }

    public OperationManager getOperationManager() {
        return this._opManager;
    }

    public final GrammarProvider getGrammarProvider() {
        if (this._grammarProvider == null) {
            this._grammarProvider = this.createGrammarProvider();
        }
        return this._grammarProvider;
    }

    public final GrammarResolver getGrammarResolver() {
        if (this._grammarResolver == null) {
            this._grammarResolver = this.createGrammarResolver();
        }
        return this._grammarResolver;
    }

    public Action getAction(String string) {
        return this._actionManager.getAction(string);
    }

    public Action createModelAction(String string, AbstractModel abstractModel) {
        return null;
    }

    public Action[] getActions(String[] stringArray) {
        int n = stringArray.length;
        Action[] actionArray = new Action[n];
        int n2 = 0;
        while (n2 < n) {
            actionArray[n2] = this.getAction(stringArray[n2]);
            ++n2;
        }
        return actionArray;
    }

    public XmlPreferenceManager getPreferenceManager() {
        return this._preferenceManager;
    }

    public abstract URL getURLForRelativePath(String var1);

    public abstract String getRelativePathForURL(URL var1);

    public final Object getService(Object object) {
        Object v = this._services.get(object);
        if (v == _UNSET_VALUE) {
            return null;
        }
        if (v != null) {
            return v;
        }
        for (ServiceProvider serviceProvider : this._serviceProviders) {
            Object object2 = serviceProvider.getService(object);
            if (object2 == null) continue;
            this._services.put(object, object2);
            return object2;
        }
        this._services.put(object, _UNSET_VALUE);
        return null;
    }

    public final void registerServiceProvider(ServiceProvider serviceProvider) {
        this._serviceProviders.add(serviceProvider);
    }

    public Object getPreferenceValue(Preference preference) {
        return this._preferenceManager.getPreferenceValue(preference);
    }

    public void setPreferenceValue(Preference preference, Object object) {
        this._preferenceManager.setPreferenceValue(preference, object);
        this.getPreferenceManager().storePreferenceManagerToDisk();
    }

    public void addPreferenceChangeListener(PropertyChangeListener propertyChangeListener) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PrefChange: added listener to {0}: {1}", new Object[]{this, propertyChangeListener});
        }
        this._prefChangeListenerManager.addListener(propertyChangeListener);
    }

    public void removePreferenceChangeListener(PropertyChangeListener propertyChangeListener) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PrefChange: removed listener from {0}: {1}", new Object[]{this, propertyChangeListener});
        }
        this._prefChangeListenerManager.removeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl = this._propertyChangeListeners.add(propertyChangeListener);
        if (!bl) {
            throw new IllegalStateException("No adding the same listener twice:" + propertyChangeListener);
        }
        this._propertyChangeListenersList = null;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl = this._propertyChangeListeners.remove(propertyChangeListener);
        if (!bl) {
            throw new IllegalStateException("No removing listeners that were never added:" + propertyChangeListener);
        }
        this._propertyChangeListenersList = null;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String getHelpTopic(Node node, XmlKey xmlKey) {
        return null;
    }

    public Set getCurrentTechnologyKeys() {
        return Collections.EMPTY_SET;
    }

    public String getTranslatedString(String string) {
        ResourceBundle resourceBundle = this.getBundle();
        if (resourceBundle != null) {
            try {
                String string2;
                String string3 = string2 = resourceBundle.getString(string);
                return string3;
            }
            catch (MissingResourceException missingResourceException) {
                this.getLogger().log(Level.SEVERE, "Could not find resource key:" + string + " in bundle:" + resourceBundle);
            }
        }
        return "??" + string + "??";
    }

    public void ensureXmlModelIsSynchronized() {
        this.getModel().acquireReadLock();
        this.getModel().releaseReadLock();
    }

    public final AbstractModel getActiveAbstractModel() {
        XmlView xmlView = this.getActiveView();
        if (xmlView != null) {
            return xmlView;
        }
        return this.getModel();
    }

    public XmlView getActiveView() {
        return this._activeView;
    }

    public void setActiveView(XmlView xmlView) {
        XmlView xmlView2 = this._activeView;
        this._activeView = xmlView;
        this.firePropertyChange(ACTIVE_VIEW_PROPERTY, xmlView2, xmlView);
    }

    public final XmlView getExistingView(XmlUsage xmlUsage) {
        return (XmlView)this._views.get(xmlUsage);
    }

    public final XmlView getView(XmlUsage xmlUsage) {
        XmlView xmlView = this.getExistingView(xmlUsage);
        if (xmlView != null) {
            return xmlView;
        }
        XmlView xmlView2 = null;
        Iterator iterator = this._viewFactories.iterator();
        XmlModel xmlModel = xmlUsage.useSourceModel() ? this.getSourceModel() : this.getModel();
        while (xmlView2 == null && iterator.hasNext()) {
            XmlViewFactory xmlViewFactory = (XmlViewFactory)iterator.next();
            xmlView2 = xmlViewFactory.createView(xmlModel, xmlUsage);
        }
        if (xmlView2 == null) {
            xmlView2 = this.__getIdentityView(xmlModel);
        }
        this._views.put(xmlUsage, xmlView2);
        xmlView2 = this._initializeViewIfNecessary(xmlModel, xmlView2);
        if (xmlView2 == null) {
            this._views.remove(xmlUsage);
        } else {
            XmlView xmlView3 = xmlView2;
            this.deliverLifecycleEvent(new 2(this, xmlUsage, xmlView3));
        }
        return xmlView2;
    }

    public void registerViewFactory(XmlViewFactory xmlViewFactory) {
        if (xmlViewFactory != null && !this._viewFactories.contains(xmlViewFactory)) {
            this._viewFactories.addFirst(xmlViewFactory);
        }
    }

    public final ClipboardManager getClipboardManager() {
        return this._clipboardManager;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void showErrorMessage(String string) {
        this.showErrorMessage(string, null, null);
    }

    public void showErrorMessage(String string, String string2, Throwable throwable) {
        this.getLogger().log(Level.WARNING, string, throwable);
    }

    public NodeCreator getDefaultNodeCreator(XmlKey xmlKey) {
        return null;
    }

    public NodeCustomizer getDefaultNodeCustomizer(XmlKey xmlKey) {
        return null;
    }

    public final void dispose() {
        this.deliverLifecycleEvent(new 1());
        this.disposeImpl();
    }

    public final void addLifecycleListener(XmlContextLifecycleListener xmlContextLifecycleListener) {
        this._lifecycleListeners.addListener(xmlContextLifecycleListener);
    }

    public final void removeLifecycleListener(XmlContextLifecycleListener xmlContextLifecycleListener) {
        this._lifecycleListeners.removeListener(xmlContextLifecycleListener);
    }

    public final DataTransferPluginRegistry getDataTransferPluginRegistry() {
        return this._dataTransferPluginRegistry;
    }

    public final TransactionToken getTransactionToken() {
        this._sourceModel.__verifyLock();
        return this._token;
    }

    public final void setTransactionToken(TransactionToken transactionToken) {
        this._requireInTransaction();
        if (transactionToken != this._token) {
            if (!(transactionToken == null ^ this._token == null)) {
                throw new IllegalStateException("tried to change token from " + this._token + " to " + transactionToken);
            }
            this._token = transactionToken;
            if (this._token != null) {
                this._token.setOwnerIfUnset(this);
                String string = !this._currUndoableEdits.isEmpty() ? ((UndoableEdit)this._currUndoableEdits.get(0)).getPresentationName() : this._sourceModel.getDomModel().getTransactionDescription();
                this._token.setNameIfUnset(string);
            }
        }
    }

    public TransactionToken createTransactionToken() {
        return null;
    }

    public RefInfoResolver getRefInfoResolver() {
        if (this._refInfoResolver == null) {
            this._refInfoResolver = this.createRefInfoResolver();
        }
        return this._refInfoResolver;
    }

    public void registerGlobalContextualActionProvider(ContextualActionProvider contextualActionProvider) {
        this._globalContextualActionProviders.addListener(contextualActionProvider);
    }

    public Iterator getGlobalContextualActionProviders() {
        return this._globalContextualActionProviders.iterator();
    }

    public final URL getBaseUrl(Object object, Node node) {
        if (object == null) {
            throw new IllegalArgumentException("null base type");
        }
        return this.getBaseUrlImpl(object, node);
    }

    protected void modelAttachmentComplete() {
        this.getClipboardManager().addFlavorListener(this._listenerImpls);
    }

    protected void disposeImpl() {
        DomModel domModel = this.getModel().getDomModel();
        DomModel domModel2 = this.getModel().getDomModel();
        domModel.dispose();
        if (domModel2 != domModel) {
            domModel2.dispose();
        }
        this._prefChangeListenerManager.dispose();
        this.getClipboardManager().removeFlavorListener(this._listenerImpls);
        this.getModel().__removeUndoableEditListener(this._listenerImpls);
        if (this._refInfoResolver != null) {
            this._refInfoResolver.dispose(this);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        Object object2;
        if (propertyChangeEvent.getPropertyName() != null && ((object2 = propertyChangeEvent.getOldValue()) == (object = propertyChangeEvent.getNewValue()) || object2 != null && object2.equals(object))) {
            return;
        }
        this._deliverPropertyChange(propertyChangeEvent);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (object != null && object == object2) {
            return;
        }
        this.firePropertyChange(new PropertyChangeEvent(this, string, object, object2));
    }

    protected final DomModel createDomModel(XmlModel xmlModel) {
        if (xmlModel == this._sourceModel) {
            return this.createSourceDomModel(xmlModel);
        }
        if (!$assertionsDisabled && xmlModel != this._flattenedModel) {
            throw new AssertionError();
        }
        return new SynchronizedDomModel(this._sourceModel.getDomModel());
    }

    protected abstract DomModel createSourceDomModel(XmlModel var1);

    protected ResourceBundle getBundle() {
        return this._bundle;
    }

    protected ResourceBundle createBundle() {
        return this.createBundle("oracle.bali.xml.model.resource.XmlModelBundle");
    }

    protected final ResourceBundle createBundle(String string) {
        Locale locale = this.getLocale();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
            return resourceBundle;
        }
        catch (MissingResourceException missingResourceException) {
            this.getLogger().log(Level.SEVERE, "Could not load Context Bundle:" + string, missingResourceException);
            ResourceBundle resourceBundle = null;
            return resourceBundle;
        }
    }

    protected Logger createLogger() {
        Logger logger = Logger.getLogger("oracle.bali.xml.model");
        return logger;
    }

    protected GrammarProvider createGrammarProvider() {
        return new XmlInstanceGrammarProvider();
    }

    protected GrammarResolver createGrammarResolver() {
        return new GrammarResolver(this.getGrammarProvider());
    }

    protected void addAction(Action action) {
        this._actionManager.manageAction(action);
    }

    protected ClipboardManager getUnderlyingClipboardManager() {
        return _STANDALONE_CLIPBOARD_MANAGER;
    }

    protected XmlPreferenceManager createPreferenceManager(String string) {
        return new XmlPreferenceManager();
    }

    protected void initOperations() {
        this.getOperationManager().registerOperationFactory(new StandardOperationFactory());
    }

    protected void initActions() {
        this.addAction(new ClearAction(this.getTranslatedString("CLEAR_ACTION")));
        this.addAction(new CutAction(this.getTranslatedString("CUT_ACTION")));
        this.addAction(new CopyAction(this.getTranslatedString("COPY_ACTION")));
        this.addAction(new DuplicateAction(this.getTranslatedString("DUPLICATE_ACTION")));
        this.addAction(new PasteAction(this.getTranslatedString("PASTE_ACTION")));
        this.addAction(new XmlCustomizeAction());
    }

    protected boolean isSomethingShowing() {
        return true;
    }

    /*
     * Exception decompiling
     */
    protected final void deliverLifecycleEvent(LifecycleEventDeliverer var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final void revalidateIfNeeded() {
        XmlModel xmlModel = this.getModel();
        XmlModel xmlModel2 = this.getSourceModel();
        xmlModel.__revalidateOnThreadIfNeeded();
        if (xmlModel != xmlModel2) {
            xmlModel2.__revalidateOnThreadIfNeeded();
        }
    }

    protected RefInfoResolver createRefInfoResolver() {
        return new IntrospectionRefInfoResolver();
    }

    protected URL getBaseUrlImpl(Object object, Node node) {
        return null;
    }

    final void __startTransaction(AbstractModel abstractModel, String string) {
        this._sourceModel.__startTransaction(string);
        if (this._sourceModel != this._flattenedModel) {
            try {
                this._flattenedModel.__startTransaction(string);
            }
            catch (Throwable throwable) {
                this._sourceModel.__rollbackTransaction();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException("Exception starting flattenedModel transaction", throwable);
            }
        }
        if (this._transactionOwners.isEmpty()) {
            this._token = null;
        } else if (this._token != null) {
            this._token.setNameIfUnset(string);
        }
        this._pushTransactionOwner(abstractModel);
    }

    final XmlCommitException __precommitTransaction(AbstractModel abstractModel) {
        this._checkTransactionOwner(abstractModel);
        XmlCommitException xmlCommitException = this._sourceModel.__precommitTransaction();
        if (this._sourceModel != this._flattenedModel && xmlCommitException == null) {
            xmlCommitException = this._flattenedModel.__precommitTransaction();
        }
        return xmlCommitException;
    }

    final boolean __commitTransaction(AbstractModel abstractModel, boolean bl) throws XmlCommitException {
        XmlCommitException xmlCommitException = this.__precommitTransaction(abstractModel);
        if (bl && xmlCommitException != null) {
            XmlModel xmlModel = xmlCommitException.getSource();
            String string = xmlModel.getDomModel().getTransactionDescription();
            String string2 = xmlModel.getTranslatedString("XML_MODEL_INVALID.TRANSACTION_MESSAGE_FORMAT");
            String string3 = FastMessageFormat.formatMessage(string2, string);
            String string4 = xmlModel.getTranslatedString("XML_MODEL_INVALID.TRANSACTION_DESC_FORMAT");
            String string5 = FastMessageFormat.formatMessage(string4, string);
            this.showErrorMessage(string3, string5, xmlCommitException);
            throw xmlCommitException;
        }
        this._sourceModel.__acquireWriteLock();
        try {
            this._sourceModel.__commitTransaction();
            if (this._sourceModel != this._flattenedModel) {
                this._flattenedModel.__commitTransaction();
            }
            this._popTransactionOwner();
            if (!this._sourceModel.isInTransaction()) {
                this._deliverCurrUndoableEditEventIfNeeded();
            }
        }
        finally {
            this._sourceModel.__releaseWriteLock();
        }
        return xmlCommitException == null;
    }

    final void __rollbackTransaction(AbstractModel abstractModel) {
        this._checkTransactionOwner(abstractModel);
        this._sourceModel.__acquireWriteLock();
        try {
            this._sourceModel.__rollbackTransaction();
            if (this._sourceModel != this._flattenedModel) {
                this._flattenedModel.__rollbackTransaction();
            }
            this._popTransactionOwner();
            if (this._transactionOwners.isEmpty()) {
                this._token = null;
            }
        }
        finally {
            this._sourceModel.__releaseWriteLock();
        }
    }

    final XmlView __getIdentityView(XmlModel xmlModel) {
        return this.__getIdentityView(xmlModel, false, true);
    }

    final XmlView __getIdentityView(XmlModel xmlModel, boolean bl, boolean bl2) {
        IdentityView identityView;
        int n = 0;
        if (xmlModel != this.getModel()) {
            if (xmlModel == this.getSourceModel()) {
                n += 4;
            } else {
                throw new IllegalArgumentException("Unknown model:" + xmlModel);
            }
        }
        if (bl) {
            n += 2;
        }
        if (bl2) {
            ++n;
        }
        if ((identityView = this._identityViews[n]) == null) {
            this._identityViews[n] = identityView = new IdentityView(bl, bl2);
        }
        return identityView;
    }

    void __referencesChanged(List list, List list2) {
        this.getRefInfoResolver().referencesChanged(this, list, list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _mapNodeToDocument(Document document, Node node) {
        if (document == null) {
            return null;
        }
        List list = this._mappingList;
        synchronized (list) {
            List list2 = DomUtils.getNodePath((Node)node, (List)this._mappingList);
            int n = list2.size();
            if (n == 0) {
                Node node2 = null;
                return node2;
            }
            int n2 = n - 1;
            Node node3 = (Node)list2.get(n2);
            Document document2 = node3.getOwnerDocument();
            if (document2 == document) {
                if (DomUtils.isInDocumentHierarchy((Node)node3)) {
                    Node node4 = node3;
                    return node4;
                }
                ListIterator listIterator = list2.listIterator(n2);
                while (listIterator.hasPrevious()) {
                    Node node5 = (Node)listIterator.previous();
                    if (!DomUtils.isInDocumentHierarchy((Node)node5)) continue;
                    Node node6 = node5;
                    return node6;
                }
                Node node7 = null;
                return node7;
            }
            Node node8 = document;
            Node node9 = node8;
            for (Node node10 : list2) {
                int n3 = DomUtils.getChildIndex((Node)node10);
                if ((node9 = node9.getChildNodes().item(n3)) == null) break;
                short s = node9.getNodeType();
                if (node10.getNodeType() != s) break;
                if (s == 1) {
                    String string;
                    String string2 = DomUtils.getLocalName((Node)node9);
                    if (!string2.equals(string = DomUtils.getLocalName((Node)node10))) break;
                    String string3 = node9.getNamespaceURI();
                    String string4 = node10.getNamespaceURI();
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (string4 == null) {
                        string4 = "";
                    }
                    if (!string3.equals(string4)) break;
                }
                node8 = node9;
            }
            Document document3 = node8;
            return document3;
        }
    }

    private void _deliverPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        List list = this._getPropertyChangeListenersList();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)list.get(n2);
            try {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            catch (Throwable throwable) {
                this.getLogger().log(Level.INFO, "Unexpected throwable in listener:" + propertyChangeListener, throwable);
            }
            ++n2;
        }
    }

    private List _getPropertyChangeListenersList() {
        if (this._propertyChangeListenersList == null) {
            this._propertyChangeListenersList = new ArrayList(this._propertyChangeListeners);
        }
        return this._propertyChangeListenersList;
    }

    private XmlView _initializeViewIfNecessary(XmlModel xmlModel, XmlView xmlView) {
        if (xmlView.getBaseModel() == null) {
            xmlModel.acquireReadLock();
            try {
                try {
                    xmlView.__attachBaseModel(xmlModel);
                    xmlView.baseModelAttached();
                    xmlView.postAttachmentHook();
                    xmlView.__initializationComplete();
                    xmlView.postCreationHook();
                }
                catch (Throwable throwable) {
                    this.getLogger().log(Level.SEVERE, "View creation failed for " + xmlView, throwable);
                    xmlView = null;
                }
            }
            finally {
                xmlModel.releaseReadLock();
            }
        }
        return xmlView;
    }

    private final void _setFlattenedModel(XmlModel xmlModel) {
        block5: {
            if (this._bundle == null) {
                throw new IllegalStateException("finishInitialization() not called on constructed XmlContext instance");
            }
            if (xmlModel == null) {
                throw new IllegalArgumentException("No XmlModel specified");
            }
            if (this._flattenedModel != null) {
                throw new IllegalStateException("Can not set model on context twice!");
            }
            this._flattenedModel = xmlModel;
            try {
                this._initializeModel(xmlModel);
            }
            catch (Throwable throwable) {
                this._flattenedModel = null;
                LogRecord logRecord = new LogRecord(Level.SEVERE, "Exception thrown when initializing model:" + xmlModel);
                logRecord.setThrown(throwable);
                this.getLogger().log(logRecord);
                if (!(throwable instanceof RuntimeException)) break block5;
                throw (RuntimeException)throwable;
            }
        }
    }

    private void _setSourceModel(XmlModel xmlModel) {
        block4: {
            if (xmlModel == null) {
                throw new IllegalArgumentException("No XmlModel specified");
            }
            if (this._sourceModel != null) {
                throw new IllegalStateException("Can not set model on context twice!");
            }
            this._sourceModel = xmlModel;
            try {
                this._initializeModel(xmlModel);
            }
            catch (Throwable throwable) {
                this._sourceModel = null;
                LogRecord logRecord = new LogRecord(Level.SEVERE, "Exception thrown when initializing model:" + xmlModel);
                logRecord.setThrown(throwable);
                this.getLogger().log(logRecord);
                if (!(throwable instanceof RuntimeException)) break block4;
                throw (RuntimeException)throwable;
            }
        }
    }

    private void _deliverCurrUndoableEditEventIfNeeded() {
        this._sourceModel.__verifyWriteLock();
        if (!this._currUndoableEdits.isEmpty()) {
            UndoableEdit undoableEdit = MultiUndoableEdit.createEdit(this._currUndoableEdits);
            this._currUndoableEdits.clear();
            if (undoableEdit != null) {
                this._deliverUndoableEditEvent(new UndoableEditEvent(this, undoableEdit));
            }
        }
        TransactionToken.dispatch(this._token, this, true);
        this._token = null;
    }

    private void _deliverUndoableEditEvent(UndoableEditEvent undoableEditEvent) {
        Iterator iterator = this._undoListeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((UndoableEditListener)iterator.next()).undoableEditHappened(undoableEditEvent);
            }
            catch (Throwable throwable) {
                this.getLogger().log(Level.WARNING, "Unexpected exception when delivering UndoableEditEvent", throwable);
            }
        }
    }

    protected void flushPendingEvents() {
        this._sourceModel.__acquireWriteLock();
        try {
            XmlModel xmlModel = this.getSourceModel();
            XmlModel xmlModel2 = this.getModel();
            xmlModel.__deliverPendingXmlModelEventIfNeeded();
            if (xmlModel != xmlModel2) {
                xmlModel2.__deliverPendingXmlModelEventIfNeeded();
            }
            this._deliverCurrUndoableEditEventIfNeeded();
        }
        finally {
            this._sourceModel.__releaseWriteLock();
        }
    }

    private void _checkTransactionOwner(AbstractModel abstractModel) {
        AbstractModel abstractModel2;
        this._sourceModel.__verifyLock();
        int n = this._transactionOwners.size() - 1;
        if (_sSaveTransactionStackTraces) {
            --n;
        }
        if (abstractModel != (abstractModel2 = (AbstractModel)this._transactionOwners.get(n))) {
            String string;
            String string2 = string = "Transaction owner mismatch for transaction. Expected transaction owner:" + abstractModel2 + " not " + abstractModel + ". ";
            if (_sSaveTransactionStackTraces) {
                StringBuffer stringBuffer = new StringBuffer(1000);
                int n2 = ++n;
                while (n2 >= 0) {
                    Throwable throwable = (Throwable)this._transactionOwners.get(n2);
                    AbstractModel abstractModel3 = (AbstractModel)this._transactionOwners.get(--n2);
                    stringBuffer.append("\nOwner:");
                    stringBuffer.append(abstractModel3);
                    stringBuffer.append("\nStarted at:");
                    StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                    int n3 = stackTraceElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        stringBuffer.append(stackTraceElementArray[n4]);
                        stringBuffer.append('\n');
                        ++n4;
                    }
                    --n2;
                }
                stringBuffer.insert(0, string2);
                string2 = stringBuffer.toString();
            } else {
                string2 = string2 + "\nTo get stack traces of all current transactions, rerun the application with '-Doracle.bali.xml.transactionStacks=true'\n";
            }
            IllegalStateException illegalStateException = new IllegalStateException(string);
            this.getLogger().log(Level.SEVERE, string2, illegalStateException);
            throw illegalStateException;
        }
    }

    private void _pushTransactionOwner(AbstractModel abstractModel) {
        this._sourceModel.__verifyWriteLock();
        this._transactionOwners.add(abstractModel);
        if (_sSaveTransactionStackTraces) {
            this._transactionOwners.add(new Exception("Transaction start stack trace"));
        }
    }

    private void _popTransactionOwner() {
        this._sourceModel.__verifyWriteLock();
        int n = this._transactionOwners.size() - 1;
        if (_sSaveTransactionStackTraces) {
            this._transactionOwners.remove(n);
            --n;
        }
        this._transactionOwners.remove(n);
    }

    private void _requireInTransaction() {
        this._sourceModel.__verifyWriteLock();
        if (!this._sourceModel.isInTransaction()) {
            throw new IllegalStateException("must be in transaction!");
        }
    }

    void $init$() {
        this._listenerImpls = new ListenerImpls(null);
        this._identityViews = new IdentityView[8];
        this._token = null;
        this._propertyChangeListeners = new HashSet(5);
        this._views = new HashMap();
        this._serviceProviders = new LinkedList();
        this._services = new HashMap(5);
        this._lifecycleListeners = new SafeListenerManager();
        this._mappingList = new ArrayList(20);
        this._propertyChangeListenersList = null;
        this._transactionOwners = new ArrayList(10);
        this._undoListeners = new SafeListenerManager();
        this._dataTransferPluginRegistry = new DataTransferPluginRegistry();
        this._currUndoableEdits = new ArrayList(3);
        this._opManager = new OperationManager(this);
        this._globalContextualActionProviders = new SafeListenerManager();
    }

    static XmlModel ra$_sourceModel(XmlContext xmlContext) {
        return xmlContext._sourceModel;
    }

    static XmlModel ra$_flattenedModel(XmlContext xmlContext) {
        return xmlContext._flattenedModel;
    }

    static List ra$_currUndoableEdits(XmlContext xmlContext) {
        return xmlContext._currUndoableEdits;
    }

    static Object ra$_UNSET_VALUE() {
        return _UNSET_VALUE;
    }

    public final class 2
    implements LifecycleEventDeliverer {
        private final /* synthetic */ XmlUsage v$usage;
        private final /* synthetic */ XmlView v$view;
        final /* synthetic */ XmlContext this$0;

        public void deliverToListener(XmlContextLifecycleListener xmlContextLifecycleListener) {
            xmlContextLifecycleListener.postViewSetup(this.v$usage, this.v$view);
        }

        public 2(XmlContext xmlContext, XmlUsage xmlUsage, XmlView xmlView) {
            this.v$view = xmlView;
            this.v$usage = xmlUsage;
            this.this$0 = xmlContext;
        }
    }

    public final class 1
    implements LifecycleEventDeliverer {
        public void deliverToListener(XmlContextLifecycleListener xmlContextLifecycleListener) {
            xmlContextLifecycleListener.preContextDisposal(XmlContext.this);
        }
    }

    protected static interface LifecycleEventDeliverer {
        public void deliverToListener(XmlContextLifecycleListener var1);
    }

    private static class PreferenceChangeListenersManager
    implements PropertyChangeListener {
        private final SafeListenerManager _listeners;
        private final XmlPreferenceManager _prefManager;
        private final WeakReference _weakContext;
        private boolean _isAttached;
        private static final Logger _LOGGER = Logger.getLogger(PreferenceChangeListenersManager.class.getName());

        PreferenceChangeListenersManager(XmlContext xmlContext) {
            this.$init$();
            this._weakContext = new WeakReference<XmlContext>(xmlContext);
            this._prefManager = xmlContext.getPreferenceManager();
        }

        public synchronized void addListener(PropertyChangeListener propertyChangeListener) {
            if (!this._isAttached) {
                this._prefManager.addPreferenceChangeListener((PropertyChangeListener)this);
                this._isAttached = true;
            }
            this._listeners.addListener(propertyChangeListener);
            this._debugListeners();
        }

        public synchronized void removeListener(PropertyChangeListener propertyChangeListener) {
            this._listeners.removeListener(propertyChangeListener);
            if (this._listeners.isEmpty()) {
                this.dispose();
            }
            this._debugListeners();
        }

        public synchronized void dispose() {
            if (this._isAttached) {
                this._prefManager.removePreferenceChangeListener((PropertyChangeListener)this);
                this._isAttached = false;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            XmlContext xmlContext = (XmlContext)this._weakContext.get();
            if (xmlContext == null) {
                this.dispose();
            } else {
                Iterator iterator = this._listeners.iterator();
                while (iterator.hasNext()) {
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator.next();
                    try {
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        LogUtils.log((Logger)_LOGGER, (Level)Level.SEVERE, (String)"Exception notifiying preference listener {0}", (Object)propertyChangeListener, (Throwable)throwable);
                    }
                }
            }
        }

        private void _debugListeners() {
            if (_LOGGER.isLoggable(Level.FINE)) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = this._listeners.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(" ");
                    stringBuffer.append(iterator.next());
                }
                _LOGGER.log(Level.FINE, "Preference listeners for {0}:{1}", new Object[]{this._weakContext.get(), stringBuffer});
            }
        }

        void $init$() {
            this._listeners = new SafeListenerManager();
            this._isAttached = false;
        }
    }

    private class ListenerImpls
    implements UndoableEditListener,
    ChangeListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        public void stateChanged(ChangeEvent changeEvent) {
            if (!XmlContext.this.getSourceModel().isInTransaction()) {
                XmlContext.this.firePropertyChange(XmlContext.CLIPBOARD_FLAVORS_PROPERTY, null, XmlContext.ra$_UNSET_VALUE());
            }
        }

        static {
            $assertionsDisabled = ListenerImpls.class.desiredAssertionStatus() ^ true;
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            Object object = undoableEditEvent.getSource();
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            if (object == XmlContext.ra$_sourceModel(XmlContext.this) || object == XmlContext.ra$_flattenedModel(XmlContext.this)) {
                XmlContext.ra$_currUndoableEdits(XmlContext.this).add(undoableEdit);
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("unexpected undo source for:" + undoableEditEvent));
            }
        }

        private ListenerImpls() {
        }

        ListenerImpls(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

