/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.io.IOException;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.ValidationHandler;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.sax.StringCaptureXmlFilter;
import oracle.bali.xml.sax.TreeWalkerXmlReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlInvalidOnCommitException
extends XmlCommitException {
    public XmlInvalidOnCommitException(XmlModel xmlModel, ValidationHandler validationHandler) {
        this(xmlModel, validationHandler, true);
    }

    public XmlInvalidOnCommitException(XmlModel xmlModel, ValidationHandler validationHandler, boolean bl) {
        super(xmlModel, XmlInvalidOnCommitException._createMessage(xmlModel, validationHandler, bl), null);
    }

    private static String _getInvalidSubtree(XmlModel xmlModel, Node node) {
        if (node == null) {
            node = xmlModel.getDocument();
        }
        if (node.getNodeType() == 9 && (node = ((Document)node).getDocumentElement()) == null) {
            return xmlModel.getTranslatedString("XML_MODEL_INVALID.NO_ROOT_REASON");
        }
        TreeWalker treeWalker = DomUtils.createTreeWalker((Node)node, (int)-1, null, (TreeTraversal)xmlModel.getTreeTraversal());
        TreeWalkerXmlReader treeWalkerXmlReader = new TreeWalkerXmlReader(treeWalker);
        StringCaptureXmlFilter stringCaptureXmlFilter = new StringCaptureXmlFilter((XMLReader)treeWalkerXmlReader, false);
        try {
            stringCaptureXmlFilter.parse("ignored");
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return stringCaptureXmlFilter.getXMLSource();
    }

    private static String _createMessage(XmlModel xmlModel, ValidationHandler validationHandler, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(validationHandler.toString());
        if (bl) {
            stringBuffer.append("\n\n");
            Node node = XmlInvalidOnCommitException._getCommonAncestor(validationHandler);
            if (node != null) {
                stringBuffer.append(XmlInvalidOnCommitException._getInvalidSubtree(xmlModel, node));
            }
        }
        return stringBuffer.toString();
    }

    private static Node _getCommonAncestor(ValidationHandler validationHandler) {
        Node node;
        Node node2 = null;
        for (XmlModelMessage xmlModelMessage : validationHandler.getMessages()) {
            Node node3 = xmlModelMessage.getRelatedNode();
            if (node3 == null) continue;
            if (node3.getNodeType() == 2) {
                node3 = ((Attr)node3).getOwnerElement();
            }
            node2 = node2 == null ? node3 : DomUtils.lowestCommonAncestor((Node)node2, (Node)node3);
        }
        if (node2 != null && (node = node2.getParentNode()) != null) {
            node2 = node;
        }
        return node2;
    }
}

