/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.GlobalNodeTypeKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.share.ImmutableFilteredCollection;
import oracle.bali.xml.util.XmlKeyDisplayNameComparator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlMetadataUtils {
    private XmlMetadataUtils() {
    }

    public static Map buildNsDisplayNameMap(XmlMetadataResolver xmlMetadataResolver, Collection collection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : collection) {
            String string2 = xmlMetadataResolver.getShortDisplayName(ImmutableXmlKey.createNamespaceKey((String)string));
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    public static Map getCreatableChildrenMap(AbstractModel abstractModel, DomPosition domPosition) {
        return XmlMetadataUtils.groupKeysByNamespace(abstractModel, abstractModel.getXmlMetadataResolver().getCreateableChildrenXmlKeys(domPosition));
    }

    public static Map groupKeysByNamespace(AbstractModel abstractModel, Collection collection) {
        if (collection == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, ArrayList<XmlKey>> hashMap = new HashMap<String, ArrayList<XmlKey>>();
        for (XmlKey xmlKey : collection) {
            String string = xmlKey.getNodeType() != 1 ? "XML" : xmlKey.getTargetNamespace();
            ArrayList<XmlKey> arrayList = (ArrayList<XmlKey>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<XmlKey>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(xmlKey);
        }
        if (hashMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        TreeMap<Object, List> treeMap = new TreeMap<Object, List>(Collator.getInstance(abstractModel.getContext().getLocale()));
        XmlMetadataResolver xmlMetadataResolver = abstractModel.getXmlMetadataResolver();
        XmlKeyDisplayNameComparator xmlKeyDisplayNameComparator = new XmlKeyDisplayNameComparator(xmlMetadataResolver);
        abstractModel.acquireReadLock();
        try {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = "XML".equals(string) ? string : xmlMetadataResolver.getMediumDisplayName(ImmutableXmlKey.createNamespaceKey((String)string));
                List list = (List)entry.getValue();
                Collections.sort(list, xmlKeyDisplayNameComparator);
                treeMap.put(string2, list);
            }
        }
        finally {
            abstractModel.releaseReadLock();
        }
        return treeMap;
    }

    public static boolean isPossibleSurround(AbstractModel abstractModel, Node[] nodeArray, XmlKey xmlKey) {
        if (xmlKey.getNodeType() != 1) {
            return false;
        }
        XmlMetadataResolver xmlMetadataResolver = abstractModel.getXmlMetadataResolver();
        abstractModel.acquireReadLock();
        try {
            int n = 0;
            while (n < nodeArray.length) {
                if (!xmlMetadataResolver.isValidInsertion(xmlKey, nodeArray[n])) {
                    boolean bl = false;
                    abstractModel.releaseReadLock();
                    return bl;
                }
                ++n;
            }
        }
        finally {
            abstractModel.releaseReadLock();
        }
        return true;
    }

    public static final String getNamespaceWhereKeyDefined(XmlKey xmlKey, XmlMetadataResolver xmlMetadataResolver) {
        XmlKey xmlKey2;
        ElementDef elementDef;
        AttributeDef attributeDef;
        if (xmlKey.getNodeType() == 2 && (attributeDef = (AttributeDef)xmlMetadataResolver.getGrammarComponent(xmlKey)) != null && (elementDef = (ElementDef)xmlMetadataResolver.getGrammarComponent(xmlKey2 = ImmutableXmlKey.createElementKey((List)xmlKey.getElementQNamePath()))) != null) {
            ComplexType complexType;
            ComplexType complexType2 = complexType = (ComplexType)elementDef.getType();
            String string = complexType2.getName();
            while (string != null) {
                if (complexType2.getAttributeDefs().contains(attributeDef)) {
                    complexType = complexType2;
                    complexType2 = (ComplexType)complexType2.getBaseType();
                    string = complexType2.getName();
                    continue;
                }
                return complexType.getTargetNamespace();
            }
        }
        return xmlKey.getTargetNamespace();
    }

    public static List getPositionWildcards(DomPosition domPosition, AbstractModel abstractModel) {
        Node node = domPosition.getContainerNode();
        ElementDef elementDef = (ElementDef)abstractModel.getXmlMetadataResolver().getGrammarComponent(abstractModel.getNodeXmlKey(node));
        if (elementDef != null) {
            return TypeUtils.getElementWildcards((ElementDef)elementDef);
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection getPotentialConversionTargetKeys(AbstractModel abstractModel, Node node, boolean bl) {
        XmlMetadataResolver xmlMetadataResolver = abstractModel.getXmlMetadataResolver();
        switch (node.getNodeType()) {
            case 3: {
                return XmlMetadataUtils._singleKeyIfNotHidden(xmlMetadataResolver, (XmlKey)GlobalNodeTypeKey.CDATA_SECTION_KEY);
            }
            case 4: {
                return XmlMetadataUtils._singleKeyIfNotHidden(xmlMetadataResolver, (XmlKey)GlobalNodeTypeKey.TEXT_KEY);
            }
            case 1: {
                return XmlMetadataUtils._getPotentialConversionTargetKeys(xmlMetadataResolver, (Element)node, bl);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static Collection _getPotentialConversionTargetKeys(XmlMetadataResolver xmlMetadataResolver, Element element, boolean bl) {
        Collection collection;
        XmlKey xmlKey = xmlMetadataResolver.getNodeXmlKey(element);
        if (bl) {
            DomPosition domPosition = DomPositionFactory.before((Node)element);
            collection = xmlMetadataResolver.getCreateableChildrenXmlKeys(domPosition);
        } else {
            Node node = element.getParentNode();
            if (node == null) {
                collection = Collections.EMPTY_LIST;
            } else {
                XmlKey xmlKey2 = xmlMetadataResolver.getNodeXmlKey(node);
                collection = xmlMetadataResolver.getCreateableChildrenXmlKeys(null, xmlKey2);
            }
        }
        return new ImmutableFilteredCollection(collection, new 1(xmlKey));
    }

    private static Collection _singleKeyIfNotHidden(XmlMetadataResolver xmlMetadataResolver, XmlKey xmlKey) {
        if (xmlMetadataResolver.isHidden(xmlKey)) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(xmlKey);
    }

    public static final class 1
    implements ImmutableFilteredCollection.Filter {
        private final /* synthetic */ XmlKey v$sourceKey;

        public boolean accept(Object object) {
            XmlKey xmlKey = (XmlKey)object;
            return xmlKey.getNodeType() == 1 && !this.v$sourceKey.equals((Object)xmlKey);
        }

        public 1(XmlKey xmlKey) {
            this.v$sourceKey = xmlKey;
        }
    }
}

