/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.util.CollectionUtils;
import org.w3c.dom.Node;

public final class XmlModelEvent
extends EventObject
implements Cloneable {
    public static final int NODES_ADDED_FLAG = 1;
    public static final int NODES_REMOVED_FLAG = 2;
    public static final int NODES_MOVED_FLAG = 4;
    public static final int ATTRIBUTES_CHANGED_FLAG = 8;
    public static final int CHARACTERS_CHANGED_FLAG = 16;
    public static final int PROPERTIES_CHANGED_FLAG = 32;
    public static final int SELECTIONS_ADDED_FLAG = 64;
    public static final int SELECTIONS_REMOVED_FLAG = 128;
    public static final int DOM_STRUCTURE_FLAGS = 7;
    public static final int DOM_TREE_FLAGS = 31;
    public static final int SELECTION_FLAGS = 192;
    private final AbstractModel _model;
    private Node _changeRoot;
    private int _changeFlags;
    private Map _propertyChanges;
    private Set _selectionsAdded;
    private Set _selectionsRemoved;
    private boolean _immutable;
    private List _domChanges;
    private NodeChangeDetails _details;
    private boolean _isInUndoOrRedo;

    public XmlModelEvent(AbstractModel abstractModel) {
        this(abstractModel, null, 0, null, null, null, null, null);
    }

    public XmlModelEvent(AbstractModel abstractModel, Node node, int n, Map map, Set set, Set set2, List list, NodeChangeDetails nodeChangeDetails) {
        super(abstractModel);
        this.$init$();
        if (abstractModel == null) {
            throw new IllegalArgumentException("model required");
        }
        this._model = abstractModel;
        this._details = nodeChangeDetails;
        this.setChangeRoot(node, n);
        this._setPropertyChanges(map);
        this.setSelectionsAdded(set);
        this.setSelectionsRemoved(set2);
        this.addDomChanges(list);
    }

    public AbstractModel getModel() {
        return this._model;
    }

    public void setChangeRoot(Node node, int n) {
        this._checkImmutable();
        int n2 = n & 0x1F;
        if (node != null) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Flags must be specified when updating root");
            }
            this._changeFlags |= n2;
        } else {
            this._changeFlags |= n2;
            this._changeFlags &= 0xFFFFFFFA;
        }
        this._changeRoot = node;
    }

    public Node getChangeRoot() {
        return this._changeRoot;
    }

    public int getChangeFlags() {
        return this._changeFlags;
    }

    public final boolean matchesFlags(int n) {
        return (this.getChangeFlags() & n) != 0;
    }

    public final boolean isInUndoOrRedo() {
        return this._isInUndoOrRedo;
    }

    public final void setInUndoOrRedo(boolean bl) {
        this._isInUndoOrRedo = bl;
    }

    public final boolean isSelectionChanged() {
        return this.matchesFlags(192);
    }

    public final boolean isSelectionOrRangeSelectionChanged() {
        return this.isSelectionChanged() || this.getRangeSelectionPropertyChange() != null;
    }

    public final boolean isDomAttributeChanged() {
        return this.matchesFlags(8);
    }

    public final boolean isDomStructureChanged() {
        return this.matchesFlags(7);
    }

    public final boolean isDomTreeChanged() {
        return this.matchesFlags(31);
    }

    public final boolean isPropertyChanged() {
        return this.matchesFlags(32);
    }

    public void addPropertyChanges(Map map) {
        Map map2 = PropertyChange.mergePropertyChangeMaps(this._propertyChanges, map, this._propertyChanges instanceof HashMap ? this._propertyChanges : null);
        this._setPropertyChanges(map2);
    }

    public void removePropertyChange(String string) {
        if (string == null) {
            return;
        }
        this._checkImmutable();
        if (this._propertyChanges.containsKey(string)) {
            if (CollectionUtils.isUnmodifiableMap(this._propertyChanges, 2)) {
                this._propertyChanges = new HashMap(this._propertyChanges);
            }
            try {
                this._propertyChanges.remove(string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this._propertyChanges = new HashMap(this._propertyChanges);
                this._propertyChanges.remove(string);
            }
        }
    }

    public Map getPropertyChanges() {
        return this._propertyChanges;
    }

    public final PropertyChange getPropertyChange(String string) {
        return (PropertyChange)this.getPropertyChanges().get(string);
    }

    public final boolean containsPropertyChange(String string) {
        return this.getPropertyChanges().containsKey(string);
    }

    public final PropertyChange getDomDocumentPropertyChange() {
        return this.getPropertyChange("documentChanged");
    }

    public final boolean isDomDocumentChanged() {
        return this.getDomDocumentPropertyChange() != null;
    }

    public final PropertyChange getDropLocationPropertyChange() {
        return this.getPropertyChange("dropLocation");
    }

    public final PropertyChange getCursorLocationPropertyChange() {
        return this.getPropertyChange("cursorLocation");
    }

    public final PropertyChange getRangeSelectionPropertyChange() {
        return this.getPropertyChange("rangeSelection");
    }

    public final PropertyChange getDocChangeCountPropertyChange() {
        return this.getPropertyChange("docChangeCount");
    }

    public final PropertyChange getReadOnlyPropertyChange() {
        return this.getPropertyChange("readOnly");
    }

    public final PropertyChange getDomDocumentValidPropertyChange() {
        return this.getPropertyChange("documentValid");
    }

    public final PropertyChange getModelMessageLogPropertyChange() {
        return this.getPropertyChange("XmlModelMessageLog");
    }

    public final NodeChangeDetails getNodeChangeDetails() {
        return this._details;
    }

    public final void addNodeChangeDetails(NodeChangeDetails nodeChangeDetails) {
        if (this._details != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
            this._details = nodeChangeDetails == NodeChangeDetails.NO_DETAILS_AVAILABLE ? NodeChangeDetails.NO_DETAILS_AVAILABLE : (this._details == null ? nodeChangeDetails : this._details.addDetails(nodeChangeDetails));
        }
    }

    public List getBaseModelDomChanges() {
        return this._domChanges;
    }

    public void addDomChanges(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        boolean bl = CollectionUtils.isUnmodifiableList(this._domChanges, 0);
        if (bl) {
            List list2 = this._domChanges;
            this._domChanges = new ArrayList(list2.size() + list.size());
            this._domChanges.addAll(list2);
        }
        this._domChanges.addAll(list);
    }

    public final boolean isSelectionCleared() {
        PropertyChange propertyChange = this.getPropertyChange("selectionCleared");
        return propertyChange != null && propertyChange.getNewBooleanValue();
    }

    public void setSelectionsAdded(Set set) {
        this._checkImmutable();
        if (set != null && set.size() > 0) {
            this._selectionsAdded = set;
            this._changeFlags |= 0x40;
        } else {
            this._selectionsAdded = Collections.EMPTY_SET;
            this._changeFlags &= 0xFFFFFFBF;
        }
    }

    public Set getSelectionsAdded() {
        return this._selectionsAdded;
    }

    public void setSelectionsRemoved(Set set) {
        this._checkImmutable();
        if (set != null && set.size() > 0) {
            this._selectionsRemoved = set;
            this._changeFlags |= 0x80;
        } else {
            this._selectionsRemoved = Collections.EMPTY_SET;
            this._changeFlags &= 0xFFFFFF7F;
        }
    }

    public Set getSelectionsRemoved() {
        return this._selectionsRemoved;
    }

    public void addModelEvent(XmlModelEvent xmlModelEvent) {
        boolean bl;
        if (xmlModelEvent == null) {
            return;
        }
        this._checkImmutable();
        this._changeRoot = DomUtils.lowestCommonAncestor((Node)this._changeRoot, (Node)xmlModelEvent._changeRoot);
        this._changeFlags = this._changeFlags & 0x1F | xmlModelEvent._changeFlags & 0x1F;
        this.addPropertyChanges(xmlModelEvent._propertyChanges);
        boolean bl2 = this._selectionsAdded.isEmpty() ^ true;
        if (!xmlModelEvent._selectionsAdded.isEmpty()) {
            if (CollectionUtils.isUnmodifiableSet(this._selectionsRemoved, 2)) {
                this._selectionsRemoved = new HashSet(this._selectionsRemoved);
            }
            if (CollectionUtils.isUnmodifiableSet(this._selectionsAdded, 2)) {
                this._selectionsAdded = new HashSet(this._selectionsAdded);
            }
            this._selectionsAdded = CollectionUtils.mergeAddRemoveSets(this._selectionsAdded, xmlModelEvent._selectionsAdded, this._selectionsRemoved);
            bl = true;
        } else {
            bl = false;
        }
        if (!xmlModelEvent._selectionsRemoved.isEmpty()) {
            HashSet hashSet;
            HashSet hashSet2 = hashSet = bl2 ? this._selectionsAdded : null;
            if (!bl) {
                if (CollectionUtils.isUnmodifiableSet(this._selectionsRemoved, 2)) {
                    this._selectionsRemoved = new HashSet(this._selectionsRemoved);
                }
                if (hashSet != null && CollectionUtils.isUnmodifiableSet(hashSet, 2)) {
                    hashSet = new HashSet(hashSet);
                }
            }
            this._selectionsRemoved = CollectionUtils.mergeAddRemoveSets(this._selectionsRemoved, xmlModelEvent._selectionsRemoved, hashSet);
        }
        this.addDomChanges(xmlModelEvent.getBaseModelDomChanges());
        this.addNodeChangeDetails(xmlModelEvent.getNodeChangeDetails());
        this._updateChangeFlags();
        this._isInUndoOrRedo |= xmlModelEvent.isInUndoOrRedo();
    }

    public XmlModelEvent getMutableEvent() {
        if (this._immutable) {
            return (XmlModelEvent)this.clone();
        }
        return this;
    }

    public void prepareForDelivery() {
        if (!this._immutable) {
            this._immutable = true;
            this._updateChangeFlags();
            this._propertyChanges = CollectionUtils.createUnmodifiableMap(this._propertyChanges);
            this._selectionsAdded = CollectionUtils.createUnmodifiableSet(this._selectionsAdded);
            this._selectionsRemoved = CollectionUtils.createUnmodifiableSet(this._selectionsRemoved);
            this._domChanges = CollectionUtils.createUnmodifiableList(this._domChanges);
        }
    }

    public Object clone() {
        XmlModelEvent xmlModelEvent = null;
        try {
            xmlModelEvent = (XmlModelEvent)super.clone();
            xmlModelEvent._propertyChanges = new HashMap(this._propertyChanges);
            xmlModelEvent._selectionsAdded = new HashSet(this._selectionsAdded);
            xmlModelEvent._selectionsRemoved = new HashSet(this._selectionsRemoved);
            if (xmlModelEvent._details != null) {
                xmlModelEvent._details = xmlModelEvent._details.getCopy();
            }
            xmlModelEvent._immutable = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return xmlModelEvent;
    }

    public String toString() {
        int n;
        String string = super.toString();
        if (this._changeRoot != null) {
            string = string + "root: " + this._changeRoot;
        }
        if ((n = this._changeFlags) != 0) {
            string = string + "Changes:[";
            if ((n & 1) != 0) {
                string = string + "Nodes+,";
            }
            if ((n & 2) != 0) {
                string = string + "Nodes-,";
            }
            if ((n & 4) != 0) {
                string = string + "Nodes Moved,";
            }
            if ((n & 8) != 0) {
                string = string + "Attr+-,";
            }
            if ((n & 0x10) != 0) {
                string = string + "Chars+-,";
            }
            if ((n & 0x40) != 0) {
                string = string + "Sel+,";
            }
            if ((n & 0x80) != 0) {
                string = string + "Sel-,";
            }
            if ((n & 0x20) != 0) {
                string = string + "Prop changed,";
            }
            string = string + "]";
        }
        if (this._isInUndoOrRedo) {
            string = string + " (UNDO/REDO)";
        }
        if (!this._selectionsAdded.isEmpty()) {
            string = string + "\nselections added: " + this._selectionsAdded;
        }
        if (!this._selectionsRemoved.isEmpty()) {
            string = string + "\nselections removed: " + this._selectionsRemoved;
        }
        if (!this._propertyChanges.isEmpty()) {
            string = string + "\nproperty changes: " + this._propertyChanges.values();
        }
        if (!this._domChanges.isEmpty()) {
            string = string + "\nDOM changes: " + this._domChanges;
        }
        if (this._details != null) {
            string = string + "\nNodeChangeDetails: " + this._details;
        }
        return string;
    }

    private void _setPropertyChanges(Map map) {
        this._checkImmutable();
        this._propertyChanges = map != null && map.size() > 0 ? map : Collections.EMPTY_MAP;
        this._updatePropertyChangeFlags();
    }

    private void _checkImmutable() {
        if (this._immutable) {
            throw new IllegalStateException("No mutating event once delivered");
        }
    }

    private void _updateChangeFlags() {
        int n = this._changeFlags;
        if (this._changeRoot == null) {
            n &= 0xFFFFFFFA;
        }
        n = this._selectionsAdded.size() > 0 ? (n |= 0x40) : (n &= 0xFFFFFFBF);
        n = this._selectionsRemoved.size() > 0 ? (n |= 0x80) : (n &= 0xFFFFFF7F);
        this._changeFlags = n;
        this._updatePropertyChangeFlags();
    }

    private void _updatePropertyChangeFlags() {
        this._changeFlags = this._propertyChanges == null || this._propertyChanges.isEmpty() ? (this._changeFlags &= 0xFFFFFFDF) : (this._changeFlags |= 0x20);
    }

    void $init$() {
        this._domChanges = Collections.EMPTY_LIST;
        this._isInUndoOrRedo = false;
    }
}

