/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.action.ModelAction;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.share.BaseAction;

public class BaseModelAction
extends BaseAction
implements ModelAction {
    private AbstractModel _model;
    private volatile boolean _recalcEnabled;
    private final transient XmlModelListener _modelListener;
    private final transient PropertyChangeListener _contextListener;
    private static final Logger _LOGGER = Logger.getLogger(BaseModelAction.class.getName());

    public BaseModelAction(String string, KeyStroke keyStroke, String string2, boolean bl, boolean bl2) {
        super(StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string), keyStroke, string2, null);
        if (bl || bl2) {
            Listener listener = new Listener(null);
            this._modelListener = bl ? listener : null;
            this._contextListener = bl2 ? listener : null;
        } else {
            this._modelListener = null;
            this._contextListener = null;
        }
    }

    public boolean isActiveViewAction() {
        return false;
    }

    public final void setModel(AbstractModel abstractModel) {
        if (abstractModel != this._model) {
            if (this._contextListener != null) {
                XmlContext xmlContext;
                XmlContext xmlContext2 = this._model != null ? this._model.getContext() : null;
                XmlContext xmlContext3 = xmlContext = abstractModel != null ? abstractModel.getContext() : null;
                if (xmlContext2 != xmlContext) {
                    if (xmlContext2 != null) {
                        xmlContext2.removePropertyChangeListener(this._contextListener);
                    }
                    if (xmlContext != null) {
                        xmlContext.addPropertyChangeListener(this._contextListener);
                    }
                }
            }
            this._model = abstractModel;
            this._updateEnabled();
        }
    }

    public final AbstractModel getModel() {
        return this._model;
    }

    public XmlModelListener getModelListener() {
        return this._modelListener;
    }

    protected boolean isEnabledImpl() {
        AbstractModel abstractModel = this.getModel();
        if (abstractModel == null) {
            return false;
        }
        if (!this._mutatesModel()) {
            return true;
        }
        abstractModel.acquireReadLock();
        try {
            boolean bl = abstractModel.isReadOnly() ^ true;
            abstractModel.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            abstractModel.releaseReadLock();
            throw throwable;
        }
    }

    protected boolean needToUpdateEnabled(XmlModelEvent xmlModelEvent) {
        return true;
    }

    protected boolean needToUpdateEnabled(PropertyChangeEvent propertyChangeEvent) {
        return true;
    }

    protected final boolean needsToRespondToReadOnlyChange(XmlModelEvent xmlModelEvent) {
        return this._mutatesModel() && xmlModelEvent.getPropertyChange("readOnly") != null;
    }

    private boolean _mutatesModel() {
        return Boolean.TRUE.equals(this.getValue("XmlContext.MUTATES_MODEL"));
    }

    protected final void scheduleRecalculateEnabled(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("non-positive wait ms");
        }
        1 var2_2 = new 1(this, n);
        this._recalcEnabled = true;
        Thread thread = new Thread((Runnable)var2_2, "recalc thread for " + this.getClass());
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    private void _updateEnabled() {
        AbstractModel abstractModel = this.getModel();
        if (abstractModel != null) {
            abstractModel.acquireReadLock();
        }
        try {
            boolean bl = this.isEnabledImpl();
            this.setEnabled(bl);
            if (_LOGGER.isLoggable(Level.FINE)) {
                _LOGGER.log(Level.FINE, "setEnabled on {0} to {1}, model={2}", new Object[]{this, bl, abstractModel});
            }
        }
        finally {
            if (abstractModel != null) {
                abstractModel.releaseReadLock();
            }
        }
        if (this._recalcEnabled) {
            this._recalcEnabled = false;
        }
    }

    static boolean ra$_recalcEnabled(BaseModelAction baseModelAction) {
        return baseModelAction._recalcEnabled;
    }

    static void mav$_updateEnabled(BaseModelAction baseModelAction) {
        baseModelAction._updateEnabled();
    }

    static void wa$_recalcEnabled(BaseModelAction baseModelAction, boolean bl) {
        baseModelAction._recalcEnabled = bl;
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ int v$waitMs;
        final /* synthetic */ BaseModelAction this$0;

        public void run() {
            try {
                Thread.sleep(this.v$waitMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (BaseModelAction.ra$_recalcEnabled(this.this$0)) {
                BaseModelAction.mav$_updateEnabled(this.this$0);
            }
        }

        public 1(BaseModelAction baseModelAction, int n) {
            this.v$waitMs = n;
            this.this$0 = baseModelAction;
        }
    }

    private class Listener
    extends XmlModelAdapter
    implements PropertyChangeListener {
        public void listenerAttached(XmlModelEvent xmlModelEvent) {
            BaseModelAction.mav$_updateEnabled(BaseModelAction.this);
        }

        public void modelChanged(XmlModelEvent xmlModelEvent) {
            if (BaseModelAction.ra$_recalcEnabled(BaseModelAction.this) || BaseModelAction.this.needToUpdateEnabled(xmlModelEvent)) {
                BaseModelAction.mav$_updateEnabled(BaseModelAction.this);
            }
        }

        public void listenerDetached(XmlModelEvent xmlModelEvent) {
            BaseModelAction.mav$_updateEnabled(BaseModelAction.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (BaseModelAction.this.needToUpdateEnabled(propertyChangeEvent)) {
                if (BaseModelAction.this.getModel().getBaseModel().isInTransaction()) {
                    BaseModelAction.wa$_recalcEnabled(BaseModelAction.this, true);
                } else {
                    BaseModelAction.mav$_updateEnabled(BaseModelAction.this);
                }
            }
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

