/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.action.ModelAction;
import oracle.bali.xml.model.task.SelectionBasedTransactionTask;
import oracle.bali.xml.model.task.StandardTransactionTask;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.bali.xml.util.XmlTransferableSelectionAction;
import org.w3c.dom.Node;

public class DuplicateAction
extends XmlTransferableSelectionAction {
    private static final StandardTransactionTask _TASK = new Task(null);

    public DuplicateAction(String string) {
        super(string, KeyStroke.getKeyStroke(75, 2), "duplicate", true, false);
        this.putValue("XmlContext.MUTATES_MODEL", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this._doDuplicate(this);
        }
        catch (XmlCommitException xmlCommitException) {
            this.getModel().getLogger().log(Level.SEVERE, "Validation failed in:" + this, xmlCommitException);
        }
    }

    private void _doDuplicate(ModelAction modelAction) throws XmlCommitException {
        _TASK.runThrowingXCE(modelAction.getModel());
    }

    private static class Task
    extends SelectionBasedTransactionTask {
        protected void performTask(AbstractModel abstractModel) throws XmlCommitException {
            Collection collection = XmlModelUtils.getCloneOfSelection(abstractModel);
            if (!collection.isEmpty()) {
                abstractModel.insertNodes(DomPositionFactory.after((Node)abstractModel.getSelection().getLatestSelectedNode()), "duplicate", collection, true);
            }
        }

        protected String computeMultipleSelectionTransactionName(AbstractModel abstractModel, int n) {
            return abstractModel.getTranslatedString("DUPLICATE_DESCRIPTION_MULTIPLE");
        }

        protected String computeSingleSelectionTransactionName(AbstractModel abstractModel) {
            Node node = abstractModel.getSelection().getLatestSelectedNode();
            String string = abstractModel.getXmlMetadataResolver().getShortDisplayName(node);
            return abstractModel.getTranslatedString("DUPLICATE_DESCRIPTION_SINGULAR_FORMAT", string);
        }

        private Task() {
        }

        Task(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

