/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.action;

import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.action.BaseModelAction;
import oracle.bali.xml.model.datatransfer.operation.OperationProcessor;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferUtils;

public class PasteAction
extends BaseModelAction {
    private final OperationProcessor _processor;
    private static final Logger _LOGGER = Logger.getLogger(PasteAction.class.getName());

    public PasteAction(String string) {
        super(string, KeyStroke.getKeyStroke(86, 2), "paste", true, true);
        this.$init$();
        this.putValue("XmlContext.MUTATES_MODEL", Boolean.TRUE);
        this._processor.setActionMask(1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEnabledImpl()) {
            try {
                Action action;
                if (this._processor.hasMoreThanOneOperationWithHighestRank() && (action = this.getModel().getAction("paste_special")) != null) {
                    action.actionPerformed(actionEvent);
                    return;
                }
                this._processor.forceSimpleApply(null, this.getModel().getTranslatedString("PASTE_DESCRIPTION_MULTIPLE"));
            }
            catch (Exception exception) {
                _LOGGER.log(Level.WARNING, "Error in paste", exception);
                AbstractModel abstractModel = this.getModel();
                XmlContext xmlContext = abstractModel.getContext();
                String string = xmlContext.getTranslatedString("ErrorDuringPasteTitle");
                String string2 = xmlContext.getTranslatedString("ErrorDuringPaste");
                xmlContext.showErrorMessage(string2, string, exception);
            }
        }
    }

    public boolean isActiveViewAction() {
        return true;
    }

    protected boolean needToUpdateEnabled(XmlModelEvent xmlModelEvent) {
        return xmlModelEvent.getCursorLocationPropertyChange() != null || this.needsToRespondToReadOnlyChange(xmlModelEvent);
    }

    protected boolean needToUpdateEnabled(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        return string == null || "XmlContext.CLIPBOARD_FLAVORS".equals(string);
    }

    public boolean isEnabledImpl() {
        Transferable transferable;
        if (!super.isEnabledImpl()) {
            return false;
        }
        AbstractModel abstractModel = this.getModel();
        ClipboardManager clipboardManager = abstractModel.getContext().getClipboardManager();
        try {
            transferable = clipboardManager.getContents();
        }
        catch (IllegalStateException illegalStateException) {
            this.scheduleRecalculateEnabled(200);
            boolean bl = false;
            return bl;
        }
        if (transferable == ClipboardManager.EMPTY_CONTENTS || transferable == ClipboardManager.UNKNOWN_CONTENTS) {
            return false;
        }
        AugmentableTransferable augmentableTransferable = TransferUtils.asAugmentableTransferable((Transferable)transferable);
        abstractModel.acquireReadLock();
        try {
            this._processor.setEditable(abstractModel.isReadOnly() ^ true);
            this._processor.setTargetModel(abstractModel);
            this._processor.setTransferable((ExtendedTransferable)augmentableTransferable);
            DomPosition domPosition = abstractModel.getSelection().getCursorLocation();
            if (domPosition == null) {
                boolean bl = false;
                abstractModel.releaseReadLock();
                return bl;
            }
            this._processor.update(Collections.singletonList(domPosition));
            boolean bl = this._processor.hasSupportedOperation();
            abstractModel.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            abstractModel.releaseReadLock();
            throw throwable;
        }
    }

    protected boolean hasValidInsertoinPoint() {
        AbstractModel abstractModel = this.getModel();
        if (abstractModel == null) {
            return false;
        }
        abstractModel.acquireReadLock();
        try {
            Selection selection = abstractModel.getSelection();
            DomPosition domPosition = selection.getCursorLocation();
            if (domPosition == null) {
                boolean bl = false;
                abstractModel.releaseReadLock();
                return bl;
            }
            if (!abstractModel.getXmlMetadataResolver().canAddChild(domPosition)) {
                boolean bl = false;
                abstractModel.releaseReadLock();
                return bl;
            }
            boolean bl = true;
            abstractModel.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            abstractModel.releaseReadLock();
            throw throwable;
        }
    }

    public OperationProcessor getOperationProcessor() {
        return this._processor;
    }

    void $init$() {
        this._processor = new OperationProcessor(null);
    }
}

