/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer;

import java.awt.datatransfer.Transferable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.javatools.datatransfer.AugmentableTransferable;

public class AugmentingClipboardManager
extends ClipboardManager {
    private Reference _lastFromBaseRef;
    private Reference _lastAugmentedRef;
    private volatile transient boolean _inSetContents;
    private final ClipboardManager _base;
    private final XmlContext _context;
    private final BaseListener _baseListener;

    public AugmentingClipboardManager(XmlContext xmlContext, ClipboardManager clipboardManager) {
        this.$init$();
        this._context = xmlContext;
        this._base = clipboardManager;
    }

    public synchronized Transferable getContents() {
        Transferable transferable = this._base.getContents();
        Transferable transferable2 = (Transferable)this._deref(this._lastFromBaseRef);
        Transferable transferable3 = (Transferable)this._deref(this._lastAugmentedRef);
        if (transferable == transferable2 && transferable3 != null) {
            return transferable3;
        }
        AugmentableTransferable augmentableTransferable = XmlTransferUtils.performAugmentation(transferable, this._context);
        this._lastFromBaseRef = new SoftReference<Transferable>(transferable);
        this._lastAugmentedRef = new SoftReference<AugmentableTransferable>(augmentableTransferable);
        return augmentableTransferable;
    }

    public synchronized void setContents(Transferable transferable) throws IllegalStateException {
        if (transferable != this._deref(this._lastFromBaseRef)) {
            this._lastFromBaseRef = null;
            this._lastAugmentedRef = null;
        }
        this._inSetContents = true;
        try {
            this._base.setContents(transferable);
        }
        finally {
            this._inSetContents = false;
        }
        this.notifyFlavorListeners();
    }

    private Object _deref(Reference reference) {
        return reference == null ? null : reference.get();
    }

    protected synchronized void areFlavorListenersAttachedChanged() {
        super.areFlavorListenersAttachedChanged();
        if (this.areFlavorListenersAttached()) {
            this._base.addFlavorListener(this._baseListener);
        } else {
            this._base.removeFlavorListener(this._baseListener);
        }
    }

    void $init$() {
        this._lastFromBaseRef = null;
        this._lastAugmentedRef = null;
        this._inSetContents = false;
        this._baseListener = new BaseListener(null);
    }

    static boolean ra$_inSetContents(AugmentingClipboardManager augmentingClipboardManager) {
        return augmentingClipboardManager._inSetContents;
    }

    static void mav$notifyFlavorListeners(AugmentingClipboardManager augmentingClipboardManager) {
        augmentingClipboardManager.notifyFlavorListeners();
    }

    private class BaseListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            if (!AugmentingClipboardManager.ra$_inSetContents(AugmentingClipboardManager.this)) {
                AugmentingClipboardManager.mav$notifyFlavorListeners(AugmentingClipboardManager.this);
            }
        }

        private BaseListener() {
        }

        BaseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

