/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.task.NoNameTransactionTask;
import oracle.bali.xml.share.BogusSerializableData;
import oracle.bali.xml.share.MutableBoolean;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.share.UnmodifiableArrayList;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.DataTransferPluginRegistry;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlTransferUtils {
    public static final Object KEY_SOURCEMODEL_REF = new String("source AbstractModel reference");
    public static final Object KEY_SOURCEMODEL_CHANGE_COUNT = new String("source AbstractModel change count");
    public static final Object KEY_ORIGINAL_NODES_COLLECTION = new String("original node collection");
    public static final Object KEY_ORIGINAL_RANGE = new String("original range");
    public static final Object KEY_XMLKEY_LIST = new String("XmlKey list");
    public static final Object KEY_TARGET_HANDLED_MOVE = new String("target handled move");
    public static final Object KEY_TASK_TO_EXECUTE_AFTER_INSERTING_FRAGMENT = new String("KEY_TASK_TO_EXECUTE_AFTER_INSERTING_FRAGMENT");
    public static final DataFlavor FLAVOR_XMLKEY = TransferUtils.createLocalJvmFlavor(XmlKey.class);
    public static final DataFlavor FLAVOR_DOCUMENTFRAGMENT = TransferUtils.createLocalJvmFlavor(DocumentFragment.class);
    public static final DataFlavor FLAVOR_NODELIST = TransferUtils.createLocalJvmFlavor(NodeList.class);
    public static final DataFlavor FLAVOR_TRANSACTIONTOKEN = TransferUtils.createLocalJvmFlavor(TransactionToken.class);
    private static final int _MAX_SHORT_NAME_SIZE = 20;
    private static final int _MAX_MEDIUM_NAME_SIZE = 35;
    private static final int _MAX_LONG_NAME_SIZE = Integer.MAX_VALUE;

    public static AugmentableTransferable createXmlKeyTransferable(AbstractModel abstractModel, XmlKey xmlKey) {
        AugmentableTransferable augmentableTransferable = TransferUtils.createTransferable();
        TreeMap<Object, String> treeMap = new TreeMap<Object, String>();
        abstractModel.acquireReadLock();
        try {
            XmlMetadataResolver xmlMetadataResolver = abstractModel.getXmlMetadataResolver();
            treeMap.put(TransferDataInfo.METADATA_SHORT_DESCRIPTION, xmlMetadataResolver.getShortDisplayName(xmlKey));
            treeMap.put(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION, xmlMetadataResolver.getMediumDisplayName(xmlKey));
            treeMap.put(TransferDataInfo.METADATA_LONG_DESCRIPTION, xmlMetadataResolver.getLongDisplayName(xmlKey));
        }
        finally {
            abstractModel.releaseReadLock();
        }
        augmentableTransferable.augment(TransferUtils.createDataInfo((DataFlavor)FLAVOR_XMLKEY, (Object)xmlKey, (float)0.9f, treeMap));
        XmlTransferUtils.addBogusSerializableFlavor(augmentableTransferable);
        return augmentableTransferable;
    }

    public static AugmentableTransferable createDomNodesTransferable(AbstractModel abstractModel, Collection collection, DomRange domRange, boolean bl) {
        if (collection == null || abstractModel == null) {
            throw new IllegalArgumentException("null argument");
        }
        AugmentableTransferable augmentableTransferable = TransferUtils.createTransferable();
        DocumentFragment documentFragment = null;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(7);
        if (domRange != null) {
            hashMap.put(KEY_ORIGINAL_RANGE, domRange);
        } else {
            hashMap.put(KEY_ORIGINAL_NODES_COLLECTION, new ArrayList(collection));
        }
        if (bl) {
            hashMap.put(KEY_SOURCEMODEL_REF, new WeakReference<AbstractModel>(abstractModel));
            hashMap.put(KEY_TARGET_HANDLED_MOVE, new MutableBoolean(false));
        }
        ArrayList<XmlKey> arrayList = new ArrayList<XmlKey>(collection.size());
        hashMap.put(KEY_XMLKEY_LIST, arrayList);
        abstractModel.acquireReadLock();
        try {
            hashMap.put(KEY_SOURCEMODEL_CHANGE_COUNT, IntegerUtils.getInteger((int)abstractModel.getBaseModel().getDocChangeCount()));
            XmlMetadataResolver xmlMetadataResolver = abstractModel.getXmlMetadataResolver();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            String string = abstractModel.getTranslatedString("LIST_SEPARATOR");
            Document document = DomUtils.getScratchDocument();
            for (Node node : collection) {
                arrayList.add(abstractModel.getNodeXmlKey(node));
                if (documentFragment == null) {
                    documentFragment = document.createDocumentFragment();
                }
                documentFragment.appendChild(document.importNode(node, true));
                XmlTransferUtils._appendIfNonNull(stringBuffer, xmlMetadataResolver.getShortDisplayName(node), string);
                XmlTransferUtils._appendIfNonNull(stringBuffer2, xmlMetadataResolver.getMediumDisplayName(node), string);
                XmlTransferUtils._appendIfNonNull(stringBuffer3, xmlMetadataResolver.getLongDisplayName(node), string);
            }
            XmlTransferUtils._setBufferIfNotEmpty(hashMap, TransferDataInfo.METADATA_SHORT_DESCRIPTION, stringBuffer, 20);
            XmlTransferUtils._setBufferIfNotEmpty(hashMap, TransferDataInfo.METADATA_MEDIUM_DESCRIPTION, stringBuffer2, 35);
            XmlTransferUtils._setBufferIfNotEmpty(hashMap, TransferDataInfo.METADATA_LONG_DESCRIPTION, stringBuffer3, Integer.MAX_VALUE);
        }
        finally {
            abstractModel.releaseReadLock();
        }
        float f = 0.9f;
        if (documentFragment != null) {
            augmentableTransferable.augment(TransferUtils.createDataInfo((DataFlavor)FLAVOR_DOCUMENTFRAGMENT, (Object)documentFragment, (float)TransferUtils.lowerRank((float)f), hashMap));
        }
        XmlTransferUtils.addBogusSerializableFlavor(augmentableTransferable);
        return augmentableTransferable;
    }

    public static AugmentableTransferable createDomNodesTransferable(AbstractModel abstractModel, Collection collection, boolean bl) {
        return XmlTransferUtils.createDomNodesTransferable(abstractModel, collection, null, bl);
    }

    public static AugmentableTransferable createDomNodesTransferable(AbstractModel abstractModel, NodeList nodeList) {
        return XmlTransferUtils.createDomNodesTransferable(abstractModel, DomUtils.nodeListToList((NodeList)nodeList), true);
    }

    public static AugmentableTransferable createDomNodesTransferable(AbstractModel abstractModel, Node node) {
        return XmlTransferUtils.createDomNodesTransferable(abstractModel, Collections.singletonList(node), true);
    }

    public static AugmentableTransferable createDomNodesTransferable(AbstractModel abstractModel, Node[] nodeArray) {
        return XmlTransferUtils.createDomNodesTransferable(abstractModel, new UnmodifiableArrayList(nodeArray), true);
    }

    public static void addBogusSerializableFlavor(AugmentableTransferable augmentableTransferable) {
        augmentableTransferable.augment(TransferUtils.createDataInfo((DataFlavor)BogusSerializableData.FLAVOR, null, (float)0.0f, null));
    }

    public static String getShortDescription(AbstractModel abstractModel, Transferable transferable) {
        if (transferable instanceof ExtendedTransferable) {
            ExtendedTransferable extendedTransferable = (ExtendedTransferable)transferable;
            return extendedTransferable.getShortDescription();
        }
        return null;
    }

    public static String getMediumDescription(AbstractModel abstractModel, Transferable transferable) {
        if (transferable instanceof ExtendedTransferable) {
            ExtendedTransferable extendedTransferable = (ExtendedTransferable)transferable;
            return extendedTransferable.getMediumDescription();
        }
        return null;
    }

    public static List getXmlKeys(Transferable transferable) {
        Object object = TransferUtils.getDataIfAvailable((Transferable)transferable, (DataFlavor)FLAVOR_XMLKEY);
        if (object instanceof XmlKey) {
            return Collections.singletonList(object);
        }
        return null;
    }

    public static NodeList getNodeList(Transferable transferable) {
        Object object = TransferUtils.getDataIfAvailable((Transferable)transferable, (DataFlavor)FLAVOR_NODELIST);
        if (object instanceof NodeList) {
            return (NodeList)object;
        }
        return null;
    }

    public static TransactionToken getTransactionToken(Transferable transferable) {
        return (TransactionToken)TransferUtils.getDataIfAvailable((Transferable)transferable, (DataFlavor)FLAVOR_TRANSACTIONTOKEN, TransactionToken.class, (FetchMode)FetchMode.STANDARD);
    }

    public static AbstractModel getSourceModel(TransferDataInfo transferDataInfo) {
        Reference reference = (Reference)transferDataInfo.getMetadata(KEY_SOURCEMODEL_REF);
        return reference == null ? null : (AbstractModel)reference.get();
    }

    public static Collection getOriginalNodes(TransferDataInfo transferDataInfo) {
        return (Collection)transferDataInfo.getMetadata(KEY_ORIGINAL_NODES_COLLECTION);
    }

    public static DomRange getOriginalRange(TransferDataInfo transferDataInfo) {
        return (DomRange)transferDataInfo.getMetadata(KEY_ORIGINAL_RANGE);
    }

    public static boolean hasOriginalNodesOrRange(TransferDataInfo transferDataInfo) {
        return transferDataInfo.getMetadata(KEY_ORIGINAL_NODES_COLLECTION) != null || transferDataInfo.getMetadata(KEY_ORIGINAL_RANGE) != null;
    }

    public static void removeOriginalNodes(String string, TransferDataInfo transferDataInfo, DomRange domRange, Collection collection, TransactionToken transactionToken, boolean bl) throws XmlCommitException {
        if (domRange == null && collection == null) {
            throw new IllegalArgumentException("neither nodes nor range provided");
        }
        AbstractModel abstractModel = XmlTransferUtils.getSourceModel(transferDataInfo);
        if (abstractModel == null) {
            throw new IllegalArgumentException("data has no source model");
        }
        new 1(transactionToken, transferDataInfo, string, collection, domRange, bl).runThrowingXCE(abstractModel);
    }

    public static AugmentableTransferable performAugmentation(Transferable transferable, XmlContext xmlContext) {
        AugmentableTransferable augmentableTransferable = TransferUtils.createTransferable((Transferable)transferable);
        ArrayList<DataTransferPluginRegistry> arrayList = new ArrayList<DataTransferPluginRegistry>(2);
        arrayList.add(xmlContext.getDataTransferPluginRegistry());
        arrayList.add(DataTransferPluginRegistry.getGlobalInstance());
        DataTransferPluginRegistry.performAugmentation((AugmentableTransferable)augmentableTransferable, arrayList);
        return augmentableTransferable;
    }

    private static void _appendIfNonNull(StringBuffer stringBuffer, String string, String string2) {
        if (string != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string);
        }
    }

    private static void _setBufferIfNotEmpty(Map map, Object object, StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.length();
        if (n2 > 0 && n2 <= n) {
            map.put(object, stringBuffer.toString());
        }
    }

    private XmlTransferUtils() {
    }

    public static final class 1
    extends NoNameTransactionTask {
        private final /* synthetic */ TransactionToken v$token;
        private final /* synthetic */ TransferDataInfo v$data;
        private final /* synthetic */ String v$txnName;
        private final /* synthetic */ Collection v$originalNodes;
        private final /* synthetic */ DomRange v$range;
        private final /* synthetic */ boolean v$updateSelection;

        protected void performTask(AbstractModel abstractModel) throws XmlCommitException {
            abstractModel.getContext().setTransactionToken(this.v$token);
            int n = abstractModel.getBaseModel().getDocChangeCount();
            Integer n2 = (Integer)this.v$data.getMetadata(KEY_SOURCEMODEL_CHANGE_COUNT);
            if (n2 == null || n2 != n) {
                throw new IllegalArgumentException("wrong change count! count at transferable creation=" + n2 + " count now=" + n + " model=" + abstractModel);
            }
            XmlModelUtils.deleteNodesOrRange(abstractModel, this.v$txnName, this.v$originalNodes, this.v$range, this.v$updateSelection);
        }

        public 1(TransactionToken transactionToken, TransferDataInfo transferDataInfo, String string, Collection collection, DomRange domRange, boolean bl) {
            this.v$updateSelection = bl;
            this.v$range = domRange;
            this.v$originalNodes = collection;
            this.v$txnName = string;
            this.v$data = transferDataInfo;
            this.v$token = transactionToken;
        }
    }
}

