/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.CopyOperation;
import oracle.bali.xml.model.datatransfer.operation.DataAndPositions;
import oracle.bali.xml.model.datatransfer.operation.Operation;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.MutableBoolean;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

class MoveOperation
extends Operation {
    private final CopyOperation _copyOp;
    private static final Logger _LOGGER = Logger.getLogger(MoveOperation.class.getName());

    MoveOperation(CopyOperation copyOperation) {
        this._copyOp = copyOperation;
    }

    public List getApplicableDataAndPositions(AbstractModel abstractModel, List list, ExtendedTransferable extendedTransferable) {
        List list2 = this._copyOp.getApplicableDataAndPositions(abstractModel, list, extendedTransferable);
        if (list2.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataAndPositions> arrayList = new ArrayList<DataAndPositions>(list2.size());
        for (DataAndPositions dataAndPositions : list2) {
            TransferDataInfo transferDataInfo = dataAndPositions.getData();
            AbstractModel abstractModel2 = XmlTransferUtils.getSourceModel(transferDataInfo);
            Object object = transferDataInfo.getMetadata(XmlTransferUtils.KEY_TARGET_HANDLED_MOVE);
            if (abstractModel2 == null || !XmlTransferUtils.hasOriginalNodesOrRange(transferDataInfo) || !(object instanceof MutableBoolean)) continue;
            Collection collection = XmlTransferUtils.getOriginalNodes(transferDataInfo);
            DomRange domRange = XmlTransferUtils.getOriginalRange(transferDataInfo);
            List list3 = dataAndPositions.getPositions();
            ArrayList<DomPosition> arrayList2 = new ArrayList<DomPosition>(list3.size());
            for (DomPosition domPosition : list3) {
                if (!this._isValidPosition(abstractModel, domPosition, collection, domRange)) continue;
                arrayList2.add(domPosition);
            }
            if (arrayList2.isEmpty()) continue;
            arrayList2.trimToSize();
            arrayList.add(new DataAndPositions(transferDataInfo, arrayList2));
        }
        if (arrayList.isEmpty()) {
            throw new Operation.RejectOperatingAndDontQueryLowerRankedOps();
        }
        return arrayList;
    }

    public boolean apply(AbstractModel abstractModel, DomPosition domPosition, TransferDataInfo transferDataInfo, TransactionToken transactionToken) throws IOException, XmlCommitException {
        DocumentFragment documentFragment = (DocumentFragment)transferDataInfo.getData(FetchMode.STANDARD, false);
        AbstractModel abstractModel2 = XmlTransferUtils.getSourceModel(transferDataInfo);
        MutableBoolean mutableBoolean = (MutableBoolean)transferDataInfo.getMetadata(XmlTransferUtils.KEY_TARGET_HANDLED_MOVE);
        if (documentFragment != null && abstractModel2 != null && XmlTransferUtils.hasOriginalNodesOrRange(transferDataInfo)) {
            boolean bl;
            String string = this.getDisplayName(abstractModel, transferDataInfo);
            boolean bl2 = bl = abstractModel2.getBaseModel() == abstractModel.getBaseModel();
            if (_LOGGER.isLoggable(Level.FINE)) {
                _LOGGER.log(Level.FINE, "Move.apply: {0} at {1} ({2}), data={3}", new Object[]{string, domPosition, bl ? "internal" : "not internal", transferDataInfo});
            }
            return new 1(this, string, string, domPosition, documentFragment, transferDataInfo, transactionToken, mutableBoolean).run(abstractModel);
        }
        return false;
    }

    public String getDisplayName(AbstractModel abstractModel, TransferDataInfo transferDataInfo) {
        String string;
        String string2 = string = transferDataInfo == null ? null : (String)transferDataInfo.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (string == null) {
            return abstractModel.getTranslatedString("DragMove");
        }
        return abstractModel.getTranslatedString("DragMove_Data", string);
    }

    public float getSuitabilityRank() {
        return 0.9f;
    }

    public int getSupportedActions() {
        return 2;
    }

    private boolean _isValidPosition(AbstractModel abstractModel, DomPosition domPosition, Collection collection, DomRange domRange) {
        TreeTraversal treeTraversal = abstractModel.getTreeTraversal();
        if (domRange != null) {
            if (abstractModel.isInModelDocumentHierarchy(domRange.getStart()) && abstractModel.isInModelDocumentHierarchy(domRange.getEnd())) {
                return domRange.compareTo(treeTraversal, domPosition, true) != 0;
            }
        } else {
            Node node = domPosition.getContainerNode(treeTraversal);
            for (Node node2 : collection) {
                if (!DomUtils.isNodeOrDescendant((TreeTraversal)treeTraversal, (Node)node, (Node)node2)) continue;
                return false;
            }
            if (collection.size() == 1) {
                Node node3;
                Node node4 = (Node)collection.iterator().next();
                if (domPosition.getTargetNode() == node4) {
                    return false;
                }
                if (domPosition.isInside() && (node3 = treeTraversal.getParentNode(node4)) == node && treeTraversal.getLastChild(node3) == node4) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean _doMove(String string, AbstractModel abstractModel, DomPosition domPosition, DocumentFragment documentFragment, TransferDataInfo transferDataInfo, TransactionToken transactionToken) throws XmlCommitException {
        DomPosition domPosition2;
        DomPosition domPosition3;
        XmlView xmlView;
        DomPosition domPosition4;
        DomRange domRange = XmlTransferUtils.getOriginalRange(transferDataInfo);
        if (domRange != null && (domPosition.equals((Object)domRange.getStart()) || domPosition.equals((Object)domRange.getEnd()))) {
            return false;
        }
        Selection selection = abstractModel.getSelection();
        DomPosition domPosition5 = selection.getDropLocation();
        boolean bl = domPosition.equals((Object)domPosition5);
        selection.setDropLocation(domPosition);
        XmlTransferUtils.removeOriginalNodes(string, transferDataInfo, domRange, XmlTransferUtils.getOriginalNodes(transferDataInfo), transactionToken, true);
        if (abstractModel instanceof XmlView && (domPosition4 = (xmlView = (XmlView)abstractModel).modelToView(domPosition3 = xmlView.getBaseModel().getSelection().getDropLocation())) != null) {
            selection.setDropLocation(domPosition4);
        }
        if ((domPosition2 = selection.getDropLocation()) == null) {
            return false;
        }
        domPosition = domPosition2;
        if (!bl && (domPosition5 == null || abstractModel.isInModelDocumentHierarchy(domPosition5))) {
            selection.setDropLocation(domPosition5);
        }
        return this._doCopy(string, abstractModel, domPosition, documentFragment, transactionToken);
    }

    private boolean _doCopy(String string, AbstractModel abstractModel, DomPosition domPosition, DocumentFragment documentFragment, TransactionToken transactionToken) throws XmlCommitException {
        Collection collection = CopyOperation.__insertNodes(abstractModel, domPosition, documentFragment, string, transactionToken);
        return collection != null;
    }

    static boolean mav$_doMove(MoveOperation moveOperation, String string, AbstractModel abstractModel, DomPosition domPosition, DocumentFragment documentFragment, TransferDataInfo transferDataInfo, TransactionToken transactionToken) {
        return moveOperation._doMove(string, abstractModel, domPosition, documentFragment, transferDataInfo, transactionToken);
    }

    final class 1
    extends FixedNameTransactionTask {
        private final /* synthetic */ String v$txnName;
        private final /* synthetic */ DomPosition v$pos;
        private final /* synthetic */ DocumentFragment v$fragment;
        private final /* synthetic */ TransferDataInfo v$data;
        private final /* synthetic */ TransactionToken v$token;
        private final /* synthetic */ MutableBoolean v$targetHandledMoveHolder;
        final /* synthetic */ MoveOperation this$0;

        protected void performTask(AbstractModel abstractModel) throws XmlCommitException {
            boolean bl = MoveOperation.mav$_doMove(this.this$0, this.v$txnName, abstractModel, this.v$pos, this.v$fragment, this.v$data, this.v$token);
            this.v$targetHandledMoveHolder.set(true);
            if (!bl) {
                this.cancelTask();
            }
        }

        public 1(MoveOperation moveOperation, String string, String string2, DomPosition domPosition, DocumentFragment documentFragment, TransferDataInfo transferDataInfo, TransactionToken transactionToken, MutableBoolean mutableBoolean) {
            this.v$targetHandledMoveHolder = mutableBoolean;
            this.v$token = transactionToken;
            this.v$data = transferDataInfo;
            this.v$fragment = documentFragment;
            this.v$pos = domPosition;
            this.v$txnName = string2;
            this.this$0 = moveOperation;
            super(string);
        }
    }
}

